/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.ui.internal.cloud.AbstractApplicationDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ApplicationOperationsNodeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ApplicationRegionTypesNodeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.sm.comm.IContext;
import java.util.ArrayList;
import java.util.List;

public class ApplicationStyleApplicationDeferredWorkbenchAdapter
extends AbstractApplicationDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(ApplicationStyleApplicationDeferredWorkbenchAdapter.class);

    ApplicationStyleApplicationDeferredWorkbenchAdapter(CloudInput anInput, IApplication anApplication) {
        super(anInput, anApplication);
    }

    @Override
    public Object[] getDataChildren(Object o) {
        DEBUG.enter("getDataChildren", (Object)this, o);
        ArrayList<Object> headingNodes = new ArrayList<Object>();
        Object applicationPlatform = this.getApplicationPlatform();
        if (applicationPlatform != null) {
            headingNodes.add(applicationPlatform);
        }
        headingNodes.add(new ApplicationOperationsNodeDeferredWorkbenchAdapter(this.getCloudInput(), this.application));
        headingNodes.add(new ApplicationRegionTypesNodeDeferredWorkbenchAdapter(this.getCloudInput(), this.application));
        Object[] children = headingNodes.toArray();
        DEBUG.exit("getDataChildren", (Object)children);
        return children;
    }

    private Object getApplicationPlatform() {
        DEBUG.enter("getApplicationPlatform", (Object)this);
        FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), PlatformType.PLATFORM_DEFINITION_NAME, this.application.getPlatformDefinitionName());
        try {
            List results = this.getCICSObjects(PlatformType.getInstance(), (IContext)filteredContext);
            if (results.size() > 0) {
                if (results.size() > 1) {
                    DEBUG.event("getApplicationPlatform - more than one result", results);
                }
                DEBUG.exit("getApplicationPlatform", results.get(0));
                return results.get(0);
            }
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() != null) {
                DEBUG.event("getApplicationPlatform", (Object)e);
                return new ErrorWrapper(e.getCause());
            }
            DEBUG.error("getApplicationPlatform", (Throwable)e);
        }
        DEBUG.exit("getApplicationPlatform", null);
        return null;
    }
}

