/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.ui.internal.cloud.AbstractRegionTypesNodeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.sm.comm.IContext;
import java.util.ArrayList;
import java.util.List;

final class PlatformRegionTypesNodeDeferredWorkbenchAdapter
extends AbstractRegionTypesNodeDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(PlatformRegionTypesNodeDeferredWorkbenchAdapter.class);
    private final IPlatform platform;

    PlatformRegionTypesNodeDeferredWorkbenchAdapter(Object anInput, IPlatform aPlatform) {
        super((CloudInput)anInput);
        DEBUG.enter("constructor", (Object)this, (Object)aPlatform);
        this.platform = aPlatform;
        DEBUG.exit("constructor");
    }

    @Override
    public Object[] getDataChildren(Object o) {
        DEBUG.enter("getDataChildren", (Object)this, o);
        FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), CICSRegionGroupDefinitionType.PLATDEF, this.platform.getPlatformDefinitionName());
        ArrayList<ICICSObject> listRegionTypes = new ArrayList<ICICSObject>();
        Object[] children = new Object[]{};
        try {
            List results = this.getCICSObjects(CICSRegionGroupDefinitionType.getInstance(), (IContext)filteredContext);
            for (ICICSObject item : results) {
                if (((ICICSRegionGroupDefinition)item).getRegiontype().length() <= 0) continue;
                listRegionTypes.add(item);
            }
            children = listRegionTypes.toArray();
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() != null) {
                DEBUG.event("getDataChildren", (Object)e);
                children = new Object[]{new ErrorWrapper(e.getCause())};
            }
            DEBUG.error("getDataChildren", (Throwable)e);
        }
        DEBUG.exit("getDataChildren", (Object)children);
        return children;
    }

    public IPlatform getPlatform() {
        return this.platform;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformRegionTypesNodeDeferredWorkbenchAdapter other = (PlatformRegionTypesNodeDeferredWorkbenchAdapter)obj;
        return !(this.platform == null ? other.platform != null : !EqualityHelper.equals((ICICSObject)this.platform, (ICICSObject)other.platform));
    }
}

