/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.cpsm;

import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.cpsm.CPSMRecord;
import java.io.UnsupportedEncodingException;

public class CPSMResponse
extends SMConnectionResponse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String resourceType;
    private IContext context;
    private String stub;
    private String status;
    private String response;
    private int recordTotal;
    private SMConnectionRecord[] records;
    private int start;

    public CPSMResponse() {
        this.status = "OK";
        this.response = "OK";
    }

    public CPSMResponse(String stub, String resourceType, String status, String response, String reason, IContext context) {
        this.resourceType = resourceType;
        this.stub = stub;
        this.status = status;
        this.response = response;
        this.response = reason;
        this.context = context;
    }

    public CPSMResponse(String stub, String resourceType, IContext context, String status, String response, int total) {
        this.resourceType = resourceType;
        this.context = context;
        this.stub = stub;
        this.status = status;
        this.response = response;
        this.recordTotal = total;
    }

    public CPSMResponse(String stub, String resourceType, IContext context, int start, String[] data) throws UnsupportedEncodingException {
        this.resourceType = resourceType;
        this.context = context;
        this.stub = stub;
        this.status = "OK";
        this.start = start;
        this.records = this.parseData(resourceType, data);
    }

    private SMConnectionRecord[] parseData(String resourceType, String[] data) throws UnsupportedEncodingException {
        SMConnectionRecord[] records = new SMConnectionRecord[data.length];
        int i = 0;
        while (i < data.length) {
            records[i] = new CPSMRecord(resourceType, data[i], this.context);
            ++i;
        }
        return records;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public IContext getContext() {
        return this.context;
    }

    public String getStub() {
        return this.stub;
    }

    public int getRecordCount() {
        if (this.records == null) {
            return 0;
        }
        return this.records.length;
    }

    public SMConnectionRecord getRecord(int index) {
        return this.records[index];
    }

    public String toString() {
        return "CPSMResponse[" + this.stub + ", " + this.resourceType + ", " + this.context + ", " + this.getRecordCount() + "]";
    }

    public int getRecordTotal() {
        return this.recordTotal;
    }

    public int getRecordStart() {
        return this.start;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResponse() {
        return this.response;
    }
}

