/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.LSRPoolReference;
import com.ibm.cics.core.model.LSRPoolType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.ILSRPool;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;
import java.util.Map;

public class LSRPool
extends CICSResource
implements ILSRPool {
    private String _createtime;
    private String _deletetime;
    private Long _maxkeylen;
    private Long _totstrings;
    private Long _peakwaitreq;
    private Long _maxccurstr;
    private Long _totwaitreq;
    private Long _dbuffcnt;
    private Long _dhiperbuf;
    private Long _dblookaside;
    private Long _dbread;
    private Long _dbuiwrite;
    private Long _dbnuwrite;
    private Long _dcread;
    private Long _dcwrite;
    private Long _dfailcread;
    private Long _dfailcwrite;
    private Long _ibuffcnt;
    private Long _idhiperbuf;
    private Long _iblookaside;
    private Long _ibreads;
    private Long _ibuiwrite;
    private Long _ibnuwrite;
    private Long _icread;
    private Long _icwrite;
    private Long _ifailcread;
    private Long _ifailcwrite;
    private Long _lsrpoolid;
    private String _idxdatflg;
    private Date _gmtcretime;
    private Date _gmtdeltime;

    public LSRPool(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._createtime = (String)avm.getAttributeValue(LSRPoolType.CREATE_TIME, true);
        this._deletetime = (String)avm.getAttributeValue(LSRPoolType.LOCAL_DELETE_TIME, true);
        this._maxkeylen = (Long)avm.getAttributeValue(LSRPoolType.MAXIMUM_KEY_LENGTH, true);
        this._totstrings = (Long)avm.getAttributeValue(LSRPoolType.TOTAL_STRINGS, true);
        this._peakwaitreq = (Long)avm.getAttributeValue(LSRPoolType.PEAK_REQUESTS_WAITING, true);
        this._maxccurstr = (Long)avm.getAttributeValue(LSRPoolType.PEAK_ACTIVE_STRINGS, true);
        this._totwaitreq = (Long)avm.getAttributeValue(LSRPoolType.TOTAL_STRING_WAITS, true);
        this._dbuffcnt = (Long)avm.getAttributeValue(LSRPoolType.DATA_BUFFERS_COUNT, true);
        this._dhiperbuf = (Long)avm.getAttributeValue(LSRPoolType.HIPERSPACE_DATA_BUFFERS_COUNT, true);
        this._dblookaside = (Long)avm.getAttributeValue(LSRPoolType.LOOKASIDE_READS_DATA, true);
        this._dbread = (Long)avm.getAttributeValue(LSRPoolType.READ_IO_DATA, true);
        this._dbuiwrite = (Long)avm.getAttributeValue(LSRPoolType.USER_WRITES_DATA, true);
        this._dbnuwrite = (Long)avm.getAttributeValue(LSRPoolType.NON_USER_WRITES_DATA, true);
        this._dcread = (Long)avm.getAttributeValue(LSRPoolType.SUCCESSFUL_CREADS_DATA, true);
        this._dcwrite = (Long)avm.getAttributeValue(LSRPoolType.SUCCESSFUL_CWRITES_DATA, true);
        this._dfailcread = (Long)avm.getAttributeValue(LSRPoolType.FAILED_CREADS_DATA, true);
        this._dfailcwrite = (Long)avm.getAttributeValue(LSRPoolType.FAILED_CWRITES_DATA, true);
        this._ibuffcnt = (Long)avm.getAttributeValue(LSRPoolType.INDEX_BUFFERS_COUNT, true);
        this._idhiperbuf = (Long)avm.getAttributeValue(LSRPoolType.HIPERSPACE_INDEX_BUFFERS_COUNT, true);
        this._iblookaside = (Long)avm.getAttributeValue(LSRPoolType.LOOKASIDE_READS_INDEX, true);
        this._ibreads = (Long)avm.getAttributeValue(LSRPoolType.INDEX_BUFFER_READS_COUNT, true);
        this._ibuiwrite = (Long)avm.getAttributeValue(LSRPoolType.USER_WRITES_INDEX, true);
        this._ibnuwrite = (Long)avm.getAttributeValue(LSRPoolType.NON_USER_WRITES_INDEX, true);
        this._icread = (Long)avm.getAttributeValue(LSRPoolType.SUCCESSFUL_CREADS_INDEX, true);
        this._icwrite = (Long)avm.getAttributeValue(LSRPoolType.SUCCESSFUL_CWRITES_INDEX, true);
        this._ifailcread = (Long)avm.getAttributeValue(LSRPoolType.FAILED_CREADS_INDEX, true);
        this._ifailcwrite = (Long)avm.getAttributeValue(LSRPoolType.FAILED_CWRITES_INDEX, true);
        this._lsrpoolid = (Long)avm.getAttributeValue(LSRPoolType.LSR_POOL_ID);
        this._idxdatflg = (String)avm.getAttributeValue(LSRPoolType.SEPARATE_DATA_AND_INDEX, true);
        this._gmtcretime = (Date)avm.getAttributeValue(LSRPoolType.GMT_CREATE_TIME, true);
        this._gmtdeltime = (Date)avm.getAttributeValue(LSRPoolType.GMT_DELETE_TIME, true);
    }

    public LSRPool(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("CREATETIME");
        this._createtime = (String)((CICSAttribute)LSRPoolType.CREATE_TIME).get(stringValue, normalizers);
        stringValue = record.get("DELETETIME");
        this._deletetime = (String)((CICSAttribute)LSRPoolType.LOCAL_DELETE_TIME).get(stringValue, normalizers);
        stringValue = record.get("MAXKEYLEN");
        this._maxkeylen = (Long)((CICSAttribute)LSRPoolType.MAXIMUM_KEY_LENGTH).get(stringValue, normalizers);
        stringValue = record.get("TOTSTRINGS");
        this._totstrings = (Long)((CICSAttribute)LSRPoolType.TOTAL_STRINGS).get(stringValue, normalizers);
        stringValue = record.get("PEAKWAITREQ");
        this._peakwaitreq = (Long)((CICSAttribute)LSRPoolType.PEAK_REQUESTS_WAITING).get(stringValue, normalizers);
        stringValue = record.get("MAXCCURSTR");
        this._maxccurstr = (Long)((CICSAttribute)LSRPoolType.PEAK_ACTIVE_STRINGS).get(stringValue, normalizers);
        stringValue = record.get("TOTWAITREQ");
        this._totwaitreq = (Long)((CICSAttribute)LSRPoolType.TOTAL_STRING_WAITS).get(stringValue, normalizers);
        stringValue = record.get("DBUFFCNT");
        this._dbuffcnt = (Long)((CICSAttribute)LSRPoolType.DATA_BUFFERS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("DHIPERBUF");
        this._dhiperbuf = (Long)((CICSAttribute)LSRPoolType.HIPERSPACE_DATA_BUFFERS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("DBLOOKASIDE");
        this._dblookaside = (Long)((CICSAttribute)LSRPoolType.LOOKASIDE_READS_DATA).get(stringValue, normalizers);
        stringValue = record.get("DBREAD");
        this._dbread = (Long)((CICSAttribute)LSRPoolType.READ_IO_DATA).get(stringValue, normalizers);
        stringValue = record.get("DBUIWRITE");
        this._dbuiwrite = (Long)((CICSAttribute)LSRPoolType.USER_WRITES_DATA).get(stringValue, normalizers);
        stringValue = record.get("DBNUWRITE");
        this._dbnuwrite = (Long)((CICSAttribute)LSRPoolType.NON_USER_WRITES_DATA).get(stringValue, normalizers);
        stringValue = record.get("DCREAD");
        this._dcread = (Long)((CICSAttribute)LSRPoolType.SUCCESSFUL_CREADS_DATA).get(stringValue, normalizers);
        stringValue = record.get("DCWRITE");
        this._dcwrite = (Long)((CICSAttribute)LSRPoolType.SUCCESSFUL_CWRITES_DATA).get(stringValue, normalizers);
        stringValue = record.get("DFAILCREAD");
        this._dfailcread = (Long)((CICSAttribute)LSRPoolType.FAILED_CREADS_DATA).get(stringValue, normalizers);
        stringValue = record.get("DFAILCWRITE");
        this._dfailcwrite = (Long)((CICSAttribute)LSRPoolType.FAILED_CWRITES_DATA).get(stringValue, normalizers);
        stringValue = record.get("IBUFFCNT");
        this._ibuffcnt = (Long)((CICSAttribute)LSRPoolType.INDEX_BUFFERS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("IDHIPERBUF");
        this._idhiperbuf = (Long)((CICSAttribute)LSRPoolType.HIPERSPACE_INDEX_BUFFERS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("IBLOOKASIDE");
        this._iblookaside = (Long)((CICSAttribute)LSRPoolType.LOOKASIDE_READS_INDEX).get(stringValue, normalizers);
        stringValue = record.get("IBREADS");
        this._ibreads = (Long)((CICSAttribute)LSRPoolType.INDEX_BUFFER_READS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("IBUIWRITE");
        this._ibuiwrite = (Long)((CICSAttribute)LSRPoolType.USER_WRITES_INDEX).get(stringValue, normalizers);
        stringValue = record.get("IBNUWRITE");
        this._ibnuwrite = (Long)((CICSAttribute)LSRPoolType.NON_USER_WRITES_INDEX).get(stringValue, normalizers);
        stringValue = record.get("ICREAD");
        this._icread = (Long)((CICSAttribute)LSRPoolType.SUCCESSFUL_CREADS_INDEX).get(stringValue, normalizers);
        stringValue = record.get("ICWRITE");
        this._icwrite = (Long)((CICSAttribute)LSRPoolType.SUCCESSFUL_CWRITES_INDEX).get(stringValue, normalizers);
        stringValue = record.get("IFAILCREAD");
        this._ifailcread = (Long)((CICSAttribute)LSRPoolType.FAILED_CREADS_INDEX).get(stringValue, normalizers);
        stringValue = record.get("IFAILCWRITE");
        this._ifailcwrite = (Long)((CICSAttribute)LSRPoolType.FAILED_CWRITES_INDEX).get(stringValue, normalizers);
        stringValue = record.get("LSRPOOLID");
        this._lsrpoolid = (Long)((CICSAttribute)LSRPoolType.LSR_POOL_ID).get(stringValue, normalizers);
        stringValue = record.get("IDXDATFLG");
        this._idxdatflg = (String)((CICSAttribute)LSRPoolType.SEPARATE_DATA_AND_INDEX).get(stringValue, normalizers);
        stringValue = record.get("GMTCRETIME");
        this._gmtcretime = (Date)((CICSAttribute)LSRPoolType.GMT_CREATE_TIME).get(stringValue, normalizers);
        stringValue = record.get("GMTDELTIME");
        this._gmtdeltime = (Date)((CICSAttribute)LSRPoolType.GMT_DELETE_TIME).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return LSRPoolType.LSR_POOL_ID.internalToExternal((Object)this.getLSRPoolID());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getCreateTime() {
        return this._createtime;
    }

    public String getLocalDeleteTime() {
        return this._deletetime;
    }

    public Long getMaximumKeyLength() {
        return this._maxkeylen;
    }

    public Long getTotalStrings() {
        return this._totstrings;
    }

    public Long getPeakRequestsWaiting() {
        return this._peakwaitreq;
    }

    public Long getPeakActiveStrings() {
        return this._maxccurstr;
    }

    public Long getTotalStringWaits() {
        return this._totwaitreq;
    }

    public Long getDataBuffersCount() {
        return this._dbuffcnt;
    }

    public Long getHiperspaceDataBuffersCount() {
        return this._dhiperbuf;
    }

    public Long getLookasideReadsData() {
        return this._dblookaside;
    }

    public Long getReadIOData() {
        return this._dbread;
    }

    public Long getUserWritesData() {
        return this._dbuiwrite;
    }

    public Long getNonUserWritesData() {
        return this._dbnuwrite;
    }

    public Long getSuccessfulCreadsData() {
        return this._dcread;
    }

    public Long getSuccessfulCwritesData() {
        return this._dcwrite;
    }

    public Long getFailedCreadsData() {
        return this._dfailcread;
    }

    public Long getFailedCwritesData() {
        return this._dfailcwrite;
    }

    public Long getIndexBuffersCount() {
        return this._ibuffcnt;
    }

    public Long getHiperspaceIndexBuffersCount() {
        return this._idhiperbuf;
    }

    public Long getLookasideReadsIndex() {
        return this._iblookaside;
    }

    public Long getIndexBufferReadsCount() {
        return this._ibreads;
    }

    public Long getUserWritesIndex() {
        return this._ibuiwrite;
    }

    public Long getNonUserWritesIndex() {
        return this._ibnuwrite;
    }

    public Long getSuccessfulCreadsIndex() {
        return this._icread;
    }

    public Long getSuccessfulCwritesIndex() {
        return this._icwrite;
    }

    public Long getFailedCreadsIndex() {
        return this._ifailcread;
    }

    public Long getFailedCwritesIndex() {
        return this._ifailcwrite;
    }

    public Long getLSRPoolID() {
        return this._lsrpoolid;
    }

    public String getSeparateDataAndIndex() {
        return this._idxdatflg;
    }

    public Date getGMTCreateTime() {
        return this._gmtcretime;
    }

    public Date getGMTDeleteTime() {
        return this._gmtdeltime;
    }

    public LSRPoolType getObjectType() {
        return LSRPoolType.getInstance();
    }

    @Override
    public LSRPoolReference getCICSObjectReference() {
        return new LSRPoolReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == LSRPoolType.CREATE_TIME) {
            return (V)this.getCreateTime();
        }
        if (attribute == LSRPoolType.LOCAL_DELETE_TIME) {
            return (V)this.getLocalDeleteTime();
        }
        if (attribute == LSRPoolType.MAXIMUM_KEY_LENGTH) {
            return (V)this.getMaximumKeyLength();
        }
        if (attribute == LSRPoolType.TOTAL_STRINGS) {
            return (V)this.getTotalStrings();
        }
        if (attribute == LSRPoolType.PEAK_REQUESTS_WAITING) {
            return (V)this.getPeakRequestsWaiting();
        }
        if (attribute == LSRPoolType.PEAK_ACTIVE_STRINGS) {
            return (V)this.getPeakActiveStrings();
        }
        if (attribute == LSRPoolType.TOTAL_STRING_WAITS) {
            return (V)this.getTotalStringWaits();
        }
        if (attribute == LSRPoolType.DATA_BUFFERS_COUNT) {
            return (V)this.getDataBuffersCount();
        }
        if (attribute == LSRPoolType.HIPERSPACE_DATA_BUFFERS_COUNT) {
            return (V)this.getHiperspaceDataBuffersCount();
        }
        if (attribute == LSRPoolType.LOOKASIDE_READS_DATA) {
            return (V)this.getLookasideReadsData();
        }
        if (attribute == LSRPoolType.READ_IO_DATA) {
            return (V)this.getReadIOData();
        }
        if (attribute == LSRPoolType.USER_WRITES_DATA) {
            return (V)this.getUserWritesData();
        }
        if (attribute == LSRPoolType.NON_USER_WRITES_DATA) {
            return (V)this.getNonUserWritesData();
        }
        if (attribute == LSRPoolType.SUCCESSFUL_CREADS_DATA) {
            return (V)this.getSuccessfulCreadsData();
        }
        if (attribute == LSRPoolType.SUCCESSFUL_CWRITES_DATA) {
            return (V)this.getSuccessfulCwritesData();
        }
        if (attribute == LSRPoolType.FAILED_CREADS_DATA) {
            return (V)this.getFailedCreadsData();
        }
        if (attribute == LSRPoolType.FAILED_CWRITES_DATA) {
            return (V)this.getFailedCwritesData();
        }
        if (attribute == LSRPoolType.INDEX_BUFFERS_COUNT) {
            return (V)this.getIndexBuffersCount();
        }
        if (attribute == LSRPoolType.HIPERSPACE_INDEX_BUFFERS_COUNT) {
            return (V)this.getHiperspaceIndexBuffersCount();
        }
        if (attribute == LSRPoolType.LOOKASIDE_READS_INDEX) {
            return (V)this.getLookasideReadsIndex();
        }
        if (attribute == LSRPoolType.INDEX_BUFFER_READS_COUNT) {
            return (V)this.getIndexBufferReadsCount();
        }
        if (attribute == LSRPoolType.USER_WRITES_INDEX) {
            return (V)this.getUserWritesIndex();
        }
        if (attribute == LSRPoolType.NON_USER_WRITES_INDEX) {
            return (V)this.getNonUserWritesIndex();
        }
        if (attribute == LSRPoolType.SUCCESSFUL_CREADS_INDEX) {
            return (V)this.getSuccessfulCreadsIndex();
        }
        if (attribute == LSRPoolType.SUCCESSFUL_CWRITES_INDEX) {
            return (V)this.getSuccessfulCwritesIndex();
        }
        if (attribute == LSRPoolType.FAILED_CREADS_INDEX) {
            return (V)this.getFailedCreadsIndex();
        }
        if (attribute == LSRPoolType.FAILED_CWRITES_INDEX) {
            return (V)this.getFailedCwritesIndex();
        }
        if (attribute == LSRPoolType.LSR_POOL_ID) {
            return (V)this.getLSRPoolID();
        }
        if (attribute == LSRPoolType.SEPARATE_DATA_AND_INDEX) {
            return (V)this.getSeparateDataAndIndex();
        }
        if (attribute == LSRPoolType.GMT_CREATE_TIME) {
            return (V)this.getGMTCreateTime();
        }
        if (attribute == LSRPoolType.GMT_DELETE_TIME) {
            return (V)this.getGMTDeleteTime();
        }
        return super.getAttributeValue(attribute);
    }
}

