/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.BundleReference;
import com.ibm.cics.core.model.BundleType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.IBundle;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableBundle;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableBundle
extends MutableCICSResource
implements IMutableBundle {
    private IBundle delegate;
    private MutableSMRecord record;

    public MutableBundle(ICPSM cpsm, IContext context, IBundle cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("BUNDLE");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public IBundle.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public IBundle.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public IBundle.StatusValue getStatus() {
        String result = this.record.get("ENABLESTATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (IBundle.StatusValue)((CICSAttribute)BundleType.STATUS).get(result, this.record.getNormalizers());
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public String getBundledir() {
        return this.delegate.getBundledir();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getBasescope() {
        return this.delegate.getBasescope();
    }

    public Long getPartcount() {
        return this.delegate.getPartcount();
    }

    public Long getTargetcount() {
        return this.delegate.getTargetcount();
    }

    public Long getEnabledcount() {
        return this.delegate.getEnabledcount();
    }

    public String getBundleID() {
        return this.delegate.getBundleID();
    }

    public Long getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public Long getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public Long getMicroVersion() {
        return this.delegate.getMicroVersion();
    }

    public String getMgmtpart() {
        return this.delegate.getMgmtpart();
    }

    public IBundle.AvailabilityValue getAvailability() {
        String result = this.record.get("AVAILSTATUS");
        if (result == null) {
            return this.delegate.getAvailability();
        }
        return (IBundle.AvailabilityValue)((CICSAttribute)BundleType.AVAILABILITY).get(result, this.record.getNormalizers());
    }

    public void setStatus(IBundle.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("ENABLESTATUS", null);
        } else {
            BundleType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)BundleType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("ENABLESTATUS", connectionSpecificExternalValue);
        }
    }

    public void setAvailability(IBundle.AvailabilityValue _availability) {
        if (_availability.equals((Object)this.delegate.getAvailability())) {
            this.record.set("AVAILSTATUS", null);
        } else {
            BundleType.AVAILABILITY.validate((Object)_availability);
            String connectionSpecificExternalValue = ((CICSAttribute)BundleType.AVAILABILITY).set(_availability, this.record.getNormalizers());
            this.record.set("AVAILSTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == BundleType.NAME) {
            return (V)this.getName();
        }
        if (attribute == BundleType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == BundleType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == BundleType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == BundleType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == BundleType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == BundleType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == BundleType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == BundleType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == BundleType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == BundleType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == BundleType.BUNDLEDIR) {
            return (V)this.getBundledir();
        }
        if (attribute == BundleType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == BundleType.BASESCOPE) {
            return (V)this.getBasescope();
        }
        if (attribute == BundleType.PARTCOUNT) {
            return (V)this.getPartcount();
        }
        if (attribute == BundleType.TARGETCOUNT) {
            return (V)this.getTargetcount();
        }
        if (attribute == BundleType.ENABLEDCOUNT) {
            return (V)this.getEnabledcount();
        }
        if (attribute == BundleType.BUNDLE_ID) {
            return (V)this.getBundleID();
        }
        if (attribute == BundleType.MAJOR_VERSION) {
            return (V)this.getMajorVersion();
        }
        if (attribute == BundleType.MINOR_VERSION) {
            return (V)this.getMinorVersion();
        }
        if (attribute == BundleType.MICRO_VERSION) {
            return (V)this.getMicroVersion();
        }
        if (attribute == BundleType.MGMTPART) {
            return (V)this.getMgmtpart();
        }
        if (attribute == BundleType.AVAILABILITY) {
            return (V)this.getAvailability();
        }
        return super.getAttributeValue(attribute);
    }

    public BundleType getObjectType() {
        return BundleType.getInstance();
    }

    @Override
    public BundleReference getCICSObjectReference() {
        return new BundleReference(this.getCICSContainer(), this.getName());
    }
}

