/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.SystemDumpReference;
import com.ibm.cics.core.model.SystemDumpType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ISystemDump;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableSystemDump;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableSystemDump
extends MutableCICSResource
implements IMutableSystemDump {
    private ISystemDump delegate;
    private MutableSMRecord record;

    public MutableSystemDump(ICPSM cpsm, IContext context, ISystemDump cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("SYSDUMP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getSystemDumpCode() {
        return this.delegate.getSystemDumpCode();
    }

    public Long getSystemDumpsSinceReset() {
        return this.delegate.getSystemDumpsSinceReset();
    }

    public Long getMaximumSystemDumps() {
        String result = this.record.get("MAXIMUM");
        if (result == null) {
            return this.delegate.getMaximumSystemDumps();
        }
        return (Long)((CICSAttribute)SystemDumpType.MAXIMUM_SYSTEM_DUMPS).get(result, this.record.getNormalizers());
    }

    public ISystemDump.ShutdownOptionValue getShutdownOption() {
        String result = this.record.get("SHUTOPTION");
        if (result == null) {
            return this.delegate.getShutdownOption();
        }
        return (ISystemDump.ShutdownOptionValue)((CICSAttribute)SystemDumpType.SHUTDOWN_OPTION).get(result, this.record.getNormalizers());
    }

    public ISystemDump.SystemDumpOptionValue getSystemDumpOption() {
        String result = this.record.get("SYSDUMPING");
        if (result == null) {
            return this.delegate.getSystemDumpOption();
        }
        return (ISystemDump.SystemDumpOptionValue)((CICSAttribute)SystemDumpType.SYSTEM_DUMP_OPTION).get(result, this.record.getNormalizers());
    }

    public Long getSystemDumpsTaken() {
        return this.delegate.getSystemDumpsTaken();
    }

    public Long getSystemDumpsSuppressed() {
        return this.delegate.getSystemDumpsSuppressed();
    }

    public ISystemDump.SystemDumpScopeValue getSystemDumpScope() {
        String result = this.record.get("SDUMPSCOPE");
        if (result == null) {
            return this.delegate.getSystemDumpScope();
        }
        return (ISystemDump.SystemDumpScopeValue)((CICSAttribute)SystemDumpType.SYSTEM_DUMP_SCOPE).get(result, this.record.getNormalizers());
    }

    public ISystemDump.DAEOptionValue getDAEOption() {
        String result = this.record.get("DAEOPTION");
        if (result == null) {
            return this.delegate.getDAEOption();
        }
        return (ISystemDump.DAEOptionValue)((CICSAttribute)SystemDumpType.DAE_OPTION).get(result, this.record.getNormalizers());
    }

    public String getJobNameList() {
        return this.delegate.getJobNameList();
    }

    public String getDataSpaceNameList() {
        return this.delegate.getDataSpaceNameList();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public ISystemDump.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public ISystemDump.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public void setMaximumSystemDumps(Long _maximumSystemDumps) {
        if (_maximumSystemDumps.equals(this.delegate.getMaximumSystemDumps())) {
            this.record.set("MAXIMUM", null);
        } else {
            SystemDumpType.MAXIMUM_SYSTEM_DUMPS.validate((Object)_maximumSystemDumps);
            String connectionSpecificExternalValue = ((CICSAttribute)SystemDumpType.MAXIMUM_SYSTEM_DUMPS).set(_maximumSystemDumps, this.record.getNormalizers());
            this.record.set("MAXIMUM", connectionSpecificExternalValue);
        }
    }

    public void setShutdownOption(ISystemDump.ShutdownOptionValue _shutdownOption) {
        if (_shutdownOption.equals((Object)this.delegate.getShutdownOption())) {
            this.record.set("SHUTOPTION", null);
        } else {
            SystemDumpType.SHUTDOWN_OPTION.validate((Object)_shutdownOption);
            String connectionSpecificExternalValue = ((CICSAttribute)SystemDumpType.SHUTDOWN_OPTION).set(_shutdownOption, this.record.getNormalizers());
            this.record.set("SHUTOPTION", connectionSpecificExternalValue);
        }
    }

    public void setSystemDumpOption(ISystemDump.SystemDumpOptionValue _systemDumpOption) {
        if (_systemDumpOption.equals((Object)this.delegate.getSystemDumpOption())) {
            this.record.set("SYSDUMPING", null);
        } else {
            SystemDumpType.SYSTEM_DUMP_OPTION.validate((Object)_systemDumpOption);
            String connectionSpecificExternalValue = ((CICSAttribute)SystemDumpType.SYSTEM_DUMP_OPTION).set(_systemDumpOption, this.record.getNormalizers());
            this.record.set("SYSDUMPING", connectionSpecificExternalValue);
        }
    }

    public void setSystemDumpScope(ISystemDump.SystemDumpScopeValue _systemDumpScope) {
        if (_systemDumpScope.equals((Object)this.delegate.getSystemDumpScope())) {
            this.record.set("SDUMPSCOPE", null);
        } else {
            SystemDumpType.SYSTEM_DUMP_SCOPE.validate((Object)_systemDumpScope);
            String connectionSpecificExternalValue = ((CICSAttribute)SystemDumpType.SYSTEM_DUMP_SCOPE).set(_systemDumpScope, this.record.getNormalizers());
            this.record.set("SDUMPSCOPE", connectionSpecificExternalValue);
        }
    }

    public void setDAEOption(ISystemDump.DAEOptionValue _DAEOption) {
        if (_DAEOption.equals((Object)this.delegate.getDAEOption())) {
            this.record.set("DAEOPTION", null);
        } else {
            SystemDumpType.DAE_OPTION.validate((Object)_DAEOption);
            String connectionSpecificExternalValue = ((CICSAttribute)SystemDumpType.DAE_OPTION).set(_DAEOption, this.record.getNormalizers());
            this.record.set("DAEOPTION", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == SystemDumpType.SYSTEM_DUMP_CODE) {
            return (V)this.getSystemDumpCode();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMPS_SINCE_RESET) {
            return (V)this.getSystemDumpsSinceReset();
        }
        if (attribute == SystemDumpType.MAXIMUM_SYSTEM_DUMPS) {
            return (V)this.getMaximumSystemDumps();
        }
        if (attribute == SystemDumpType.SHUTDOWN_OPTION) {
            return (V)this.getShutdownOption();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMP_OPTION) {
            return (V)this.getSystemDumpOption();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMPS_TAKEN) {
            return (V)this.getSystemDumpsTaken();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMPS_SUPPRESSED) {
            return (V)this.getSystemDumpsSuppressed();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMP_SCOPE) {
            return (V)this.getSystemDumpScope();
        }
        if (attribute == SystemDumpType.DAE_OPTION) {
            return (V)this.getDAEOption();
        }
        if (attribute == SystemDumpType.JOB_NAME_LIST) {
            return (V)this.getJobNameList();
        }
        if (attribute == SystemDumpType.DATA_SPACE_NAME_LIST) {
            return (V)this.getDataSpaceNameList();
        }
        if (attribute == SystemDumpType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == SystemDumpType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == SystemDumpType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == SystemDumpType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == SystemDumpType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == SystemDumpType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == SystemDumpType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == SystemDumpType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == SystemDumpType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        return super.getAttributeValue(attribute);
    }

    public SystemDumpType getObjectType() {
        return SystemDumpType.getInstance();
    }

    @Override
    public SystemDumpReference getCICSObjectReference() {
        return new SystemDumpReference(this.getCICSContainer(), this.getSystemDumpCode());
    }
}

