/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadGroupReference;
import com.ibm.cics.core.model.WorkloadGroupType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IWorkloadDefinitionInWorkloadGroup;
import com.ibm.cics.model.IWorkloadGroup;
import com.ibm.cics.model.IWorkloadGroupInWorkloadSpecification;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableWorkloadGroup;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableWorkloadGroup
extends MutableCPSMDefinition
implements IMutableWorkloadGroup {
    private IWorkloadGroup delegate;
    private MutableSMRecord record;

    public MutableWorkloadGroup(ICPSM cpsm, IContext context, IWorkloadGroup cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("WLMGROUP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public IWorkloadGroup.ChangeAgentValue getChangeAgent() {
        String result = this.record.get("CHANGEAGENT");
        if (result == null) {
            return this.delegate.getChangeAgent();
        }
        return (IWorkloadGroup.ChangeAgentValue)((CICSAttribute)WorkloadGroupType.CHANGE_AGENT).get(result, this.record.getNormalizers());
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getDescription() {
        String result = this.record.get("DESC");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)WorkloadGroupType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public void setChangeAgent(IWorkloadGroup.ChangeAgentValue _changeAgent) {
        if (_changeAgent.equals((Object)this.delegate.getChangeAgent())) {
            this.record.set("CHANGEAGENT", null);
        } else {
            WorkloadGroupType.CHANGE_AGENT.validate((Object)_changeAgent);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadGroupType.CHANGE_AGENT).set(_changeAgent, this.record.getNormalizers());
            this.record.set("CHANGEAGENT", connectionSpecificExternalValue);
        }
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESC", null);
        } else {
            WorkloadGroupType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)WorkloadGroupType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESC", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadGroupType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == WorkloadGroupType.NAME) {
            return (V)this.getName();
        }
        if (attribute == WorkloadGroupType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        return super.getAttributeValue(attribute);
    }

    public WorkloadGroupType getObjectType() {
        return WorkloadGroupType.getInstance();
    }

    @Override
    public WorkloadGroupReference getCICSObjectReference() {
        return new WorkloadGroupReference(this.getCICSContainer(), this.getName());
    }

    public ICICSObjectSet<IWorkloadDefinitionInWorkloadGroup> getDefinitionMembers() {
        return WorkloadGroupType.DEFINITION_MEMBERS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IWorkloadGroupInWorkloadSpecification> getSpecMemberships() {
        return WorkloadGroupType.SPEC_MEMBERSHIPS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

