/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonElement;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.query.CICSObjectQuery;
import com.ibm.cics.model.query.CICSObjectRecordsQuery;
import com.ibm.cics.model.query.CICSplexQuery;
import com.ibm.cics.model.query.CSDQuery;
import com.ibm.cics.model.query.DREPQuery;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.model.query.Query;
import com.ibm.cics.model.query.QueryResult;
import com.ibm.cics.model.query.RegionGroupQuery;
import com.ibm.cics.model.query.RegionQuery;
import com.ibm.cics.model.query.Request;
import com.ibm.cics.sm.comm.sm.internal.graphql.DocumentContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.DocumentParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseException;
import com.ibm.cics.sm.comm.sm.internal.query.AggregationMeta;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectRecordsQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CICSplexQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CSDQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.DREPQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.QueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.RegionGroupQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.RegionQueryImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class RequestImpl
implements Request {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018, 2019 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private DocumentContext<QueryResult, QueryImpl> d;
    private DocumentParser<QueryResult> parser;
    private Map<ICICSType<?>, AggregationMeta> aggregationMeta;

    public RequestImpl(Map<ICICSType<?>, AggregationMeta> aggregationMeta) {
        this.aggregationMeta = aggregationMeta;
        this.d = new DocumentContext(new QueryImpl(aggregationMeta));
    }

    public String build() {
        return this.d.buildDocument();
    }

    public QueryResult parse(JsonElement document) throws DocumentParser.QueryFailureException, QueryPartialFailureWithErrorsException, DocumentParser.QueryFailureWithErrorsException, NodeParseException {
        if (this.parser == null) {
            throw new IllegalStateException("No query made");
        }
        DocumentParser.Result<QueryResult> result = this.parser.parse(document);
        if (result.hasErrors()) {
            throw new QueryPartialFailureWithErrorsException(result.getResult(), result.getErrors());
        }
        return result.getResult();
    }

    public Request query(String name, Consumer<Query> query) {
        if (this.parser != null) {
            throw new IllegalStateException("query already called");
        }
        this.parser = this.d.query(name, query);
        return this;
    }

    public FragmentReference<DREPQuery> basQueryFragment(String id, Consumer<DREPQuery> fragment) {
        return this.d.registerFragment(id, new DREPQueryImpl(this.aggregationMeta), fragment);
    }

    public FragmentReference<CICSplexQuery> cicsPlexQueryFragment(String id, Consumer<CICSplexQuery> fragment) {
        return this.d.registerFragment(id, new CICSplexQueryImpl(this.aggregationMeta), fragment);
    }

    public FragmentReference<CSDQuery> csdQueryFragment(String id, Consumer<CSDQuery> fragment) {
        return this.d.registerFragment(id, new CSDQueryImpl(this.aggregationMeta), fragment);
    }

    public FragmentReference<Query> queryFragment(String id, Consumer<Query> fragment) {
        return this.d.registerFragment(id, new QueryImpl(this.aggregationMeta), fragment);
    }

    public FragmentReference<RegionGroupQuery> regionGroupQueryFragment(String id, Consumer<RegionGroupQuery> fragment) {
        return this.d.registerFragment(id, new RegionGroupQueryImpl(this.aggregationMeta), fragment);
    }

    public FragmentReference<RegionQuery> regionQueryFragment(String id, Consumer<RegionQuery> fragment) {
        return this.d.registerFragment(id, new RegionQueryImpl(this.aggregationMeta), fragment);
    }

    public <T extends ICICSResource> FragmentReference<CICSObjectQuery<T>> cicsResourceQueryFragment(String id, ICICSType<T> type, Consumer<CICSObjectQuery<T>> fragment) {
        return this.d.registerFragment(id, new CICSObjectQueryImpl<T>(type, this.aggregationMeta), fragment);
    }

    public <T extends ICPSMDefinition> FragmentReference<CICSObjectQuery<T>> cpsmDefinitionQueryFragment(String id, ICICSType<T> type, Consumer<CICSObjectQuery<T>> fragment) {
        return this.d.registerFragment(id, new CICSObjectQueryImpl<T>(type, this.aggregationMeta), fragment);
    }

    public <T extends ICICSDefinition> FragmentReference<CICSObjectQuery<T>> cicsDefinitionQueryFragment(String id, ICICSType<T> type, Consumer<CICSObjectQuery<T>> fragment) {
        return this.d.registerFragment(id, new CICSObjectQueryImpl<T>(type, this.aggregationMeta), fragment);
    }

    public <T extends ICICSResource> FragmentReference<CICSObjectRecordsQuery<T>> cicsResourceRecordsQueryFragment(String id, ICICSType<T> type, Consumer<CICSObjectRecordsQuery<T>> fragment) {
        return this.d.registerFragment(id, new CICSObjectRecordsQueryImpl<T>(type, this.aggregationMeta), fragment);
    }

    public <T extends ICPSMDefinition> FragmentReference<CICSObjectRecordsQuery<T>> cpsmDefinitionRecordsQueryFragment(String id, ICICSType<T> type, Consumer<CICSObjectRecordsQuery<T>> fragment) {
        return this.d.registerFragment(id, new CICSObjectRecordsQueryImpl<T>(type, this.aggregationMeta), fragment);
    }

    public <T extends ICICSDefinition> FragmentReference<CICSObjectRecordsQuery<T>> cicsDefinitionRecordsQueryFragment(String id, ICICSType<T> type, Consumer<CICSObjectRecordsQuery<T>> fragment) {
        return this.d.registerFragment(id, new CICSObjectRecordsQueryImpl<T>(type, this.aggregationMeta), fragment);
    }

    public static class QueryPartialFailureWithErrorsException
    extends DocumentParser.QueryFailureException {
        private final List<DocumentParser.GraphQLError> errors;
        private final QueryResult result;

        public QueryPartialFailureWithErrorsException(QueryResult result, List<DocumentParser.GraphQLError> errors) {
            super("Query partially failed with error responses");
            this.result = result;
            this.errors = errors;
        }

        public List<DocumentParser.GraphQLError> getErrors() {
            return this.errors;
        }

        public QueryResult getResult() {
            return this.result;
        }
    }
}

