/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.GenTypeClasses;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CICSTypesRegistry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug debug = new Debug(CICSTypesRegistry.class);

    public static ICICSType<?> findForResourceTableName(String resourceTableName) {
        Class typeClass = GenTypeClasses.getCICSTypeClassForResourceTableName(resourceTableName);
        return typeClass != null ? CICSTypesRegistry.getCICSTypeInstance(typeClass) : null;
    }

    public static <T extends ICICSObject> ICICSType<T> getCICSTypeInstance(Class<? extends ICICSType<?>> clazz) {
        try {
            Method method = clazz.getMethod("getInstance", null);
            return (ICICSType)method.invoke(clazz, null);
        }
        catch (SecurityException e) {
            debug.warning("getCICSTypeInstance", clazz, (Object)e);
            return null;
        }
        catch (NoSuchMethodException e) {
            debug.warning("getCICSTypeInstance", clazz, (Object)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            debug.warning("getCICSTypeInstance", clazz, (Object)e);
            return null;
        }
        catch (IllegalAccessException e) {
            debug.warning("getCICSTypeInstance", clazz, (Object)e);
            return null;
        }
        catch (InvocationTargetException e) {
            debug.warning("getCICSTypeInstance", clazz, (Object)e);
            return null;
        }
    }
}

