/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.AbstractCSDDefinitionType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.CICSObjectReference;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.internal.CICSObject;
import com.ibm.cics.core.model.internal.CSDDefinitionContainer;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.ICSDDefinition;
import com.ibm.cics.model.ICSDDefinitionContainer;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class CSDDefinition
extends CICSObject
implements ICSDDefinition,
ICoreObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICSDDefinitionContainer container;
    private static final String CICSSYS = "CICSSYS";
    private final String _cicssys;

    public CSDDefinition(ICSDDefinitionContainer container, AttributeValueMap avm) {
        super((ICICSObjectContainer<?>)container);
        this.container = container;
        this._cicssys = (String)avm.getAttributeValue(AbstractCSDDefinitionType.CICS_SYSTEM, true);
    }

    public CSDDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get(CICSSYS);
        this.container = new CSDDefinitionContainer(cpsm, context);
        this._cicssys = (String)((CICSAttribute)AbstractCSDDefinitionType.CICS_SYSTEM).get(stringValue, normalizers);
    }

    public ICSDDefinitionContainer getCICSContainer() {
        return this.container;
    }

    @Override
    public <T> T getAttributeValue(IAttribute<T> attribute) {
        if (AbstractCSDDefinitionType.CICS_SYSTEM == attribute) {
            return (T)this.getCICSSystem();
        }
        return super.getAttributeValue(attribute);
    }

    @Override
    public abstract CICSObjectReference<? extends ICSDDefinition> getCICSObjectReference();

    public String getCICSSystem() {
        return this._cicssys;
    }
}

