/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.FEPINodeDefinitionReference;
import com.ibm.cics.core.model.FEPINodeDefinitionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.IFEPINodeDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class FEPINodeDefinition
extends CICSDefinition
implements IFEPINodeDefinition {
    private IFEPINodeDefinition.ChangeAgentValue _changeagent;
    private String _userdata1;
    private String _userdata2;
    private String _userdata3;
    private IFEPINodeDefinition.AcquiredStatusValue _acqstatus;
    private IFEPINodeDefinition.NodeServiceStatusValue _servstatus;
    private String _passwords;
    private String _nodelist;

    public FEPINodeDefinition(ICICSDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._changeagent = (IFEPINodeDefinition.ChangeAgentValue)avm.getAttributeValue(FEPINodeDefinitionType.CHANGE_AGENT, true);
        this._userdata1 = (String)avm.getAttributeValue(FEPINodeDefinitionType.USER_DATA_AREA_1, true);
        this._userdata2 = (String)avm.getAttributeValue(FEPINodeDefinitionType.USER_DATA_AREA_2, true);
        this._userdata3 = (String)avm.getAttributeValue(FEPINodeDefinitionType.USER_DATA_AREA_3, true);
        this._acqstatus = (IFEPINodeDefinition.AcquiredStatusValue)avm.getAttributeValue(FEPINodeDefinitionType.ACQUIRED_STATUS, true);
        this._servstatus = (IFEPINodeDefinition.NodeServiceStatusValue)avm.getAttributeValue(FEPINodeDefinitionType.NODE_SERVICE_STATUS, true);
        this._passwords = (String)avm.getAttributeValue(FEPINodeDefinitionType.PASSWORD_LIST, true);
        this._nodelist = (String)avm.getAttributeValue(FEPINodeDefinitionType.NODE_LIST, true);
    }

    public FEPINodeDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("CHANGEAGENT");
        this._changeagent = (IFEPINodeDefinition.ChangeAgentValue)((CICSAttribute)FEPINodeDefinitionType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get("USERDATA1");
        this._userdata1 = (String)((CICSAttribute)FEPINodeDefinitionType.USER_DATA_AREA_1).get(stringValue, normalizers);
        stringValue = record.get("USERDATA2");
        this._userdata2 = (String)((CICSAttribute)FEPINodeDefinitionType.USER_DATA_AREA_2).get(stringValue, normalizers);
        stringValue = record.get("USERDATA3");
        this._userdata3 = (String)((CICSAttribute)FEPINodeDefinitionType.USER_DATA_AREA_3).get(stringValue, normalizers);
        stringValue = record.get("ACQSTATUS");
        this._acqstatus = (IFEPINodeDefinition.AcquiredStatusValue)((CICSAttribute)FEPINodeDefinitionType.ACQUIRED_STATUS).get(stringValue, normalizers);
        stringValue = record.get("SERVSTATUS");
        this._servstatus = (IFEPINodeDefinition.NodeServiceStatusValue)((CICSAttribute)FEPINodeDefinitionType.NODE_SERVICE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("PASSWORDS");
        this._passwords = (String)((CICSAttribute)FEPINodeDefinitionType.PASSWORD_LIST).get(stringValue, normalizers);
        stringValue = record.get("NODELIST");
        this._nodelist = (String)((CICSAttribute)FEPINodeDefinitionType.NODE_LIST).get(stringValue, normalizers);
    }

    public IFEPINodeDefinition.ChangeAgentValue getChangeAgent() {
        return this._changeagent;
    }

    public String getUserDataArea1() {
        return this._userdata1;
    }

    public String getUserDataArea2() {
        return this._userdata2;
    }

    public String getUserDataArea3() {
        return this._userdata3;
    }

    public IFEPINodeDefinition.AcquiredStatusValue getAcquiredStatus() {
        return this._acqstatus;
    }

    public IFEPINodeDefinition.NodeServiceStatusValue getNodeServiceStatus() {
        return this._servstatus;
    }

    public String getPasswordList() {
        return this._passwords;
    }

    public String getNodeList() {
        return this._nodelist;
    }

    public FEPINodeDefinitionType getObjectType() {
        return FEPINodeDefinitionType.getInstance();
    }

    @Override
    public FEPINodeDefinitionReference getCICSObjectReference() {
        return new FEPINodeDefinitionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == FEPINodeDefinitionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == FEPINodeDefinitionType.USER_DATA_AREA_1) {
            return (V)this.getUserDataArea1();
        }
        if (attribute == FEPINodeDefinitionType.USER_DATA_AREA_2) {
            return (V)this.getUserDataArea2();
        }
        if (attribute == FEPINodeDefinitionType.USER_DATA_AREA_3) {
            return (V)this.getUserDataArea3();
        }
        if (attribute == FEPINodeDefinitionType.ACQUIRED_STATUS) {
            return (V)this.getAcquiredStatus();
        }
        if (attribute == FEPINodeDefinitionType.NODE_SERVICE_STATUS) {
            return (V)this.getNodeServiceStatus();
        }
        if (attribute == FEPINodeDefinitionType.PASSWORD_LIST) {
            return (V)this.getPasswordList();
        }
        if (attribute == FEPINodeDefinitionType.NODE_LIST) {
            return (V)this.getNodeList();
        }
        return super.getAttributeValue(attribute);
    }
}

