/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IntrapartitionTDQueueReference;
import com.ibm.cics.core.model.IntrapartitionTDQueueType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IIntrapartitionTDQueue;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableIntrapartitionTDQueue;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableIntrapartitionTDQueue
extends MutableCICSResource
implements IMutableIntrapartitionTDQueue {
    private IIntrapartitionTDQueue delegate;
    private MutableSMRecord record;

    public MutableIntrapartitionTDQueue(ICPSM cpsm, IContext context, IIntrapartitionTDQueue cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("INTRATDQ");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public IIntrapartitionTDQueue.ATIFacilityValue getATIFacility() {
        String result = this.record.get("ATIFACILITY");
        if (result == null) {
            return this.delegate.getATIFacility();
        }
        return (IIntrapartitionTDQueue.ATIFacilityValue)((CICSAttribute)IntrapartitionTDQueueType.ATI_FACILITY).get(result, this.record.getNormalizers());
    }

    public String getATITerminal() {
        String result = this.record.get("ATITERMID");
        if (result == null) {
            return this.delegate.getATITerminal();
        }
        return (String)((CICSAttribute)IntrapartitionTDQueueType.ATI_TERMINAL).get(result, this.record.getNormalizers());
    }

    public String getATITransaction() {
        String result = this.record.get("ATITRANID");
        if (result == null) {
            return this.delegate.getATITransaction();
        }
        return (String)((CICSAttribute)IntrapartitionTDQueueType.ATI_TRANSACTION).get(result, this.record.getNormalizers());
    }

    public IIntrapartitionTDQueue.StatusValue getStatus() {
        String result = this.record.get("STATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (IIntrapartitionTDQueue.StatusValue)((CICSAttribute)IntrapartitionTDQueueType.STATUS).get(result, this.record.getNormalizers());
    }

    public Long getItemCount() {
        return this.delegate.getItemCount();
    }

    public IIntrapartitionTDQueue.RecoveryStatusValue getRecoveryStatus() {
        return this.delegate.getRecoveryStatus();
    }

    public Long getTriggerLevel() {
        String result = this.record.get("TRIGGERLEVEL");
        if (result == null) {
            return this.delegate.getTriggerLevel();
        }
        return (Long)((CICSAttribute)IntrapartitionTDQueueType.TRIGGER_LEVEL).get(result, this.record.getNormalizers());
    }

    public Long getRequestCount() {
        return this.delegate.getRequestCount();
    }

    public String getATIUserID() {
        String result = this.record.get("ATIUSERID");
        if (result == null) {
            return this.delegate.getATIUserID();
        }
        return (String)((CICSAttribute)IntrapartitionTDQueueType.ATI_USER_ID).get(result, this.record.getNormalizers());
    }

    public IIntrapartitionTDQueue.IndoubtValue getIndoubt() {
        return this.delegate.getIndoubt();
    }

    public IIntrapartitionTDQueue.IndoubtWaitValue getIndoubtWait() {
        return this.delegate.getIndoubtWait();
    }

    public IIntrapartitionTDQueue.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public IIntrapartitionTDQueue.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public void setATIFacility(IIntrapartitionTDQueue.ATIFacilityValue _ATIFacility) {
        if (_ATIFacility.equals((Object)this.delegate.getATIFacility())) {
            this.record.set("ATIFACILITY", null);
        } else {
            IntrapartitionTDQueueType.ATI_FACILITY.validate((Object)_ATIFacility);
            String connectionSpecificExternalValue = ((CICSAttribute)IntrapartitionTDQueueType.ATI_FACILITY).set(_ATIFacility, this.record.getNormalizers());
            this.record.set("ATIFACILITY", connectionSpecificExternalValue);
        }
    }

    public void setATITerminal(String _ATITerminal) {
        if (_ATITerminal.equals(this.delegate.getATITerminal())) {
            this.record.set("ATITERMID", null);
        } else {
            IntrapartitionTDQueueType.ATI_TERMINAL.validate((Object)_ATITerminal);
            String connectionSpecificExternalValue = ((CICSAttribute)IntrapartitionTDQueueType.ATI_TERMINAL).set(_ATITerminal, this.record.getNormalizers());
            this.record.set("ATITERMID", connectionSpecificExternalValue);
        }
    }

    public void setATITransaction(String _ATITransaction) {
        if (_ATITransaction.equals(this.delegate.getATITransaction())) {
            this.record.set("ATITRANID", null);
        } else {
            IntrapartitionTDQueueType.ATI_TRANSACTION.validate((Object)_ATITransaction);
            String connectionSpecificExternalValue = ((CICSAttribute)IntrapartitionTDQueueType.ATI_TRANSACTION).set(_ATITransaction, this.record.getNormalizers());
            this.record.set("ATITRANID", connectionSpecificExternalValue);
        }
    }

    public void setStatus(IIntrapartitionTDQueue.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("STATUS", null);
        } else {
            IntrapartitionTDQueueType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)IntrapartitionTDQueueType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("STATUS", connectionSpecificExternalValue);
        }
    }

    public void setTriggerLevel(Long _triggerLevel) {
        if (_triggerLevel.equals(this.delegate.getTriggerLevel())) {
            this.record.set("TRIGGERLEVEL", null);
        } else {
            IntrapartitionTDQueueType.TRIGGER_LEVEL.validate((Object)_triggerLevel);
            String connectionSpecificExternalValue = ((CICSAttribute)IntrapartitionTDQueueType.TRIGGER_LEVEL).set(_triggerLevel, this.record.getNormalizers());
            this.record.set("TRIGGERLEVEL", connectionSpecificExternalValue);
        }
    }

    public void setATIUserID(String _ATIUserID) {
        if (_ATIUserID.equals(this.delegate.getATIUserID())) {
            this.record.set("ATIUSERID", null);
        } else {
            IntrapartitionTDQueueType.ATI_USER_ID.validate((Object)_ATIUserID);
            String connectionSpecificExternalValue = ((CICSAttribute)IntrapartitionTDQueueType.ATI_USER_ID).set(_ATIUserID, this.record.getNormalizers());
            this.record.set("ATIUSERID", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == IntrapartitionTDQueueType.NAME) {
            return (V)this.getName();
        }
        if (attribute == IntrapartitionTDQueueType.ATI_FACILITY) {
            return (V)this.getATIFacility();
        }
        if (attribute == IntrapartitionTDQueueType.ATI_TERMINAL) {
            return (V)this.getATITerminal();
        }
        if (attribute == IntrapartitionTDQueueType.ATI_TRANSACTION) {
            return (V)this.getATITransaction();
        }
        if (attribute == IntrapartitionTDQueueType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == IntrapartitionTDQueueType.ITEM_COUNT) {
            return (V)this.getItemCount();
        }
        if (attribute == IntrapartitionTDQueueType.RECOVERY_STATUS) {
            return (V)this.getRecoveryStatus();
        }
        if (attribute == IntrapartitionTDQueueType.TRIGGER_LEVEL) {
            return (V)this.getTriggerLevel();
        }
        if (attribute == IntrapartitionTDQueueType.REQUEST_COUNT) {
            return (V)this.getRequestCount();
        }
        if (attribute == IntrapartitionTDQueueType.ATI_USER_ID) {
            return (V)this.getATIUserID();
        }
        if (attribute == IntrapartitionTDQueueType.INDOUBT) {
            return (V)this.getIndoubt();
        }
        if (attribute == IntrapartitionTDQueueType.INDOUBT_WAIT) {
            return (V)this.getIndoubtWait();
        }
        if (attribute == IntrapartitionTDQueueType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == IntrapartitionTDQueueType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == IntrapartitionTDQueueType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == IntrapartitionTDQueueType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == IntrapartitionTDQueueType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == IntrapartitionTDQueueType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == IntrapartitionTDQueueType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == IntrapartitionTDQueueType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == IntrapartitionTDQueueType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == IntrapartitionTDQueueType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        return super.getAttributeValue(attribute);
    }

    public IntrapartitionTDQueueType getObjectType() {
        return IntrapartitionTDQueueType.getInstance();
    }

    @Override
    public IntrapartitionTDQueueReference getCICSObjectReference() {
        return new IntrapartitionTDQueueReference(this.getCICSContainer(), this.getName());
    }
}

