/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WMQMonitorReference;
import com.ibm.cics.core.model.WMQMonitorType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IWMQMonitor;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableWMQMonitor;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableWMQMonitor
extends MutableCICSResource
implements IMutableWMQMonitor {
    private IWMQMonitor delegate;
    private MutableSMRecord record;

    public MutableWMQMonitor(ICPSM cpsm, IContext context, IWMQMonitor cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("MQMON");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getMQMonName() {
        return this.delegate.getMQMonName();
    }

    public String getMqQueueName() {
        return this.delegate.getMqQueueName();
    }

    public IWMQMonitor.AutostartStatusValue getAutostartStatus() {
        String result = this.record.get("AUTOSTATUS");
        if (result == null) {
            return this.delegate.getAutostartStatus();
        }
        return (IWMQMonitor.AutostartStatusValue)((CICSAttribute)WMQMonitorType.AUTOSTART_STATUS).get(result, this.record.getNormalizers());
    }

    public IWMQMonitor.EnabledStatusValue getEnabledStatus() {
        String result = this.record.get("ENABLESTATUS");
        if (result == null) {
            return this.delegate.getEnabledStatus();
        }
        return (IWMQMonitor.EnabledStatusValue)((CICSAttribute)WMQMonitorType.ENABLED_STATUS).get(result, this.record.getNormalizers());
    }

    public IWMQMonitor.MonitorStatusValue getMonitorStatus() {
        String result = this.record.get("MONSTATUS");
        if (result == null) {
            return this.delegate.getMonitorStatus();
        }
        return (IWMQMonitor.MonitorStatusValue)((CICSAttribute)WMQMonitorType.MONITOR_STATUS).get(result, this.record.getNormalizers());
    }

    public String getMonitorTransaction() {
        return this.delegate.getMonitorTransaction();
    }

    public String getMonitorUserId() {
        return this.delegate.getMonitorUserId();
    }

    public String getTargetUserId() {
        return this.delegate.getTargetUserId();
    }

    public String getMonitorData() {
        return this.delegate.getMonitorData();
    }

    public String getTaskId() {
        return this.delegate.getTaskId();
    }

    public String getMqrqname() {
        return this.delegate.getMqrqname();
    }

    public Long getNumberOfMQOPENRequests() {
        return this.delegate.getNumberOfMQOPENRequests();
    }

    public Long getNumberOfMQCLOSERequests() {
        return this.delegate.getNumberOfMQCLOSERequests();
    }

    public Long getNumberOfMQGETRequests() {
        return this.delegate.getNumberOfMQGETRequests();
    }

    public Long getNumberOfMQGETWithWaitRequests() {
        return this.delegate.getNumberOfMQGETWithWaitRequests();
    }

    public Long getNumberOfMQPUTRequests() {
        return this.delegate.getNumberOfMQPUTRequests();
    }

    public Long getNumberOfMQPUT1Requests() {
        return this.delegate.getNumberOfMQPUT1Requests();
    }

    public Long getNumberOfMQINQRequests() {
        return this.delegate.getNumberOfMQINQRequests();
    }

    public Long getNumberOfMQINQLRequests() {
        return this.delegate.getNumberOfMQINQLRequests();
    }

    public Long getNumberOfMQSETRequests() {
        return this.delegate.getNumberOfMQSETRequests();
    }

    public Long getNumberOfCommittedUnitsOfWork() {
        return this.delegate.getNumberOfCommittedUnitsOfWork();
    }

    public Long getNumberOfBackoutUnitsOfWork() {
        return this.delegate.getNumberOfBackoutUnitsOfWork();
    }

    public Long getMqrtother() {
        return this.delegate.getMqrtother();
    }

    public Date getGMTStartTime() {
        return this.delegate.getGMTStartTime();
    }

    public Date getLocalStartTime() {
        return this.delegate.getLocalStartTime();
    }

    public Date getGMTStopTime() {
        return this.delegate.getGMTStopTime();
    }

    public Date getLocalStopTime() {
        return this.delegate.getLocalStopTime();
    }

    public String getLastModificationUserId() {
        return this.delegate.getLastModificationUserId();
    }

    public IWMQMonitor.LastModificationAgentValue getLastModificationAgent() {
        return this.delegate.getLastModificationAgent();
    }

    public String getLastModificationAgentRelease() {
        return this.delegate.getLastModificationAgentRelease();
    }

    public Date getLastModificationTime() {
        return this.delegate.getLastModificationTime();
    }

    public String getSourceOfTheResourceDefinition() {
        return this.delegate.getSourceOfTheResourceDefinition();
    }

    public Date getCreationTime() {
        return this.delegate.getCreationTime();
    }

    public String getInstallationUserId() {
        return this.delegate.getInstallationUserId();
    }

    public Date getInstallationTime() {
        return this.delegate.getInstallationTime();
    }

    public IWMQMonitor.InstallationAgentValue getInstallationAgent() {
        return this.delegate.getInstallationAgent();
    }

    public Long getBasResourceDefinitionVersion() {
        return this.delegate.getBasResourceDefinitionVersion();
    }

    public void setAutostartStatus(IWMQMonitor.AutostartStatusValue _AutostartStatus) {
        if (_AutostartStatus.equals((Object)this.delegate.getAutostartStatus())) {
            this.record.set("AUTOSTATUS", null);
        } else {
            WMQMonitorType.AUTOSTART_STATUS.validate((Object)_AutostartStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)WMQMonitorType.AUTOSTART_STATUS).set(_AutostartStatus, this.record.getNormalizers());
            this.record.set("AUTOSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setEnabledStatus(IWMQMonitor.EnabledStatusValue _EnabledStatus) {
        if (_EnabledStatus.equals((Object)this.delegate.getEnabledStatus())) {
            this.record.set("ENABLESTATUS", null);
        } else {
            WMQMonitorType.ENABLED_STATUS.validate((Object)_EnabledStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)WMQMonitorType.ENABLED_STATUS).set(_EnabledStatus, this.record.getNormalizers());
            this.record.set("ENABLESTATUS", connectionSpecificExternalValue);
        }
    }

    public void setMonitorStatus(IWMQMonitor.MonitorStatusValue _MonitorStatus) {
        if (_MonitorStatus.equals((Object)this.delegate.getMonitorStatus())) {
            this.record.set("MONSTATUS", null);
        } else {
            WMQMonitorType.MONITOR_STATUS.validate((Object)_MonitorStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)WMQMonitorType.MONITOR_STATUS).set(_MonitorStatus, this.record.getNormalizers());
            this.record.set("MONSTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WMQMonitorType.MQ_MON_NAME) {
            return (V)this.getMQMonName();
        }
        if (attribute == WMQMonitorType.MQ_QUEUE_NAME) {
            return (V)this.getMqQueueName();
        }
        if (attribute == WMQMonitorType.AUTOSTART_STATUS) {
            return (V)this.getAutostartStatus();
        }
        if (attribute == WMQMonitorType.ENABLED_STATUS) {
            return (V)this.getEnabledStatus();
        }
        if (attribute == WMQMonitorType.MONITOR_STATUS) {
            return (V)this.getMonitorStatus();
        }
        if (attribute == WMQMonitorType.MONITOR_TRANSACTION) {
            return (V)this.getMonitorTransaction();
        }
        if (attribute == WMQMonitorType.MONITOR_USER_ID) {
            return (V)this.getMonitorUserId();
        }
        if (attribute == WMQMonitorType.TARGET_USER_ID) {
            return (V)this.getTargetUserId();
        }
        if (attribute == WMQMonitorType.MONITOR_DATA) {
            return (V)this.getMonitorData();
        }
        if (attribute == WMQMonitorType.TASK_ID) {
            return (V)this.getTaskId();
        }
        if (attribute == WMQMonitorType.MQRQNAME) {
            return (V)this.getMqrqname();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_MQOPEN_REQUESTS) {
            return (V)this.getNumberOfMQOPENRequests();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_MQCLOSE_REQUESTS) {
            return (V)this.getNumberOfMQCLOSERequests();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_MQGET_REQUESTS) {
            return (V)this.getNumberOfMQGETRequests();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_MQGET_WITH_WAIT_REQUESTS) {
            return (V)this.getNumberOfMQGETWithWaitRequests();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_MQPUT_REQUESTS) {
            return (V)this.getNumberOfMQPUTRequests();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_MQPUT1_REQUESTS) {
            return (V)this.getNumberOfMQPUT1Requests();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_MQINQ_REQUESTS) {
            return (V)this.getNumberOfMQINQRequests();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_MQINQL_REQUESTS) {
            return (V)this.getNumberOfMQINQLRequests();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_MQSET_REQUESTS) {
            return (V)this.getNumberOfMQSETRequests();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_COMMITTED_UNITS_OF_WORK) {
            return (V)this.getNumberOfCommittedUnitsOfWork();
        }
        if (attribute == WMQMonitorType.NUMBER_OF_BACKOUT_UNITS_OF_WORK) {
            return (V)this.getNumberOfBackoutUnitsOfWork();
        }
        if (attribute == WMQMonitorType.MQRTOTHER) {
            return (V)this.getMqrtother();
        }
        if (attribute == WMQMonitorType.GMT_START_TIME) {
            return (V)this.getGMTStartTime();
        }
        if (attribute == WMQMonitorType.LOCAL_START_TIME) {
            return (V)this.getLocalStartTime();
        }
        if (attribute == WMQMonitorType.GMT_STOP_TIME) {
            return (V)this.getGMTStopTime();
        }
        if (attribute == WMQMonitorType.LOCAL_STOP_TIME) {
            return (V)this.getLocalStopTime();
        }
        if (attribute == WMQMonitorType.LAST_MODIFICATION_USER_ID) {
            return (V)this.getLastModificationUserId();
        }
        if (attribute == WMQMonitorType.LAST_MODIFICATION_AGENT) {
            return (V)this.getLastModificationAgent();
        }
        if (attribute == WMQMonitorType.LAST_MODIFICATION_AGENT_RELEASE) {
            return (V)this.getLastModificationAgentRelease();
        }
        if (attribute == WMQMonitorType.LAST_MODIFICATION_TIME) {
            return (V)this.getLastModificationTime();
        }
        if (attribute == WMQMonitorType.SOURCE_OF_THE_RESOURCE_DEFINITION) {
            return (V)this.getSourceOfTheResourceDefinition();
        }
        if (attribute == WMQMonitorType.CREATION_TIME) {
            return (V)this.getCreationTime();
        }
        if (attribute == WMQMonitorType.INSTALLATION_USER_ID) {
            return (V)this.getInstallationUserId();
        }
        if (attribute == WMQMonitorType.INSTALLATION_TIME) {
            return (V)this.getInstallationTime();
        }
        if (attribute == WMQMonitorType.INSTALLATION_AGENT) {
            return (V)this.getInstallationAgent();
        }
        if (attribute == WMQMonitorType.BAS_RESOURCE_DEFINITION_VERSION) {
            return (V)this.getBasResourceDefinitionVersion();
        }
        return super.getAttributeValue(attribute);
    }

    public WMQMonitorType getObjectType() {
        return WMQMonitorType.getInstance();
    }

    @Override
    public WMQMonitorReference getCICSObjectReference() {
        return new WMQMonitorReference(this.getCICSContainer(), this.getMQMonName());
    }
}

