/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.AggregatedModelSortProperties;
import com.ibm.cics.core.model.AggregatedResourcesModel;
import com.ibm.cics.model.AggregationFunction;
import com.ibm.cics.model.CICSDateAttributeAggregation;
import com.ibm.cics.model.CICSEnumAttributeAggregation;
import com.ibm.cics.model.CICSNumericAttributeAggregation;
import com.ibm.cics.model.CICSObjectAggregateRecord;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSEnum;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

public class AggregatedResourcesModelComparator
implements Comparator<AggregatedResourcesModel> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ".substring(0, 25));
        }
    };
    private ICICSAttribute<?> attribute;
    private boolean isSortAscending;
    private AggregationFunction aggregationFunction;

    public AggregatedResourcesModelComparator(AggregatedModelSortProperties sortProperties) {
        this.attribute = sortProperties.getAttribute();
        this.isSortAscending = sortProperties.getSortDirection();
        this.aggregationFunction = sortProperties.getAggregationFunction();
    }

    @Override
    public int compare(AggregatedResourcesModel o1, AggregatedResourcesModel o2) {
        CICSObjectAggregateRecord o1AggregateRecord = o1.getAggregateRecord();
        CICSObjectAggregateRecord o2AggregateRecord = o2.getAggregateRecord();
        if (this.attribute.getType() == String.class) {
            ICICSAttribute<?> stringAttribute = this.attribute;
            return this.compareOptionals(o1AggregateRecord.getStringAggregation(stringAttribute).getValue(), o2AggregateRecord.getStringAggregation(stringAttribute).getValue(), (s1, s2) -> s1.compareTo((String)s2));
        }
        if (this.attribute.getType() == Long.class) {
            CICSNumericAttributeAggregation o1NumericAggregation = o1AggregateRecord.getNumericAggregation(this.attribute);
            CICSNumericAttributeAggregation o2NumericAggregation = o2AggregateRecord.getNumericAggregation(this.attribute);
            switch (this.aggregationFunction) {
                case AVERAGE: {
                    return this.compareOptionals(o1NumericAggregation.getAverage(), o2NumericAggregation.getAverage(), Double::compare);
                }
                case DIFFERENCE: {
                    return this.compareOptionals(o1NumericAggregation.getDifference(), o2NumericAggregation.getDifference(), (s1, s2) -> s1.compareTo((String)s2));
                }
                case MAXIMUM: {
                    return this.compareOptionals(o1NumericAggregation.getMax(), o2NumericAggregation.getMax(), Long::compare);
                }
                case MINIMUM: {
                    return this.compareOptionals(o1NumericAggregation.getMin(), o2NumericAggregation.getMin(), Long::compare);
                }
                case SUM: {
                    return this.compareOptionals(o1NumericAggregation.getSum(), o2NumericAggregation.getSum(), Long::compare);
                }
            }
            return this.compareOptionals(o1NumericAggregation.getAverage(), o2NumericAggregation.getAverage(), Double::compare);
        }
        if (this.attribute.getType() == Date.class) {
            CICSDateAttributeAggregation o1DateAggregation = o1AggregateRecord.getDateAggregation(this.attribute);
            CICSDateAttributeAggregation o2DateAggregation = o2AggregateRecord.getDateAggregation(this.attribute);
            switch (this.aggregationFunction) {
                case AVERAGE: {
                    return this.compareOptionals(o1DateAggregation.getAverage(), o2DateAggregation.getAverage(), AggregatedResourcesModelComparator::compareDateValue);
                }
                case MAXIMUM: {
                    return this.compareOptionals(o1DateAggregation.getMax(), o2DateAggregation.getMax(), AggregatedResourcesModelComparator::compareDateValue);
                }
                case MINIMUM: {
                    return this.compareOptionals(o1DateAggregation.getMin(), o2DateAggregation.getMin(), AggregatedResourcesModelComparator::compareDateValue);
                }
            }
            return this.compareOptionals(o1DateAggregation.getAverage(), o2DateAggregation.getAverage(), AggregatedResourcesModelComparator::compareDateValue);
        }
        if (ICICSEnum.class.isAssignableFrom(this.attribute.getType())) {
            List o1AggregationValues = o1AggregateRecord.getEnumerationAggregation(this.attribute).getValueCounts();
            List o2AggregationValues = o2AggregateRecord.getEnumerationAggregation(this.attribute).getValueCounts();
            String o1Value = o1AggregationValues.size() == 1 ? ((CICSEnumAttributeAggregation.ValueCountPair)o1AggregationValues.get(0)).getValue() : "****";
            String o2Value = o2AggregationValues.size() == 1 ? ((CICSEnumAttributeAggregation.ValueCountPair)o2AggregationValues.get(0)).getValue() : "****";
            return this.applyDirection(o1Value.compareTo(o2Value));
        }
        throw new IllegalArgumentException("Unsupported CICS attribute of type " + this.attribute.getType());
    }

    private int applyDirection(int x) {
        return this.isSortAscending ? x : -x;
    }

    private <T> int compareOptionals(Optional<T> o1, Optional<T> o2, BiFunction<T, T, Integer> comparator) {
        return this.applyDirection(o1.map(o1V -> o2.map(o2V -> (Integer)comparator.apply(o1V, o2V)).orElse(-1)).orElse(o2.isPresent() ? 1 : 0));
    }

    private static int compareDateValue(String o1, String o2) {
        DateFormat dateFormat = DATE_FORMAT.get();
        try {
            Date o1Date = dateFormat.parse(o1);
            Date o2Date = dateFormat.parse(o2);
            return o1Date.compareTo(o2Date);
        }
        catch (ParseException e) {
            return 0;
        }
    }
}

