/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.FromReferenceAttribute;
import com.ibm.cics.core.model.ResourceGroupEntryType;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.ICICSDefinitionReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IResourceGroupEntry;
import com.ibm.cics.model.topology.BASRepository;
import java.util.Arrays;
import java.util.List;

public class ResourceGroupMembershipsReference<T extends ICICSDefinition>
extends FromReferenceAttribute<T, IResourceGroupEntry, ICICSDefinitionReference<T>> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ResourceGroupMembershipsReference() {
        super(ResourceGroupEntryType.getInstance().getResourceTableName(), ResourceGroupEntryType.getInstance());
    }

    public List<ICICSAttribute<?>> getAttributesUsedInReference() {
        return Arrays.asList(ResourceGroupEntryType.DEFINITION_NAME, ResourceGroupEntryType.DEFINITION_TYPE, ResourceGroupEntryType.DEFINITION_VERSION);
    }

    public ICICSObjectSet<IResourceGroupEntry> getFrom(ICICSDefinitionReference<T> to) {
        ICICSDefinitionContainer container = to.getCICSContainer();
        if (container instanceof BASRepository) {
            BASRepository basRepository = (BASRepository)container;
            ICICSObjectSet set = basRepository.getCPSMDefinitionContainer().getCICSObjectSet(this.getFromType());
            set.setFilter(FilterExpression.is(ResourceGroupEntryType.DEFINITION_NAME, (Object)to.getName()).and(FilterExpression.is(ResourceGroupEntryType.DEFINITION_TYPE, (Object)to.getCICSType().getResourceTableName())).and(FilterExpression.is(ResourceGroupEntryType.DEFINITION_VERSION, (Object)to.getVersion())));
            return set;
        }
        return ICICSObjectSet.emptySet((ICICSType)ResourceGroupEntryType.getInstance());
    }
}

