/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.builders;

import com.ibm.cics.core.model.BundleDefinitionType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DefinitionBuilder;
import com.ibm.cics.core.model.builders.BuilderHelper;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.IBundleDefinition;
import com.ibm.cics.model.IBundleDefinitionReference;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableBundleDefinition;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class BundleDefinitionBuilder
extends DefinitionBuilder
implements IMutableBundleDefinition {
    private MutableSMRecord record = new MutableSMRecord("BUNDDEF");

    public BundleDefinitionBuilder(String _name, Long _version, String _bundledir, String _basescope) {
        this.setName(_name);
        this.setVersion(_version);
        this.setBundledir(_bundledir);
        this.setBasescope(_basescope);
    }

    public BundleDefinitionBuilder(String _name, Long _version, String _bundledir, String _basescope, IBundleDefinition anotherDef) throws Exception {
        this(_name, _version, _bundledir, _basescope);
        BuilderHelper.copyAttributes((IDefinition)anotherDef, this);
    }

    public ICICSDefinitionContainer getCICSContainer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SMConnectionRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getRecord() + "]";
    }

    public void setVersion(Long _version) {
        String connectionSpecificExternalValue = null;
        if (_version != null && _version != BundleDefinitionType.VERSION.getUnsupportedValue()) {
            BundleDefinitionType.VERSION.validate((Object)_version);
            connectionSpecificExternalValue = ((CICSAttribute)BundleDefinitionType.VERSION).set(_version, this.record.getNormalizers());
        }
        this.record.set("DEFVER", connectionSpecificExternalValue);
    }

    public void setName(String _name) {
        String connectionSpecificExternalValue = null;
        if (_name != null && _name != BundleDefinitionType.NAME.getUnsupportedValue()) {
            BundleDefinitionType.NAME.validate((Object)_name);
            connectionSpecificExternalValue = ((CICSAttribute)BundleDefinitionType.NAME).set(_name, this.record.getNormalizers());
        }
        this.record.set("NAME", connectionSpecificExternalValue);
    }

    public void setUserdata1(String _userdata1) {
        String connectionSpecificExternalValue = null;
        if (_userdata1 != null && _userdata1 != BundleDefinitionType.USERDATA_1.getUnsupportedValue()) {
            BundleDefinitionType.USERDATA_1.validate((Object)_userdata1);
            connectionSpecificExternalValue = ((CICSAttribute)BundleDefinitionType.USERDATA_1).set(_userdata1, this.record.getNormalizers());
        }
        this.record.set("USERDATA1", connectionSpecificExternalValue);
    }

    public void setUserdata2(String _userdata2) {
        String connectionSpecificExternalValue = null;
        if (_userdata2 != null && _userdata2 != BundleDefinitionType.USERDATA_2.getUnsupportedValue()) {
            BundleDefinitionType.USERDATA_2.validate((Object)_userdata2);
            connectionSpecificExternalValue = ((CICSAttribute)BundleDefinitionType.USERDATA_2).set(_userdata2, this.record.getNormalizers());
        }
        this.record.set("USERDATA2", connectionSpecificExternalValue);
    }

    public void setUserdata3(String _userdata3) {
        String connectionSpecificExternalValue = null;
        if (_userdata3 != null && _userdata3 != BundleDefinitionType.USERDATA_3.getUnsupportedValue()) {
            BundleDefinitionType.USERDATA_3.validate((Object)_userdata3);
            connectionSpecificExternalValue = ((CICSAttribute)BundleDefinitionType.USERDATA_3).set(_userdata3, this.record.getNormalizers());
        }
        this.record.set("USERDATA3", connectionSpecificExternalValue);
    }

    public void setStatus(IBundleDefinition.StatusValue _status) {
        String connectionSpecificExternalValue = null;
        if (_status != null && _status != BundleDefinitionType.STATUS.getUnsupportedValue()) {
            BundleDefinitionType.STATUS.validate((Object)_status);
            connectionSpecificExternalValue = ((CICSAttribute)BundleDefinitionType.STATUS).set(_status, this.record.getNormalizers());
        }
        this.record.set("STATUS", connectionSpecificExternalValue);
    }

    public void setDescription(String _description) {
        String connectionSpecificExternalValue = null;
        if (_description != null && _description != BundleDefinitionType.DESCRIPTION.getUnsupportedValue()) {
            BundleDefinitionType.DESCRIPTION.validate((Object)_description);
            connectionSpecificExternalValue = ((CICSAttribute)BundleDefinitionType.DESCRIPTION).set(_description, this.record.getNormalizers());
        }
        this.record.set("DESCRIPTION", connectionSpecificExternalValue);
    }

    public void setBundledir(String _bundledir) {
        String connectionSpecificExternalValue = null;
        if (_bundledir != null && _bundledir != BundleDefinitionType.BUNDLEDIR.getUnsupportedValue()) {
            BundleDefinitionType.BUNDLEDIR.validate((Object)_bundledir);
            connectionSpecificExternalValue = ((CICSAttribute)BundleDefinitionType.BUNDLEDIR).set(_bundledir, this.record.getNormalizers());
        }
        this.record.set("BUNDLEDIR", connectionSpecificExternalValue);
    }

    public void setBasescope(String _basescope) {
        String connectionSpecificExternalValue = null;
        if (_basescope != null && _basescope != BundleDefinitionType.BASESCOPE.getUnsupportedValue()) {
            BundleDefinitionType.BASESCOPE.validate((Object)_basescope);
            connectionSpecificExternalValue = ((CICSAttribute)BundleDefinitionType.BASESCOPE).set(_basescope, this.record.getNormalizers());
        }
        this.record.set("BASESCOPE", connectionSpecificExternalValue);
    }

    public IBundleDefinition.ChangeAgentValue getChangeAgent() {
        String result = this.record.get("CHANGEAGENT");
        return result == null ? null : (IBundleDefinition.ChangeAgentValue)((CICSAttribute)BundleDefinitionType.CHANGE_AGENT).get(result, this.record.getNormalizers());
    }

    public String getUserdata1() {
        String result = this.record.get("USERDATA1");
        return result == null ? null : (String)((CICSAttribute)BundleDefinitionType.USERDATA_1).get(result, this.record.getNormalizers());
    }

    public String getUserdata2() {
        String result = this.record.get("USERDATA2");
        return result == null ? null : (String)((CICSAttribute)BundleDefinitionType.USERDATA_2).get(result, this.record.getNormalizers());
    }

    public String getUserdata3() {
        String result = this.record.get("USERDATA3");
        return result == null ? null : (String)((CICSAttribute)BundleDefinitionType.USERDATA_3).get(result, this.record.getNormalizers());
    }

    public IBundleDefinition.StatusValue getStatus() {
        String result = this.record.get("STATUS");
        return result == null ? null : (IBundleDefinition.StatusValue)((CICSAttribute)BundleDefinitionType.STATUS).get(result, this.record.getNormalizers());
    }

    @Override
    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        return result == null ? null : (String)((CICSAttribute)BundleDefinitionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public String getBundledir() {
        String result = this.record.get("BUNDLEDIR");
        return result == null ? null : (String)((CICSAttribute)BundleDefinitionType.BUNDLEDIR).get(result, this.record.getNormalizers());
    }

    public String getBasescope() {
        String result = this.record.get("BASESCOPE");
        return result == null ? null : (String)((CICSAttribute)BundleDefinitionType.BASESCOPE).get(result, this.record.getNormalizers());
    }

    @Override
    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == BundleDefinitionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == BundleDefinitionType.VERSION) {
            return (V)this.getVersion();
        }
        if (attribute == BundleDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == BundleDefinitionType.USERDATA_1) {
            return (V)this.getUserdata1();
        }
        if (attribute == BundleDefinitionType.USERDATA_2) {
            return (V)this.getUserdata2();
        }
        if (attribute == BundleDefinitionType.USERDATA_3) {
            return (V)this.getUserdata3();
        }
        if (attribute == BundleDefinitionType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == BundleDefinitionType.BUNDLEDIR) {
            return (V)this.getBundledir();
        }
        if (attribute == BundleDefinitionType.BASESCOPE) {
            return (V)this.getBasescope();
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + BundleDefinitionType.getInstance());
    }

    @Override
    public <V> void setAttributeValue(IAttribute<V> attribute, V value) {
        if (attribute == BundleDefinitionType.VERSION) {
            this.setVersion((Long)BundleDefinitionType.VERSION.getType().cast(value));
        } else if (attribute == BundleDefinitionType.NAME) {
            this.setName((String)BundleDefinitionType.NAME.getType().cast(value));
        } else if (attribute == BundleDefinitionType.USERDATA_1) {
            this.setUserdata1((String)BundleDefinitionType.USERDATA_1.getType().cast(value));
        } else if (attribute == BundleDefinitionType.USERDATA_2) {
            this.setUserdata2((String)BundleDefinitionType.USERDATA_2.getType().cast(value));
        } else if (attribute == BundleDefinitionType.USERDATA_3) {
            this.setUserdata3((String)BundleDefinitionType.USERDATA_3.getType().cast(value));
        } else if (attribute == BundleDefinitionType.STATUS) {
            this.setStatus((IBundleDefinition.StatusValue)BundleDefinitionType.STATUS.getType().cast(value));
        } else if (attribute == BundleDefinitionType.DESCRIPTION) {
            this.setDescription((String)BundleDefinitionType.DESCRIPTION.getType().cast(value));
        } else if (attribute == BundleDefinitionType.BUNDLEDIR) {
            this.setBundledir((String)BundleDefinitionType.BUNDLEDIR.getType().cast(value));
        } else if (attribute == BundleDefinitionType.BASESCOPE) {
            this.setBasescope((String)BundleDefinitionType.BASESCOPE.getType().cast(value));
        } else {
            throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not settable for type " + BundleDefinitionType.getInstance());
        }
    }

    public BundleDefinitionType getObjectType() {
        return BundleDefinitionType.getInstance();
    }

    public IBundleDefinitionReference getCICSObjectReference() {
        return null;
    }
}

