/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.builders;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DefinitionBuilder;
import com.ibm.cics.core.model.TransactionGroupEntryType;
import com.ibm.cics.core.model.builders.BuilderHelper;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.ITransactionGroupEntry;
import com.ibm.cics.model.ITransactionGroupEntryReference;
import com.ibm.cics.model.ITransactionGroupReference;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableTransactionGroupEntry;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class TransactionGroupEntryBuilder
extends DefinitionBuilder
implements IMutableTransactionGroupEntry {
    private MutableSMRecord record = new MutableSMRecord("DTRINGRP");

    public TransactionGroupEntryBuilder(String _transactionGroup, String _transactionID) {
        this.setTransactionGroup(_transactionGroup);
        this.setTransactionID(_transactionID);
    }

    public TransactionGroupEntryBuilder(String _transactionGroup, String _transactionID, ITransactionGroupEntry anotherDef) throws Exception {
        this(_transactionGroup, _transactionID);
        BuilderHelper.copyAttributes((IDefinition)anotherDef, this);
    }

    public ICPSMDefinitionContainer getCICSContainer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SMConnectionRecord getRecord() {
        return this.record;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getRecord() + "]";
    }

    public void setChangeAgent(ITransactionGroupEntry.ChangeAgentValue _changeAgent) {
        String connectionSpecificExternalValue = null;
        if (_changeAgent != null && _changeAgent != TransactionGroupEntryType.CHANGE_AGENT.getUnsupportedValue()) {
            TransactionGroupEntryType.CHANGE_AGENT.validate((Object)_changeAgent);
            connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupEntryType.CHANGE_AGENT).set(_changeAgent, this.record.getNormalizers());
        }
        this.record.set("CHANGEAGENT", connectionSpecificExternalValue);
    }

    public void setTransactionGroup(String _transactionGroup) {
        String connectionSpecificExternalValue = null;
        if (_transactionGroup != null && _transactionGroup != TransactionGroupEntryType.TRANSACTION_GROUP.getUnsupportedValue()) {
            TransactionGroupEntryType.TRANSACTION_GROUP.validate((Object)_transactionGroup);
            connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupEntryType.TRANSACTION_GROUP).set(_transactionGroup, this.record.getNormalizers());
        }
        this.record.set("TRANGRP", connectionSpecificExternalValue);
    }

    public void setTransactionID(String _transactionID) {
        String connectionSpecificExternalValue = null;
        if (_transactionID != null && _transactionID != TransactionGroupEntryType.TRANSACTION_ID.getUnsupportedValue()) {
            TransactionGroupEntryType.TRANSACTION_ID.validate((Object)_transactionID);
            connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupEntryType.TRANSACTION_ID).set(_transactionID, this.record.getNormalizers());
        }
        this.record.set("TRANID", connectionSpecificExternalValue);
    }

    public void setPseudoConversationalMode(ITransactionGroupEntry.PseudoConversationalModeValue _pseudoConversationalMode) {
        String connectionSpecificExternalValue = null;
        if (_pseudoConversationalMode != null && _pseudoConversationalMode != TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE.getUnsupportedValue()) {
            TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE.validate((Object)_pseudoConversationalMode);
            connectionSpecificExternalValue = ((CICSAttribute)TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE).set(_pseudoConversationalMode, this.record.getNormalizers());
        }
        this.record.set("PCONV", connectionSpecificExternalValue);
    }

    public ITransactionGroupEntry.ChangeAgentValue getChangeAgent() {
        String result = this.record.get("CHANGEAGENT");
        return result == null ? null : (ITransactionGroupEntry.ChangeAgentValue)((CICSAttribute)TransactionGroupEntryType.CHANGE_AGENT).get(result, this.record.getNormalizers());
    }

    public String getTransactionGroup() {
        String result = this.record.get("TRANGRP");
        return result == null ? null : (String)((CICSAttribute)TransactionGroupEntryType.TRANSACTION_GROUP).get(result, this.record.getNormalizers());
    }

    public String getTransactionID() {
        String result = this.record.get("TRANID");
        return result == null ? null : (String)((CICSAttribute)TransactionGroupEntryType.TRANSACTION_ID).get(result, this.record.getNormalizers());
    }

    public ITransactionGroupEntry.PseudoConversationalModeValue getPseudoConversationalMode() {
        String result = this.record.get("PCONV");
        return result == null ? null : (ITransactionGroupEntry.PseudoConversationalModeValue)((CICSAttribute)TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE).get(result, this.record.getNormalizers());
    }

    @Override
    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TransactionGroupEntryType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == TransactionGroupEntryType.TRANSACTION_GROUP) {
            return (V)this.getTransactionGroup();
        }
        if (attribute == TransactionGroupEntryType.TRANSACTION_ID) {
            return (V)this.getTransactionID();
        }
        if (attribute == TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE) {
            return (V)this.getPseudoConversationalMode();
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + TransactionGroupEntryType.getInstance());
    }

    @Override
    public <V> void setAttributeValue(IAttribute<V> attribute, V value) {
        if (attribute == TransactionGroupEntryType.CHANGE_AGENT) {
            this.setChangeAgent((ITransactionGroupEntry.ChangeAgentValue)TransactionGroupEntryType.CHANGE_AGENT.getType().cast(value));
        } else if (attribute == TransactionGroupEntryType.TRANSACTION_GROUP) {
            this.setTransactionGroup((String)TransactionGroupEntryType.TRANSACTION_GROUP.getType().cast(value));
        } else if (attribute == TransactionGroupEntryType.TRANSACTION_ID) {
            this.setTransactionID((String)TransactionGroupEntryType.TRANSACTION_ID.getType().cast(value));
        } else if (attribute == TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE) {
            this.setPseudoConversationalMode((ITransactionGroupEntry.PseudoConversationalModeValue)TransactionGroupEntryType.PSEUDO_CONVERSATIONAL_MODE.getType().cast(value));
        } else {
            throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not settable for type " + TransactionGroupEntryType.getInstance());
        }
    }

    public TransactionGroupEntryType getObjectType() {
        return TransactionGroupEntryType.getInstance();
    }

    public ITransactionGroupEntryReference getCICSObjectReference() {
        return null;
    }

    public ITransactionGroupReference getContainingGroup() {
        throw new UnsupportedOperationException();
    }
}

