/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.ActiveWorkloadDefinitionReference;
import com.ibm.cics.core.model.ActiveWorkloadDefinitionType;
import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CPSMManager;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.IActiveWorkloadDefinition;
import com.ibm.cics.model.ICPSMManagerContainer;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class ActiveWorkloadDefinition
extends CPSMManager
implements IActiveWorkloadDefinition {
    private String _name;
    private String _workload;
    private String _trangrp;
    private String _luname;
    private String _userid;
    private String _aorscope;
    private String _desc;
    private String _wrklowner;
    private String _processtype;

    public ActiveWorkloadDefinition(ICPSMManagerContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._name = (String)avm.getAttributeValue(ActiveWorkloadDefinitionType.NAME);
        this._workload = (String)avm.getAttributeValue(ActiveWorkloadDefinitionType.WORKLOAD);
        this._trangrp = (String)avm.getAttributeValue(ActiveWorkloadDefinitionType.TRANSACTION_GROUP, true);
        this._luname = (String)avm.getAttributeValue(ActiveWorkloadDefinitionType.LU_NAME, true);
        this._userid = (String)avm.getAttributeValue(ActiveWorkloadDefinitionType.USER_ID, true);
        this._aorscope = (String)avm.getAttributeValue(ActiveWorkloadDefinitionType.TARGET_SCOPE, true);
        this._desc = (String)avm.getAttributeValue(ActiveWorkloadDefinitionType.DESCRIPTION, true);
        this._wrklowner = (String)avm.getAttributeValue(ActiveWorkloadDefinitionType.WORKLOAD_OWNER);
        this._processtype = (String)avm.getAttributeValue(ActiveWorkloadDefinitionType.PROCESS_TYPE, true);
    }

    public ActiveWorkloadDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)ActiveWorkloadDefinitionType.NAME).get(stringValue, normalizers);
        stringValue = record.get("WORKLOAD");
        this._workload = (String)((CICSAttribute)ActiveWorkloadDefinitionType.WORKLOAD).get(stringValue, normalizers);
        stringValue = record.get("TRANGRP");
        this._trangrp = (String)((CICSAttribute)ActiveWorkloadDefinitionType.TRANSACTION_GROUP).get(stringValue, normalizers);
        stringValue = record.get("LUNAME");
        this._luname = (String)((CICSAttribute)ActiveWorkloadDefinitionType.LU_NAME).get(stringValue, normalizers);
        stringValue = record.get("USERID");
        this._userid = (String)((CICSAttribute)ActiveWorkloadDefinitionType.USER_ID).get(stringValue, normalizers);
        stringValue = record.get("AORSCOPE");
        this._aorscope = (String)((CICSAttribute)ActiveWorkloadDefinitionType.TARGET_SCOPE).get(stringValue, normalizers);
        stringValue = record.get("DESC");
        this._desc = (String)((CICSAttribute)ActiveWorkloadDefinitionType.DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get("WRKLOWNER");
        this._wrklowner = (String)((CICSAttribute)ActiveWorkloadDefinitionType.WORKLOAD_OWNER).get(stringValue, normalizers);
        stringValue = record.get("PROCESSTYPE");
        this._processtype = (String)((CICSAttribute)ActiveWorkloadDefinitionType.PROCESS_TYPE).get(stringValue, normalizers);
    }

    public String getName() {
        return this._name;
    }

    public String getWorkload() {
        return this._workload;
    }

    public String getTransactionGroup() {
        return this._trangrp;
    }

    public String getLuName() {
        return this._luname;
    }

    public String getUserID() {
        return this._userid;
    }

    public String getTargetScope() {
        return this._aorscope;
    }

    public String getDescription() {
        return this._desc;
    }

    public String getWorkloadOwner() {
        return this._wrklowner;
    }

    public String getProcessType() {
        return this._processtype;
    }

    public ActiveWorkloadDefinitionType getObjectType() {
        return ActiveWorkloadDefinitionType.getInstance();
    }

    @Override
    public ActiveWorkloadDefinitionReference getCICSObjectReference() {
        return new ActiveWorkloadDefinitionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ActiveWorkloadDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ActiveWorkloadDefinitionType.WORKLOAD) {
            return (V)this.getWorkload();
        }
        if (attribute == ActiveWorkloadDefinitionType.TRANSACTION_GROUP) {
            return (V)this.getTransactionGroup();
        }
        if (attribute == ActiveWorkloadDefinitionType.LU_NAME) {
            return (V)this.getLuName();
        }
        if (attribute == ActiveWorkloadDefinitionType.USER_ID) {
            return (V)this.getUserID();
        }
        if (attribute == ActiveWorkloadDefinitionType.TARGET_SCOPE) {
            return (V)this.getTargetScope();
        }
        if (attribute == ActiveWorkloadDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == ActiveWorkloadDefinitionType.WORKLOAD_OWNER) {
            return (V)this.getWorkloadOwner();
        }
        if (attribute == ActiveWorkloadDefinitionType.PROCESS_TYPE) {
            return (V)this.getProcessType();
        }
        return super.getAttributeValue(attribute);
    }
}

