/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSObjectPrimaryKey;
import com.ibm.cics.core.model.CICSObjectReference;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.internal.GenericContainer;
import com.ibm.cics.core.model.mutable.IMutableCoreObject;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectContainer;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import java.lang.reflect.Constructor;

public abstract class CICSObject
implements ICICSObject,
ICoreObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(CICSObject.class);
    protected final IContext context;
    private final ICPSM cpsm;

    protected CICSObject(ICPSM cpsm, IContext context) {
        this.cpsm = cpsm;
        this.context = context;
    }

    protected CICSObject(ICICSObjectContainer<?> container) {
        this.cpsm = null;
        this.context = container instanceof GenericContainer ? ((GenericContainer)container).baseContext : null;
    }

    @Override
    public ICPSM getCPSM() {
        return this.cpsm;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getName() + "]";
    }

    @Deprecated
    public final ICICSType<?> getCICSType() {
        return this.getObjectType();
    }

    @Override
    public Object getAdapter(Class adapter) {
        Object object = null;
        if (IPrimaryKey.class.isAssignableFrom(adapter)) {
            object = this.getPrimaryKey();
        } else if (ICICSObjectReference.class.isAssignableFrom(adapter)) {
            object = this.getCICSObjectReference();
        } else if (IMutableCoreObject.class.isAssignableFrom(adapter)) {
            object = this.getMutable();
        }
        return object;
    }

    private IMutableCoreObject getMutable() {
        if (this instanceof IMutableCoreObject) {
            return (IMutableCoreObject)((Object)this);
        }
        IMutableCoreObject mutableDefinition = null;
        Class implementationType = this.getObjectType().getMutableImplementation();
        if (implementationType != null) {
            try {
                Class interfaceType = this.getObjectType().getInterfaceType();
                Class[] parameterTypes = new Class[]{ICPSM.class, IContext.class, interfaceType};
                Constructor constructor = implementationType.getConstructor(parameterTypes);
                mutableDefinition = (IMutableCoreObject)constructor.newInstance(this.getCPSM(), this.context, this);
            }
            catch (Exception ex) {
                DEBUG.error("getMutable", ex.toString(), (Throwable)ex);
            }
        }
        return mutableDefinition;
    }

    public <T> T getAttributeValue(IAttribute<T> attribute) {
        throw new IllegalArgumentException("Attribute '" + attribute.getPropertyId() + "' is not valid for type '" + this.getObjectType() + "'");
    }

    protected IPrimaryKey getPrimaryKey() {
        return new CICSObjectPrimaryKey(this.context, this);
    }

    public abstract CICSObjectReference<? extends ICICSObject> getCICSObjectReference();
}

