/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.JVMEndpointReference;
import com.ibm.cics.core.model.JVMEndpointType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IJVMEndpoint;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class JVMEndpoint
extends CICSResource
implements IJVMEndpoint {
    private String _jvmendpoint;
    private IJVMEndpoint.EnableStatusValue _enablestatus;
    private String _jvmserver;
    private String _type;
    private Long _port;
    private Long _secport;
    private String _host;

    public JVMEndpoint(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._jvmendpoint = (String)avm.getAttributeValue(JVMEndpointType.JVM_ENDPOINT);
        this._enablestatus = (IJVMEndpoint.EnableStatusValue)avm.getAttributeValue(JVMEndpointType.ENABLE_STATUS, true);
        this._jvmserver = (String)avm.getAttributeValue(JVMEndpointType.JVM_SERVER);
        this._type = (String)avm.getAttributeValue(JVMEndpointType.TYPE, true);
        this._port = (Long)avm.getAttributeValue(JVMEndpointType.PORT, true);
        this._secport = (Long)avm.getAttributeValue(JVMEndpointType.SECURE_PORT, true);
        this._host = (String)avm.getAttributeValue(JVMEndpointType.HOST, true);
    }

    public JVMEndpoint(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("JVMENDPOINT");
        this._jvmendpoint = (String)((CICSAttribute)JVMEndpointType.JVM_ENDPOINT).get(stringValue, normalizers);
        stringValue = record.get("ENABLESTATUS");
        this._enablestatus = (IJVMEndpoint.EnableStatusValue)((CICSAttribute)JVMEndpointType.ENABLE_STATUS).get(stringValue, normalizers);
        stringValue = record.get("JVMSERVER");
        this._jvmserver = (String)((CICSAttribute)JVMEndpointType.JVM_SERVER).get(stringValue, normalizers);
        stringValue = record.get("TYPE");
        this._type = (String)((CICSAttribute)JVMEndpointType.TYPE).get(stringValue, normalizers);
        stringValue = record.get("PORT");
        this._port = (Long)((CICSAttribute)JVMEndpointType.PORT).get(stringValue, normalizers);
        stringValue = record.get("SECPORT");
        this._secport = (Long)((CICSAttribute)JVMEndpointType.SECURE_PORT).get(stringValue, normalizers);
        stringValue = record.get("HOST");
        this._host = (String)((CICSAttribute)JVMEndpointType.HOST).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return JVMEndpointType.JVM_ENDPOINT.internalToExternal((Object)this.getJvmEndpoint());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getJvmEndpoint() {
        return this._jvmendpoint;
    }

    public IJVMEndpoint.EnableStatusValue getEnableStatus() {
        return this._enablestatus;
    }

    public String getJvmServer() {
        return this._jvmserver;
    }

    public String getType() {
        return this._type;
    }

    public Long getPort() {
        return this._port;
    }

    public Long getSecurePort() {
        return this._secport;
    }

    public String getHost() {
        return this._host;
    }

    public JVMEndpointType getObjectType() {
        return JVMEndpointType.getInstance();
    }

    @Override
    public JVMEndpointReference getCICSObjectReference() {
        return new JVMEndpointReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == JVMEndpointType.JVM_ENDPOINT) {
            return (V)this.getJvmEndpoint();
        }
        if (attribute == JVMEndpointType.ENABLE_STATUS) {
            return (V)this.getEnableStatus();
        }
        if (attribute == JVMEndpointType.JVM_SERVER) {
            return (V)this.getJvmServer();
        }
        if (attribute == JVMEndpointType.TYPE) {
            return (V)this.getType();
        }
        if (attribute == JVMEndpointType.PORT) {
            return (V)this.getPort();
        }
        if (attribute == JVMEndpointType.SECURE_PORT) {
            return (V)this.getSecurePort();
        }
        if (attribute == JVMEndpointType.HOST) {
            return (V)this.getHost();
        }
        return super.getAttributeValue(attribute);
    }
}

