/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ConnectionReference;
import com.ibm.cics.core.model.ConnectionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IConnection;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableConnection;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableConnection
extends MutableCICSResource
implements IMutableConnection {
    private IConnection delegate;
    private MutableSMRecord record;

    public MutableConnection(ICPSM cpsm, IContext context, IConnection cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("CONNECT");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public IConnection.ProtocolValue getProtocol() {
        return this.delegate.getProtocol();
    }

    public IConnection.TypeValue getType() {
        return this.delegate.getType();
    }

    public IConnection.AccessmethodValue getAccessmethod() {
        return this.delegate.getAccessmethod();
    }

    public IConnection.StatusValue getStatus() {
        String result = this.record.get("CONNSTATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (IConnection.StatusValue)((CICSAttribute)ConnectionType.STATUS).get(result, this.record.getNormalizers());
    }

    public IConnection.AutostatusValue getAutostatus() {
        return this.delegate.getAutostatus();
    }

    public IConnection.ExittracingValue getExittracing() {
        String result = this.record.get("EXITTRACING");
        if (result == null) {
            return this.delegate.getExittracing();
        }
        return (IConnection.ExittracingValue)((CICSAttribute)ConnectionType.EXITTRACING).get(result, this.record.getNormalizers());
    }

    public String getNetName() {
        return this.delegate.getNetName();
    }

    public IConnection.ServiceStatusValue getServiceStatus() {
        String result = this.record.get("SERVSTATUS");
        if (result == null) {
            return this.delegate.getServiceStatus();
        }
        return (IConnection.ServiceStatusValue)((CICSAttribute)ConnectionType.SERVICE_STATUS).get(result, this.record.getNormalizers());
    }

    public IConnection.PendingStatusValue getPendingStatus() {
        String result = this.record.get("PENDSTATUS");
        if (result == null) {
            return this.delegate.getPendingStatus();
        }
        return (IConnection.PendingStatusValue)((CICSAttribute)ConnectionType.PENDING_STATUS).get(result, this.record.getNormalizers());
    }

    public IConnection.XlnstatusValue getXlnstatus() {
        return this.delegate.getXlnstatus();
    }

    public IConnection.ZcptracingValue getZcptracing() {
        String result = this.record.get("ZCPTRACING");
        if (result == null) {
            return this.delegate.getZcptracing();
        }
        return (IConnection.ZcptracingValue)((CICSAttribute)ConnectionType.ZCPTRACING).get(result, this.record.getNormalizers());
    }

    public Long getAids() {
        return this.delegate.getAids();
    }

    public Long getNonspecaids() {
        return this.delegate.getNonspecaids();
    }

    public Long getConcurbids() {
        return this.delegate.getConcurbids();
    }

    public Long getMaxsecond() {
        return this.delegate.getMaxsecond();
    }

    public Long getMaxbids() {
        return this.delegate.getMaxbids();
    }

    public Long getOutsalloc() {
        return this.delegate.getOutsalloc();
    }

    public Long getAtisbpri() {
        return this.delegate.getAtisbpri();
    }

    public Long getAtisbsec() {
        return this.delegate.getAtisbsec();
    }

    public Long getBidssent() {
        return this.delegate.getBidssent();
    }

    public Long getAllocates() {
        return this.delegate.getAllocates();
    }

    public Long getQuedallocate() {
        return this.delegate.getQuedallocate();
    }

    public Long getFailinkalloc() {
        return this.delegate.getFailinkalloc();
    }

    public Long getFailedothers() {
        return this.delegate.getFailedothers();
    }

    public Long getFcfuncship() {
        return this.delegate.getFcfuncship();
    }

    public Long getIcfuncship() {
        return this.delegate.getIcfuncship();
    }

    public Long getTdfuncship() {
        return this.delegate.getTdfuncship();
    }

    public Long getTsfuncship() {
        return this.delegate.getTsfuncship();
    }

    public Long getDlifuncship() {
        return this.delegate.getDlifuncship();
    }

    public Long getTermsharereq() {
        return this.delegate.getTermsharereq();
    }

    public Long getMaxprimaries() {
        return this.delegate.getMaxprimaries();
    }

    public Long getMaxqtpurgcnt() {
        return this.delegate.getMaxqtpurgcnt();
    }

    public Long getExit_rejallc() {
        return this.delegate.getExit_rejallc();
    }

    public IConnection.ConntypeValue getConntype() {
        return this.delegate.getConntype();
    }

    public Long getReceivecount() {
        return this.delegate.getReceivecount();
    }

    public Long getSendcount() {
        return this.delegate.getSendcount();
    }

    public Long getMaxqtime() {
        return this.delegate.getMaxqtime();
    }

    public Long getAllocqlimit() {
        return this.delegate.getAllocqlimit();
    }

    public Long getXziqrejs() {
        return this.delegate.getXziqrejs();
    }

    public Long getXziqprgcnt() {
        return this.delegate.getXziqprgcnt();
    }

    public Long getXziqallcprg() {
        return this.delegate.getXziqallcprg();
    }

    public Long getMaxqtallcprg() {
        return this.delegate.getMaxqtallcprg();
    }

    public IConnection.RecovstatusValue getRecovstatus() {
        String result = this.record.get("RECOVSTATUS");
        if (result == null) {
            return this.delegate.getRecovstatus();
        }
        return (IConnection.RecovstatusValue)((CICSAttribute)ConnectionType.RECOVSTATUS).get(result, this.record.getNormalizers());
    }

    public String getRemotesystem() {
        return this.delegate.getRemotesystem();
    }

    public String getRemotesysnet() {
        return this.delegate.getRemotesysnet();
    }

    public String getRemotename() {
        return this.delegate.getRemotename();
    }

    public String getLinksystem() {
        return this.delegate.getLinksystem();
    }

    public Date getGmtcreatime() {
        return this.delegate.getGmtcreatime();
    }

    public Date getConncreatime() {
        return this.delegate.getConncreatime();
    }

    public Date getGmtdeletime() {
        return this.delegate.getGmtdeletime();
    }

    public Date getConndeletime() {
        return this.delegate.getConndeletime();
    }

    public Long getPricurrused() {
        return this.delegate.getPricurrused();
    }

    public Long getSeccurrused() {
        return this.delegate.getSeccurrused();
    }

    public String getGrname() {
        return this.delegate.getGrname();
    }

    public String getMembername() {
        return this.delegate.getMembername();
    }

    public Long getDplfuncship() {
        return this.delegate.getDplfuncship();
    }

    public String getNqname() {
        return this.delegate.getNqname();
    }

    public Long getEstpcchnl() {
        return this.delegate.getEstpcchnl();
    }

    public Long getEstpcchnsent() {
        return this.delegate.getEstpcchnsent();
    }

    public Long getEstpcchnrcvd() {
        return this.delegate.getEstpcchnrcvd();
    }

    public Long getEsticchnl() {
        return this.delegate.getEsticchnl();
    }

    public Long getEsticchnsent() {
        return this.delegate.getEsticchnsent();
    }

    public Long getEsticchnrcvd() {
        return this.delegate.getEsticchnrcvd();
    }

    public Long getEsttcchnl() {
        return this.delegate.getEsttcchnl();
    }

    public Long getEsttcchnsent() {
        return this.delegate.getEsttcchnsent();
    }

    public Long getEsttcchnrcvd() {
        return this.delegate.getEsttcchnrcvd();
    }

    public IConnection.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public IConnection.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public Long getAidsf() {
        return this.delegate.getAidsf();
    }

    public Long getPeakAids() {
        return this.delegate.getPeakAids();
    }

    public void setStatus(IConnection.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("CONNSTATUS", null);
        } else {
            ConnectionType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)ConnectionType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("CONNSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setExittracing(IConnection.ExittracingValue _exittracing) {
        if (_exittracing.equals((Object)this.delegate.getExittracing())) {
            this.record.set("EXITTRACING", null);
        } else {
            ConnectionType.EXITTRACING.validate((Object)_exittracing);
            String connectionSpecificExternalValue = ((CICSAttribute)ConnectionType.EXITTRACING).set(_exittracing, this.record.getNormalizers());
            this.record.set("EXITTRACING", connectionSpecificExternalValue);
        }
    }

    public void setServiceStatus(IConnection.ServiceStatusValue _serviceStatus) {
        if (_serviceStatus.equals((Object)this.delegate.getServiceStatus())) {
            this.record.set("SERVSTATUS", null);
        } else {
            ConnectionType.SERVICE_STATUS.validate((Object)_serviceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ConnectionType.SERVICE_STATUS).set(_serviceStatus, this.record.getNormalizers());
            this.record.set("SERVSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setPendingStatus(IConnection.PendingStatusValue _pendingStatus) {
        if (_pendingStatus.equals((Object)this.delegate.getPendingStatus())) {
            this.record.set("PENDSTATUS", null);
        } else {
            ConnectionType.PENDING_STATUS.validate((Object)_pendingStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ConnectionType.PENDING_STATUS).set(_pendingStatus, this.record.getNormalizers());
            this.record.set("PENDSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setZcptracing(IConnection.ZcptracingValue _zcptracing) {
        if (_zcptracing.equals((Object)this.delegate.getZcptracing())) {
            this.record.set("ZCPTRACING", null);
        } else {
            ConnectionType.ZCPTRACING.validate((Object)_zcptracing);
            String connectionSpecificExternalValue = ((CICSAttribute)ConnectionType.ZCPTRACING).set(_zcptracing, this.record.getNormalizers());
            this.record.set("ZCPTRACING", connectionSpecificExternalValue);
        }
    }

    public void setRecovstatus(IConnection.RecovstatusValue _recovstatus) {
        if (_recovstatus.equals((Object)this.delegate.getRecovstatus())) {
            this.record.set("RECOVSTATUS", null);
        } else {
            ConnectionType.RECOVSTATUS.validate((Object)_recovstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ConnectionType.RECOVSTATUS).set(_recovstatus, this.record.getNormalizers());
            this.record.set("RECOVSTATUS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ConnectionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ConnectionType.PROTOCOL) {
            return (V)this.getProtocol();
        }
        if (attribute == ConnectionType.TYPE) {
            return (V)this.getType();
        }
        if (attribute == ConnectionType.ACCESSMETHOD) {
            return (V)this.getAccessmethod();
        }
        if (attribute == ConnectionType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == ConnectionType.AUTOSTATUS) {
            return (V)this.getAutostatus();
        }
        if (attribute == ConnectionType.EXITTRACING) {
            return (V)this.getExittracing();
        }
        if (attribute == ConnectionType.NET_NAME) {
            return (V)this.getNetName();
        }
        if (attribute == ConnectionType.SERVICE_STATUS) {
            return (V)this.getServiceStatus();
        }
        if (attribute == ConnectionType.PENDING_STATUS) {
            return (V)this.getPendingStatus();
        }
        if (attribute == ConnectionType.XLNSTATUS) {
            return (V)this.getXlnstatus();
        }
        if (attribute == ConnectionType.ZCPTRACING) {
            return (V)this.getZcptracing();
        }
        if (attribute == ConnectionType.AIDS) {
            return (V)this.getAids();
        }
        if (attribute == ConnectionType.NONSPECAIDS) {
            return (V)this.getNonspecaids();
        }
        if (attribute == ConnectionType.CONCURBIDS) {
            return (V)this.getConcurbids();
        }
        if (attribute == ConnectionType.MAXSECOND) {
            return (V)this.getMaxsecond();
        }
        if (attribute == ConnectionType.MAXBIDS) {
            return (V)this.getMaxbids();
        }
        if (attribute == ConnectionType.OUTSALLOC) {
            return (V)this.getOutsalloc();
        }
        if (attribute == ConnectionType.ATISBPRI) {
            return (V)this.getAtisbpri();
        }
        if (attribute == ConnectionType.ATISBSEC) {
            return (V)this.getAtisbsec();
        }
        if (attribute == ConnectionType.BIDSSENT) {
            return (V)this.getBidssent();
        }
        if (attribute == ConnectionType.ALLOCATES) {
            return (V)this.getAllocates();
        }
        if (attribute == ConnectionType.QUEDALLOCATE) {
            return (V)this.getQuedallocate();
        }
        if (attribute == ConnectionType.FAILINKALLOC) {
            return (V)this.getFailinkalloc();
        }
        if (attribute == ConnectionType.FAILEDOTHERS) {
            return (V)this.getFailedothers();
        }
        if (attribute == ConnectionType.FCFUNCSHIP) {
            return (V)this.getFcfuncship();
        }
        if (attribute == ConnectionType.ICFUNCSHIP) {
            return (V)this.getIcfuncship();
        }
        if (attribute == ConnectionType.TDFUNCSHIP) {
            return (V)this.getTdfuncship();
        }
        if (attribute == ConnectionType.TSFUNCSHIP) {
            return (V)this.getTsfuncship();
        }
        if (attribute == ConnectionType.DLIFUNCSHIP) {
            return (V)this.getDlifuncship();
        }
        if (attribute == ConnectionType.TERMSHAREREQ) {
            return (V)this.getTermsharereq();
        }
        if (attribute == ConnectionType.MAXPRIMARIES) {
            return (V)this.getMaxprimaries();
        }
        if (attribute == ConnectionType.MAXQTPURGCNT) {
            return (V)this.getMaxqtpurgcnt();
        }
        if (attribute == ConnectionType.EXIT_REJALLC) {
            return (V)this.getExit_rejallc();
        }
        if (attribute == ConnectionType.CONNTYPE) {
            return (V)this.getConntype();
        }
        if (attribute == ConnectionType.RECEIVECOUNT) {
            return (V)this.getReceivecount();
        }
        if (attribute == ConnectionType.SENDCOUNT) {
            return (V)this.getSendcount();
        }
        if (attribute == ConnectionType.MAXQTIME) {
            return (V)this.getMaxqtime();
        }
        if (attribute == ConnectionType.ALLOCQLIMIT) {
            return (V)this.getAllocqlimit();
        }
        if (attribute == ConnectionType.XZIQREJS) {
            return (V)this.getXziqrejs();
        }
        if (attribute == ConnectionType.XZIQPRGCNT) {
            return (V)this.getXziqprgcnt();
        }
        if (attribute == ConnectionType.XZIQALLCPRG) {
            return (V)this.getXziqallcprg();
        }
        if (attribute == ConnectionType.MAXQTALLCPRG) {
            return (V)this.getMaxqtallcprg();
        }
        if (attribute == ConnectionType.RECOVSTATUS) {
            return (V)this.getRecovstatus();
        }
        if (attribute == ConnectionType.REMOTESYSTEM) {
            return (V)this.getRemotesystem();
        }
        if (attribute == ConnectionType.REMOTESYSNET) {
            return (V)this.getRemotesysnet();
        }
        if (attribute == ConnectionType.REMOTENAME) {
            return (V)this.getRemotename();
        }
        if (attribute == ConnectionType.LINKSYSTEM) {
            return (V)this.getLinksystem();
        }
        if (attribute == ConnectionType.GMTCREATIME) {
            return (V)this.getGmtcreatime();
        }
        if (attribute == ConnectionType.CONNCREATIME) {
            return (V)this.getConncreatime();
        }
        if (attribute == ConnectionType.GMTDELETIME) {
            return (V)this.getGmtdeletime();
        }
        if (attribute == ConnectionType.CONNDELETIME) {
            return (V)this.getConndeletime();
        }
        if (attribute == ConnectionType.PRICURRUSED) {
            return (V)this.getPricurrused();
        }
        if (attribute == ConnectionType.SECCURRUSED) {
            return (V)this.getSeccurrused();
        }
        if (attribute == ConnectionType.GRNAME) {
            return (V)this.getGrname();
        }
        if (attribute == ConnectionType.MEMBERNAME) {
            return (V)this.getMembername();
        }
        if (attribute == ConnectionType.DPLFUNCSHIP) {
            return (V)this.getDplfuncship();
        }
        if (attribute == ConnectionType.NQNAME) {
            return (V)this.getNqname();
        }
        if (attribute == ConnectionType.ESTPCCHNL) {
            return (V)this.getEstpcchnl();
        }
        if (attribute == ConnectionType.ESTPCCHNSENT) {
            return (V)this.getEstpcchnsent();
        }
        if (attribute == ConnectionType.ESTPCCHNRCVD) {
            return (V)this.getEstpcchnrcvd();
        }
        if (attribute == ConnectionType.ESTICCHNL) {
            return (V)this.getEsticchnl();
        }
        if (attribute == ConnectionType.ESTICCHNSENT) {
            return (V)this.getEsticchnsent();
        }
        if (attribute == ConnectionType.ESTICCHNRCVD) {
            return (V)this.getEsticchnrcvd();
        }
        if (attribute == ConnectionType.ESTTCCHNL) {
            return (V)this.getEsttcchnl();
        }
        if (attribute == ConnectionType.ESTTCCHNSENT) {
            return (V)this.getEsttcchnsent();
        }
        if (attribute == ConnectionType.ESTTCCHNRCVD) {
            return (V)this.getEsttcchnrcvd();
        }
        if (attribute == ConnectionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == ConnectionType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == ConnectionType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == ConnectionType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == ConnectionType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == ConnectionType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == ConnectionType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == ConnectionType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == ConnectionType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == ConnectionType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == ConnectionType.AIDSF) {
            return (V)this.getAidsf();
        }
        if (attribute == ConnectionType.PEAK_AIDS) {
            return (V)this.getPeakAids();
        }
        return super.getAttributeValue(attribute);
    }

    public ConnectionType getObjectType() {
        return ConnectionType.getInstance();
    }

    @Override
    public ConnectionReference getCICSObjectReference() {
        return new ConnectionReference(this.getCICSContainer(), this.getName());
    }
}

