/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.MonitorGroupReference;
import com.ibm.cics.core.model.MonitorGroupType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IMonitorGroup;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableMonitorGroup;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableMonitorGroup
extends MutableCPSMDefinition
implements IMutableMonitorGroup {
    private IMonitorGroup delegate;
    private MutableSMRecord record;

    public MutableMonitorGroup(ICPSM cpsm, IContext context, IMonitorGroup cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("MONGROUP");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public IMonitorGroup.ChangeAgentValue getChangeAgent() {
        String result = this.record.get("CHANGEAGENT");
        if (result == null) {
            return this.delegate.getChangeAgent();
        }
        return (IMonitorGroup.ChangeAgentValue)((CICSAttribute)MonitorGroupType.CHANGE_AGENT).get(result, this.record.getNormalizers());
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getDesc() {
        String result = this.record.get("DESC");
        if (result == null) {
            return this.delegate.getDesc();
        }
        return (String)((CICSAttribute)MonitorGroupType.DESC).get(result, this.record.getNormalizers());
    }

    public void setChangeAgent(IMonitorGroup.ChangeAgentValue _changeAgent) {
        if (_changeAgent.equals((Object)this.delegate.getChangeAgent())) {
            this.record.set("CHANGEAGENT", null);
        } else {
            MonitorGroupType.CHANGE_AGENT.validate((Object)_changeAgent);
            String connectionSpecificExternalValue = ((CICSAttribute)MonitorGroupType.CHANGE_AGENT).set(_changeAgent, this.record.getNormalizers());
            this.record.set("CHANGEAGENT", connectionSpecificExternalValue);
        }
    }

    public void setDesc(String _desc) {
        if (_desc.equals(this.delegate.getDesc())) {
            this.record.set("DESC", null);
        } else {
            MonitorGroupType.DESC.validate((Object)_desc);
            String connectionSpecificExternalValue = ((CICSAttribute)MonitorGroupType.DESC).set(_desc, this.record.getNormalizers());
            this.record.set("DESC", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == MonitorGroupType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == MonitorGroupType.NAME) {
            return (V)this.getName();
        }
        if (attribute == MonitorGroupType.DESC) {
            return (V)this.getDesc();
        }
        return super.getAttributeValue(attribute);
    }

    public MonitorGroupType getObjectType() {
        return MonitorGroupType.getInstance();
    }

    @Override
    public MonitorGroupReference getCICSObjectReference() {
        return new MonitorGroupReference(this.getCICSContainer(), this.getName());
    }
}

