/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.PlatformDefinitionReference;
import com.ibm.cics.core.model.PlatformDefinitionType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IPlatformDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutablePlatformDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutablePlatformDefinition
extends MutableCPSMDefinition
implements IMutablePlatformDefinition {
    private IPlatformDefinition delegate;
    private MutableSMRecord record;

    public MutablePlatformDefinition(ICPSM cpsm, IContext context, IPlatformDefinition cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("PLATDEF");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public IPlatformDefinition.ChangeAgentValue getChangeAgent() {
        String result = this.record.get("CHANGEAGENT");
        if (result == null) {
            return this.delegate.getChangeAgent();
        }
        return (IPlatformDefinition.ChangeAgentValue)((CICSAttribute)PlatformDefinitionType.CHANGE_AGENT).get(result, this.record.getNormalizers());
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getPlatformDirectory() {
        return this.delegate.getPlatformDirectory();
    }

    public void setChangeAgent(IPlatformDefinition.ChangeAgentValue _changeAgent) {
        if (_changeAgent.equals((Object)this.delegate.getChangeAgent())) {
            this.record.set("CHANGEAGENT", null);
        } else {
            PlatformDefinitionType.CHANGE_AGENT.validate((Object)_changeAgent);
            String connectionSpecificExternalValue = ((CICSAttribute)PlatformDefinitionType.CHANGE_AGENT).set(_changeAgent, this.record.getNormalizers());
            this.record.set("CHANGEAGENT", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == PlatformDefinitionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == PlatformDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == PlatformDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == PlatformDefinitionType.PLATFORM_DIRECTORY) {
            return (V)this.getPlatformDirectory();
        }
        return super.getAttributeValue(attribute);
    }

    public PlatformDefinitionType getObjectType() {
        return PlatformDefinitionType.getInstance();
    }

    @Override
    public PlatformDefinitionReference getCICSObjectReference() {
        return new PlatformDefinitionReference(this.getCICSContainer(), this.getName());
    }

    public ICICSObjectSet<IApplicationDefinition> getApplicationDefinitions() {
        return PlatformDefinitionType.APPLICATION_DEFINITIONS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

