/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ZosWorkLoadReference;
import com.ibm.cics.core.model.ZosWorkLoadType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IZosWorkLoad;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableZosWorkLoad;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableZosWorkLoad
extends MutableCICSResource
implements IMutableZosWorkLoad {
    private IZosWorkLoad delegate;
    private MutableSMRecord record;

    public MutableZosWorkLoad(ICPSM cpsm, IContext context, IZosWorkLoad cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("MVSWLM");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public IZosWorkLoad.GoalModeValue getGoalMode() {
        return this.delegate.getGoalMode();
    }

    public IZosWorkLoad.WlmServerValue getWlmServer() {
        return this.delegate.getWlmServer();
    }

    public String getServiceClass() {
        return this.delegate.getServiceClass();
    }

    public String getReportClass() {
        return this.delegate.getReportClass();
    }

    public String getResourceGroup() {
        return this.delegate.getResourceGroup();
    }

    public String getWorkloadName() {
        return this.delegate.getWorkloadName();
    }

    public IZosWorkLoad.GoalTypeValue getGoalType() {
        return this.delegate.getGoalType();
    }

    public Long getVelocityGoalValue() {
        return this.delegate.getVelocityGoalValue();
    }

    public IZosWorkLoad.CpuCriticalValue getCpuCritical() {
        return this.delegate.getCpuCritical();
    }

    public IZosWorkLoad.StorageCriticalValue getStorageCritical() {
        return this.delegate.getStorageCritical();
    }

    public Long getGoalImportance() {
        return this.delegate.getGoalImportance();
    }

    public IZosWorkLoad.GoalManagementValue getGoalManagement() {
        return this.delegate.getGoalManagement();
    }

    public String getCECMachineType() {
        return this.delegate.getCECMachineType();
    }

    public String getCECModel() {
        return this.delegate.getCECModel();
    }

    public Long getHealthIndicatorAdjustmentValue() {
        String result = this.record.get("MNGWLMAD");
        if (result == null) {
            return this.delegate.getHealthIndicatorAdjustmentValue();
        }
        return (Long)((CICSAttribute)ZosWorkLoadType.HEALTH_INDICATOR_ADJUSTMENT_VALUE).get(result, this.record.getNormalizers());
    }

    public Long getHealthIndicator() {
        return this.delegate.getHealthIndicator();
    }

    public Date getLastHealthUpdateTime() {
        return this.delegate.getLastHealthUpdateTime();
    }

    public Long getHealthUpdateInterval() {
        String result = this.record.get("MNGWLMIN");
        if (result == null) {
            return this.delegate.getHealthUpdateInterval();
        }
        return (Long)((CICSAttribute)ZosWorkLoadType.HEALTH_UPDATE_INTERVAL).get(result, this.record.getNormalizers());
    }

    public IZosWorkLoad.HealthStatusValue getHealthStatus() {
        String result = this.record.get("MNGWLMOS");
        if (result == null) {
            return this.delegate.getHealthStatus();
        }
        return (IZosWorkLoad.HealthStatusValue)((CICSAttribute)ZosWorkLoadType.HEALTH_STATUS).get(result, this.record.getNormalizers());
    }

    public void setHealthIndicatorAdjustmentValue(Long _healthIndicatorAdjustmentValue) {
        if (_healthIndicatorAdjustmentValue.equals(this.delegate.getHealthIndicatorAdjustmentValue())) {
            this.record.set("MNGWLMAD", null);
        } else {
            ZosWorkLoadType.HEALTH_INDICATOR_ADJUSTMENT_VALUE.validate((Object)_healthIndicatorAdjustmentValue);
            String connectionSpecificExternalValue = ((CICSAttribute)ZosWorkLoadType.HEALTH_INDICATOR_ADJUSTMENT_VALUE).set(_healthIndicatorAdjustmentValue, this.record.getNormalizers());
            this.record.set("MNGWLMAD", connectionSpecificExternalValue);
        }
    }

    public void setHealthUpdateInterval(Long _healthUpdateInterval) {
        if (_healthUpdateInterval.equals(this.delegate.getHealthUpdateInterval())) {
            this.record.set("MNGWLMIN", null);
        } else {
            ZosWorkLoadType.HEALTH_UPDATE_INTERVAL.validate((Object)_healthUpdateInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)ZosWorkLoadType.HEALTH_UPDATE_INTERVAL).set(_healthUpdateInterval, this.record.getNormalizers());
            this.record.set("MNGWLMIN", connectionSpecificExternalValue);
        }
    }

    public void setHealthStatus(IZosWorkLoad.HealthStatusValue _healthStatus) {
        if (_healthStatus.equals((Object)this.delegate.getHealthStatus())) {
            this.record.set("MNGWLMOS", null);
        } else {
            ZosWorkLoadType.HEALTH_STATUS.validate((Object)_healthStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ZosWorkLoadType.HEALTH_STATUS).set(_healthStatus, this.record.getNormalizers());
            this.record.set("MNGWLMOS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ZosWorkLoadType.GOAL_MODE) {
            return (V)this.getGoalMode();
        }
        if (attribute == ZosWorkLoadType.WLM_SERVER) {
            return (V)this.getWlmServer();
        }
        if (attribute == ZosWorkLoadType.SERVICE_CLASS) {
            return (V)this.getServiceClass();
        }
        if (attribute == ZosWorkLoadType.REPORT_CLASS) {
            return (V)this.getReportClass();
        }
        if (attribute == ZosWorkLoadType.RESOURCE_GROUP) {
            return (V)this.getResourceGroup();
        }
        if (attribute == ZosWorkLoadType.WORKLOAD_NAME) {
            return (V)this.getWorkloadName();
        }
        if (attribute == ZosWorkLoadType.GOAL_TYPE) {
            return (V)this.getGoalType();
        }
        if (attribute == ZosWorkLoadType.VELOCITY_GOAL_VALUE) {
            return (V)this.getVelocityGoalValue();
        }
        if (attribute == ZosWorkLoadType.CPU_CRITICAL) {
            return (V)this.getCpuCritical();
        }
        if (attribute == ZosWorkLoadType.STORAGE_CRITICAL) {
            return (V)this.getStorageCritical();
        }
        if (attribute == ZosWorkLoadType.GOAL_IMPORTANCE) {
            return (V)this.getGoalImportance();
        }
        if (attribute == ZosWorkLoadType.GOAL_MANAGEMENT) {
            return (V)this.getGoalManagement();
        }
        if (attribute == ZosWorkLoadType.CEC_MACHINE_TYPE) {
            return (V)this.getCECMachineType();
        }
        if (attribute == ZosWorkLoadType.CEC_MODEL) {
            return (V)this.getCECModel();
        }
        if (attribute == ZosWorkLoadType.HEALTH_INDICATOR_ADJUSTMENT_VALUE) {
            return (V)this.getHealthIndicatorAdjustmentValue();
        }
        if (attribute == ZosWorkLoadType.HEALTH_INDICATOR) {
            return (V)this.getHealthIndicator();
        }
        if (attribute == ZosWorkLoadType.LAST_HEALTH_UPDATE_TIME) {
            return (V)this.getLastHealthUpdateTime();
        }
        if (attribute == ZosWorkLoadType.HEALTH_UPDATE_INTERVAL) {
            return (V)this.getHealthUpdateInterval();
        }
        if (attribute == ZosWorkLoadType.HEALTH_STATUS) {
            return (V)this.getHealthStatus();
        }
        return super.getAttributeValue(attribute);
    }

    public ZosWorkLoadType getObjectType() {
        return ZosWorkLoadType.getInstance();
    }

    @Override
    public ZosWorkLoadReference getCICSObjectReference() {
        return new ZosWorkLoadReference(this.getCICSContainer());
    }
}

