/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.PlatformDefinitionReference;
import com.ibm.cics.core.model.PlatformDefinitionType;
import com.ibm.cics.core.model.internal.CPSMDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IPlatformDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class PlatformDefinition
extends CPSMDefinition
implements IPlatformDefinition {
    private IPlatformDefinition.ChangeAgentValue _changeagent;
    private String _name;
    private String _description;
    private String _platdir;

    public PlatformDefinition(ICPSMDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._changeagent = (IPlatformDefinition.ChangeAgentValue)avm.getAttributeValue(PlatformDefinitionType.CHANGE_AGENT, true);
        this._name = (String)avm.getAttributeValue(PlatformDefinitionType.NAME);
        this._description = (String)avm.getAttributeValue(PlatformDefinitionType.DESCRIPTION, true);
        this._platdir = (String)avm.getAttributeValue(PlatformDefinitionType.PLATFORM_DIRECTORY, true);
    }

    public PlatformDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("CHANGEAGENT");
        this._changeagent = (IPlatformDefinition.ChangeAgentValue)((CICSAttribute)PlatformDefinitionType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)PlatformDefinitionType.NAME).get(stringValue, normalizers);
        stringValue = record.get("DESCRIPTION");
        this._description = (String)((CICSAttribute)PlatformDefinitionType.DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get("PLATDIR");
        this._platdir = (String)((CICSAttribute)PlatformDefinitionType.PLATFORM_DIRECTORY).get(stringValue, normalizers);
    }

    public IPlatformDefinition.ChangeAgentValue getChangeAgent() {
        return this._changeagent;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public String getPlatformDirectory() {
        return this._platdir;
    }

    public PlatformDefinitionType getObjectType() {
        return PlatformDefinitionType.getInstance();
    }

    @Override
    public PlatformDefinitionReference getCICSObjectReference() {
        return new PlatformDefinitionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == PlatformDefinitionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == PlatformDefinitionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == PlatformDefinitionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == PlatformDefinitionType.PLATFORM_DIRECTORY) {
            return (V)this.getPlatformDirectory();
        }
        return super.getAttributeValue(attribute);
    }

    public ICICSObjectSet<IApplicationDefinition> getApplicationDefinitions() {
        return PlatformDefinitionType.APPLICATION_DEFINITIONS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

