/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ResourceGroupEntryReference;
import com.ibm.cics.core.model.ResourceGroupEntryType;
import com.ibm.cics.core.model.internal.CPSMDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IResourceGroupDefinitionReference;
import com.ibm.cics.model.IResourceGroupEntry;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class ResourceGroupEntryGen
extends CPSMDefinition
implements IResourceGroupEntry {
    private IResourceGroupEntry.ChangeAgentValue _changeagent;
    private String _resgroup;
    private String _deftype;
    private String _defname;
    private Long _defver;
    private String _defdesc;
    private String _deftypex;
    private String _ingptype;
    private String _ingptypx;

    public ResourceGroupEntryGen(ICPSMDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._changeagent = (IResourceGroupEntry.ChangeAgentValue)avm.getAttributeValue(ResourceGroupEntryType.CHANGE_AGENT, true);
        this._resgroup = (String)avm.getAttributeValue(ResourceGroupEntryType.RESOURCE_GROUP);
        this._deftype = (String)avm.getAttributeValue(ResourceGroupEntryType.DEFINITION_TYPE);
        this._defname = (String)avm.getAttributeValue(ResourceGroupEntryType.DEFINITION_NAME);
        this._defver = (Long)avm.getAttributeValue(ResourceGroupEntryType.DEFINITION_VERSION);
        this._defdesc = (String)avm.getAttributeValue(ResourceGroupEntryType.DEFINITION_DESCRIPTION, true);
        this._deftypex = (String)avm.getAttributeValue(ResourceGroupEntryType.DEFINITION_ID, true);
        this._ingptype = (String)avm.getAttributeValue(ResourceGroupEntryType.RESOURCE_IN_GROUP_TYPE, true);
        this._ingptypx = (String)avm.getAttributeValue(ResourceGroupEntryType.RESOURCE_IN_GROUP_ID, true);
    }

    public ResourceGroupEntryGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("CHANGEAGENT");
        this._changeagent = (IResourceGroupEntry.ChangeAgentValue)((CICSAttribute)ResourceGroupEntryType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get("RESGROUP");
        this._resgroup = (String)((CICSAttribute)ResourceGroupEntryType.RESOURCE_GROUP).get(stringValue, normalizers);
        stringValue = record.get("DEFTYPE");
        this._deftype = (String)((CICSAttribute)ResourceGroupEntryType.DEFINITION_TYPE).get(stringValue, normalizers);
        stringValue = record.get("DEFNAME");
        this._defname = (String)((CICSAttribute)ResourceGroupEntryType.DEFINITION_NAME).get(stringValue, normalizers);
        stringValue = record.get("DEFVER");
        this._defver = (Long)((CICSAttribute)ResourceGroupEntryType.DEFINITION_VERSION).get(stringValue, normalizers);
        stringValue = record.get("DEFDESC");
        this._defdesc = (String)((CICSAttribute)ResourceGroupEntryType.DEFINITION_DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get("DEFTYPEX");
        this._deftypex = (String)((CICSAttribute)ResourceGroupEntryType.DEFINITION_ID).get(stringValue, normalizers);
        stringValue = record.get("INGPTYPE");
        this._ingptype = (String)((CICSAttribute)ResourceGroupEntryType.RESOURCE_IN_GROUP_TYPE).get(stringValue, normalizers);
        stringValue = record.get("INGPTYPX");
        this._ingptypx = (String)((CICSAttribute)ResourceGroupEntryType.RESOURCE_IN_GROUP_ID).get(stringValue, normalizers);
    }

    public IResourceGroupEntry.ChangeAgentValue getChangeAgent() {
        return this._changeagent;
    }

    public String getResourceGroup() {
        return this._resgroup;
    }

    public String getDefinitionType() {
        return this._deftype;
    }

    public String getDefinitionName() {
        return this._defname;
    }

    public Long getDefinitionVersion() {
        return this._defver;
    }

    public String getDefinitionDescription() {
        return this._defdesc;
    }

    public String getDefinitionID() {
        return this._deftypex;
    }

    public String getResourceInGroupType() {
        return this._ingptype;
    }

    public String getResourceInGroupID() {
        return this._ingptypx;
    }

    public ResourceGroupEntryType getObjectType() {
        return ResourceGroupEntryType.getInstance();
    }

    @Override
    public ResourceGroupEntryReference getCICSObjectReference() {
        return new ResourceGroupEntryReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ResourceGroupEntryType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == ResourceGroupEntryType.RESOURCE_GROUP) {
            return (V)this.getResourceGroup();
        }
        if (attribute == ResourceGroupEntryType.DEFINITION_TYPE) {
            return (V)this.getDefinitionType();
        }
        if (attribute == ResourceGroupEntryType.DEFINITION_NAME) {
            return (V)this.getDefinitionName();
        }
        if (attribute == ResourceGroupEntryType.DEFINITION_VERSION) {
            return (V)this.getDefinitionVersion();
        }
        if (attribute == ResourceGroupEntryType.DEFINITION_DESCRIPTION) {
            return (V)this.getDefinitionDescription();
        }
        if (attribute == ResourceGroupEntryType.DEFINITION_ID) {
            return (V)this.getDefinitionID();
        }
        if (attribute == ResourceGroupEntryType.RESOURCE_IN_GROUP_TYPE) {
            return (V)this.getResourceInGroupType();
        }
        if (attribute == ResourceGroupEntryType.RESOURCE_IN_GROUP_ID) {
            return (V)this.getResourceInGroupID();
        }
        return super.getAttributeValue(attribute);
    }

    public IResourceGroupDefinitionReference getGroup() {
        return (IResourceGroupDefinitionReference)ResourceGroupEntryType.GROUP.getTo((ICICSObject)this);
    }
}

