/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.SystemDumpReference;
import com.ibm.cics.core.model.SystemDumpType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.ISystemDump;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;
import java.util.Map;

public class SystemDump
extends CICSResource
implements ISystemDump {
    private String _sysdumpcode;
    private Long _current;
    private Long _maximum;
    private ISystemDump.ShutdownOptionValue _shutoption;
    private ISystemDump.SystemDumpOptionValue _sysdumping;
    private Long _sdmptotl;
    private Long _sdmpsupp;
    private ISystemDump.SystemDumpScopeValue _sdumpscope;
    private ISystemDump.DAEOptionValue _daeoption;
    private String _joblist;
    private String _dsplist;
    private Date _changetime;
    private ISystemDump.ChangeAgentValue _changeagent;
    private String _changeagrel;
    private String _changeusrid;
    private String _definesource;
    private Date _definetime;
    private String _installusrid;
    private Date _installtime;
    private ISystemDump.InstallAgentValue _installagent;

    public SystemDump(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._sysdumpcode = (String)avm.getAttributeValue(SystemDumpType.SYSTEM_DUMP_CODE);
        this._current = (Long)avm.getAttributeValue(SystemDumpType.SYSTEM_DUMPS_SINCE_RESET, true);
        this._maximum = (Long)avm.getAttributeValue(SystemDumpType.MAXIMUM_SYSTEM_DUMPS, true);
        this._shutoption = (ISystemDump.ShutdownOptionValue)avm.getAttributeValue(SystemDumpType.SHUTDOWN_OPTION, true);
        this._sysdumping = (ISystemDump.SystemDumpOptionValue)avm.getAttributeValue(SystemDumpType.SYSTEM_DUMP_OPTION, true);
        this._sdmptotl = (Long)avm.getAttributeValue(SystemDumpType.SYSTEM_DUMPS_TAKEN, true);
        this._sdmpsupp = (Long)avm.getAttributeValue(SystemDumpType.SYSTEM_DUMPS_SUPPRESSED, true);
        this._sdumpscope = (ISystemDump.SystemDumpScopeValue)avm.getAttributeValue(SystemDumpType.SYSTEM_DUMP_SCOPE, true);
        this._daeoption = (ISystemDump.DAEOptionValue)avm.getAttributeValue(SystemDumpType.DAE_OPTION, true);
        this._joblist = (String)avm.getAttributeValue(SystemDumpType.JOB_NAME_LIST, true);
        this._dsplist = (String)avm.getAttributeValue(SystemDumpType.DATA_SPACE_NAME_LIST, true);
        this._changetime = (Date)avm.getAttributeValue(SystemDumpType.CHANGE_TIME, true);
        this._changeagent = (ISystemDump.ChangeAgentValue)avm.getAttributeValue(SystemDumpType.CHANGE_AGENT, true);
        this._changeagrel = (String)avm.getAttributeValue(SystemDumpType.CHANGE_AGENT_RELEASE, true);
        this._changeusrid = (String)avm.getAttributeValue(SystemDumpType.CHANGE_USER_ID, true);
        this._definesource = (String)avm.getAttributeValue(SystemDumpType.DEFINE_SOURCE, true);
        this._definetime = (Date)avm.getAttributeValue(SystemDumpType.DEFINE_TIME, true);
        this._installusrid = (String)avm.getAttributeValue(SystemDumpType.INSTALL_USER_ID, true);
        this._installtime = (Date)avm.getAttributeValue(SystemDumpType.INSTALL_TIME, true);
        this._installagent = (ISystemDump.InstallAgentValue)avm.getAttributeValue(SystemDumpType.INSTALL_AGENT, true);
    }

    public SystemDump(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("SYSDUMPCODE");
        this._sysdumpcode = (String)((CICSAttribute)SystemDumpType.SYSTEM_DUMP_CODE).get(stringValue, normalizers);
        stringValue = record.get("CURRENT");
        this._current = (Long)((CICSAttribute)SystemDumpType.SYSTEM_DUMPS_SINCE_RESET).get(stringValue, normalizers);
        stringValue = record.get("MAXIMUM");
        this._maximum = (Long)((CICSAttribute)SystemDumpType.MAXIMUM_SYSTEM_DUMPS).get(stringValue, normalizers);
        stringValue = record.get("SHUTOPTION");
        this._shutoption = (ISystemDump.ShutdownOptionValue)((CICSAttribute)SystemDumpType.SHUTDOWN_OPTION).get(stringValue, normalizers);
        stringValue = record.get("SYSDUMPING");
        this._sysdumping = (ISystemDump.SystemDumpOptionValue)((CICSAttribute)SystemDumpType.SYSTEM_DUMP_OPTION).get(stringValue, normalizers);
        stringValue = record.get("SDMPTOTL");
        this._sdmptotl = (Long)((CICSAttribute)SystemDumpType.SYSTEM_DUMPS_TAKEN).get(stringValue, normalizers);
        stringValue = record.get("SDMPSUPP");
        this._sdmpsupp = (Long)((CICSAttribute)SystemDumpType.SYSTEM_DUMPS_SUPPRESSED).get(stringValue, normalizers);
        stringValue = record.get("SDUMPSCOPE");
        this._sdumpscope = (ISystemDump.SystemDumpScopeValue)((CICSAttribute)SystemDumpType.SYSTEM_DUMP_SCOPE).get(stringValue, normalizers);
        stringValue = record.get("DAEOPTION");
        this._daeoption = (ISystemDump.DAEOptionValue)((CICSAttribute)SystemDumpType.DAE_OPTION).get(stringValue, normalizers);
        stringValue = record.get("JOBLIST");
        this._joblist = (String)((CICSAttribute)SystemDumpType.JOB_NAME_LIST).get(stringValue, normalizers);
        stringValue = record.get("DSPLIST");
        this._dsplist = (String)((CICSAttribute)SystemDumpType.DATA_SPACE_NAME_LIST).get(stringValue, normalizers);
        stringValue = record.get("CHANGETIME");
        this._changetime = (Date)((CICSAttribute)SystemDumpType.CHANGE_TIME).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGENT");
        this._changeagent = (ISystemDump.ChangeAgentValue)((CICSAttribute)SystemDumpType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGREL");
        this._changeagrel = (String)((CICSAttribute)SystemDumpType.CHANGE_AGENT_RELEASE).get(stringValue, normalizers);
        stringValue = record.get("CHANGEUSRID");
        this._changeusrid = (String)((CICSAttribute)SystemDumpType.CHANGE_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("DEFINESOURCE");
        this._definesource = (String)((CICSAttribute)SystemDumpType.DEFINE_SOURCE).get(stringValue, normalizers);
        stringValue = record.get("DEFINETIME");
        this._definetime = (Date)((CICSAttribute)SystemDumpType.DEFINE_TIME).get(stringValue, normalizers);
        stringValue = record.get("INSTALLUSRID");
        this._installusrid = (String)((CICSAttribute)SystemDumpType.INSTALL_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("INSTALLTIME");
        this._installtime = (Date)((CICSAttribute)SystemDumpType.INSTALL_TIME).get(stringValue, normalizers);
        stringValue = record.get("INSTALLAGENT");
        this._installagent = (ISystemDump.InstallAgentValue)((CICSAttribute)SystemDumpType.INSTALL_AGENT).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return SystemDumpType.SYSTEM_DUMP_CODE.internalToExternal((Object)this.getSystemDumpCode());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getSystemDumpCode() {
        return this._sysdumpcode;
    }

    public Long getSystemDumpsSinceReset() {
        return this._current;
    }

    public Long getMaximumSystemDumps() {
        return this._maximum;
    }

    public ISystemDump.ShutdownOptionValue getShutdownOption() {
        return this._shutoption;
    }

    public ISystemDump.SystemDumpOptionValue getSystemDumpOption() {
        return this._sysdumping;
    }

    public Long getSystemDumpsTaken() {
        return this._sdmptotl;
    }

    public Long getSystemDumpsSuppressed() {
        return this._sdmpsupp;
    }

    public ISystemDump.SystemDumpScopeValue getSystemDumpScope() {
        return this._sdumpscope;
    }

    public ISystemDump.DAEOptionValue getDAEOption() {
        return this._daeoption;
    }

    public String getJobNameList() {
        return this._joblist;
    }

    public String getDataSpaceNameList() {
        return this._dsplist;
    }

    public Date getChangeTime() {
        return this._changetime;
    }

    public ISystemDump.ChangeAgentValue getChangeAgent() {
        return this._changeagent;
    }

    public String getChangeAgentRelease() {
        return this._changeagrel;
    }

    public String getChangeUserID() {
        return this._changeusrid;
    }

    public String getDefineSource() {
        return this._definesource;
    }

    public Date getDefineTime() {
        return this._definetime;
    }

    public String getInstallUserID() {
        return this._installusrid;
    }

    public Date getInstallTime() {
        return this._installtime;
    }

    public ISystemDump.InstallAgentValue getInstallAgent() {
        return this._installagent;
    }

    public SystemDumpType getObjectType() {
        return SystemDumpType.getInstance();
    }

    @Override
    public SystemDumpReference getCICSObjectReference() {
        return new SystemDumpReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == SystemDumpType.SYSTEM_DUMP_CODE) {
            return (V)this.getSystemDumpCode();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMPS_SINCE_RESET) {
            return (V)this.getSystemDumpsSinceReset();
        }
        if (attribute == SystemDumpType.MAXIMUM_SYSTEM_DUMPS) {
            return (V)this.getMaximumSystemDumps();
        }
        if (attribute == SystemDumpType.SHUTDOWN_OPTION) {
            return (V)this.getShutdownOption();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMP_OPTION) {
            return (V)this.getSystemDumpOption();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMPS_TAKEN) {
            return (V)this.getSystemDumpsTaken();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMPS_SUPPRESSED) {
            return (V)this.getSystemDumpsSuppressed();
        }
        if (attribute == SystemDumpType.SYSTEM_DUMP_SCOPE) {
            return (V)this.getSystemDumpScope();
        }
        if (attribute == SystemDumpType.DAE_OPTION) {
            return (V)this.getDAEOption();
        }
        if (attribute == SystemDumpType.JOB_NAME_LIST) {
            return (V)this.getJobNameList();
        }
        if (attribute == SystemDumpType.DATA_SPACE_NAME_LIST) {
            return (V)this.getDataSpaceNameList();
        }
        if (attribute == SystemDumpType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == SystemDumpType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == SystemDumpType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == SystemDumpType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == SystemDumpType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == SystemDumpType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == SystemDumpType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == SystemDumpType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == SystemDumpType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        return super.getAttributeValue(attribute);
    }
}

