/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TSQueueReference;
import com.ibm.cics.core.model.TSQueueType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.ITSQueue;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class TSQueueGen
extends CICSResource
implements ITSQueue {
    private String _name;
    private ITSQueue.LocationValue _location;
    private Long _quelength;
    private Long _maxitemlen;
    private Long _minitemlen;
    private Long _numitems;
    private Long _lastusedint;
    private String _transid;
    private ITSQueue.RecovstatusValue _recovstatus;
    private Long _expiryint;
    private String _hexname;
    private Long _expiryintmin;
    private String _tsmodel;

    public TSQueueGen(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._name = (String)avm.getAttributeValue(TSQueueType.NAME);
        this._location = (ITSQueue.LocationValue)avm.getAttributeValue(TSQueueType.LOCATION, true);
        this._quelength = (Long)avm.getAttributeValue(TSQueueType.QUEUE_LENGTH, true);
        this._maxitemlen = (Long)avm.getAttributeValue(TSQueueType.MAX_ITEM_LENGTH, true);
        this._minitemlen = (Long)avm.getAttributeValue(TSQueueType.MIN_ITEM_LENGTH, true);
        this._numitems = (Long)avm.getAttributeValue(TSQueueType.ITEM_COUNT, true);
        this._lastusedint = (Long)avm.getAttributeValue(TSQueueType.LASTUSEDINT, true);
        this._transid = (String)avm.getAttributeValue(TSQueueType.TRANSID, true);
        this._recovstatus = (ITSQueue.RecovstatusValue)avm.getAttributeValue(TSQueueType.RECOVSTATUS, true);
        this._expiryint = (Long)avm.getAttributeValue(TSQueueType.EXPIRYINT, true);
        this._hexname = (String)avm.getAttributeValue(TSQueueType.HEXNAME, true);
        this._expiryintmin = (Long)avm.getAttributeValue(TSQueueType.EXPIRYINTMIN, true);
        this._tsmodel = (String)avm.getAttributeValue(TSQueueType.TS_MODEL, true);
    }

    public TSQueueGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)TSQueueType.NAME).get(stringValue, normalizers);
        stringValue = record.get("LOCATION");
        this._location = (ITSQueue.LocationValue)((CICSAttribute)TSQueueType.LOCATION).get(stringValue, normalizers);
        stringValue = record.get("QUELENGTH");
        this._quelength = (Long)((CICSAttribute)TSQueueType.QUEUE_LENGTH).get(stringValue, normalizers);
        stringValue = record.get("MAXITEMLEN");
        this._maxitemlen = (Long)((CICSAttribute)TSQueueType.MAX_ITEM_LENGTH).get(stringValue, normalizers);
        stringValue = record.get("MINITEMLEN");
        this._minitemlen = (Long)((CICSAttribute)TSQueueType.MIN_ITEM_LENGTH).get(stringValue, normalizers);
        stringValue = record.get("NUMITEMS");
        this._numitems = (Long)((CICSAttribute)TSQueueType.ITEM_COUNT).get(stringValue, normalizers);
        stringValue = record.get("LASTUSEDINT");
        this._lastusedint = (Long)((CICSAttribute)TSQueueType.LASTUSEDINT).get(stringValue, normalizers);
        stringValue = record.get("TRANSID");
        this._transid = (String)((CICSAttribute)TSQueueType.TRANSID).get(stringValue, normalizers);
        stringValue = record.get("RECOVSTATUS");
        this._recovstatus = (ITSQueue.RecovstatusValue)((CICSAttribute)TSQueueType.RECOVSTATUS).get(stringValue, normalizers);
        stringValue = record.get("EXPIRYINT");
        this._expiryint = (Long)((CICSAttribute)TSQueueType.EXPIRYINT).get(stringValue, normalizers);
        stringValue = record.get("HEXNAME");
        this._hexname = (String)((CICSAttribute)TSQueueType.HEXNAME).get(stringValue, normalizers);
        stringValue = record.get("EXPIRYINTMIN");
        this._expiryintmin = (Long)((CICSAttribute)TSQueueType.EXPIRYINTMIN).get(stringValue, normalizers);
        stringValue = record.get("TSMODEL");
        this._tsmodel = (String)((CICSAttribute)TSQueueType.TS_MODEL).get(stringValue, normalizers);
    }

    public String getName() {
        return this._name;
    }

    public ITSQueue.LocationValue getLocation() {
        return this._location;
    }

    public Long getQueueLength() {
        return this._quelength;
    }

    public Long getMaxItemLength() {
        return this._maxitemlen;
    }

    public Long getMinItemLength() {
        return this._minitemlen;
    }

    public Long getItemCount() {
        return this._numitems;
    }

    public Long getLastusedint() {
        return this._lastusedint;
    }

    public String getTransid() {
        return this._transid;
    }

    public ITSQueue.RecovstatusValue getRecovstatus() {
        return this._recovstatus;
    }

    public Long getExpiryint() {
        return this._expiryint;
    }

    public String getHexname() {
        return this._hexname;
    }

    public Long getExpiryintmin() {
        return this._expiryintmin;
    }

    public String getTSModel() {
        return this._tsmodel;
    }

    public TSQueueType getObjectType() {
        return TSQueueType.getInstance();
    }

    @Override
    public TSQueueReference getCICSObjectReference() {
        return new TSQueueReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TSQueueType.NAME) {
            return (V)this.getName();
        }
        if (attribute == TSQueueType.LOCATION) {
            return (V)this.getLocation();
        }
        if (attribute == TSQueueType.QUEUE_LENGTH) {
            return (V)this.getQueueLength();
        }
        if (attribute == TSQueueType.MAX_ITEM_LENGTH) {
            return (V)this.getMaxItemLength();
        }
        if (attribute == TSQueueType.MIN_ITEM_LENGTH) {
            return (V)this.getMinItemLength();
        }
        if (attribute == TSQueueType.ITEM_COUNT) {
            return (V)this.getItemCount();
        }
        if (attribute == TSQueueType.LASTUSEDINT) {
            return (V)this.getLastusedint();
        }
        if (attribute == TSQueueType.TRANSID) {
            return (V)this.getTransid();
        }
        if (attribute == TSQueueType.RECOVSTATUS) {
            return (V)this.getRecovstatus();
        }
        if (attribute == TSQueueType.EXPIRYINT) {
            return (V)this.getExpiryint();
        }
        if (attribute == TSQueueType.HEXNAME) {
            return (V)this.getHexname();
        }
        if (attribute == TSQueueType.EXPIRYINTMIN) {
            return (V)this.getExpiryintmin();
        }
        if (attribute == TSQueueType.TS_MODEL) {
            return (V)this.getTSModel();
        }
        return super.getAttributeValue(attribute);
    }
}

