/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.TransactionDumpReference;
import com.ibm.cics.core.model.TransactionDumpType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.ITransactionDump;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;
import java.util.Map;

public class TransactionDump
extends CICSResource
implements ITransactionDump {
    private String _trandumpcode;
    private Long _current;
    private Long _maximum;
    private ITransactionDump.ShutdownOptionValue _shutoption;
    private ITransactionDump.SystemDumpOptionValue _sysdumping;
    private ITransactionDump.TransactionDumpOptionValue _trandumping;
    private Long _tdmptotl;
    private Long _tdmpsupp;
    private Long _sdmptotl;
    private Long _sdmpsupp;
    private ITransactionDump.TransactionDumpScopeValue _tdumpscope;
    private Date _changetime;
    private ITransactionDump.ChangeAgentValue _changeagent;
    private String _changeagrel;
    private String _changeusrid;
    private String _definesource;
    private Date _definetime;
    private String _installusrid;
    private Date _installtime;
    private ITransactionDump.InstallAgentValue _installagent;

    public TransactionDump(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._trandumpcode = (String)avm.getAttributeValue(TransactionDumpType.TRANSACTION_DUMP_CODE);
        this._current = (Long)avm.getAttributeValue(TransactionDumpType.TRANSACTION_DUMPS_SINCE_RESET, true);
        this._maximum = (Long)avm.getAttributeValue(TransactionDumpType.MAXIMUM_TRANSACTION_DUMPS, true);
        this._shutoption = (ITransactionDump.ShutdownOptionValue)avm.getAttributeValue(TransactionDumpType.SHUTDOWN_OPTION, true);
        this._sysdumping = (ITransactionDump.SystemDumpOptionValue)avm.getAttributeValue(TransactionDumpType.SYSTEM_DUMP_OPTION, true);
        this._trandumping = (ITransactionDump.TransactionDumpOptionValue)avm.getAttributeValue(TransactionDumpType.TRANSACTION_DUMP_OPTION, true);
        this._tdmptotl = (Long)avm.getAttributeValue(TransactionDumpType.TRANSACTION_DUMPS_TAKEN, true);
        this._tdmpsupp = (Long)avm.getAttributeValue(TransactionDumpType.TRANSACTION_DUMPS_SUPPRESSED, true);
        this._sdmptotl = (Long)avm.getAttributeValue(TransactionDumpType.SYSTEM_DUMPS_TAKEN, true);
        this._sdmpsupp = (Long)avm.getAttributeValue(TransactionDumpType.SYSTEM_DUMPS_SUPPRESSED, true);
        this._tdumpscope = (ITransactionDump.TransactionDumpScopeValue)avm.getAttributeValue(TransactionDumpType.TRANSACTION_DUMP_SCOPE, true);
        this._changetime = (Date)avm.getAttributeValue(TransactionDumpType.CHANGE_TIME, true);
        this._changeagent = (ITransactionDump.ChangeAgentValue)avm.getAttributeValue(TransactionDumpType.CHANGE_AGENT, true);
        this._changeagrel = (String)avm.getAttributeValue(TransactionDumpType.CHANGE_AGENT_RELEASE, true);
        this._changeusrid = (String)avm.getAttributeValue(TransactionDumpType.CHANGE_USER_ID, true);
        this._definesource = (String)avm.getAttributeValue(TransactionDumpType.DEFINE_SOURCE, true);
        this._definetime = (Date)avm.getAttributeValue(TransactionDumpType.DEFINE_TIME, true);
        this._installusrid = (String)avm.getAttributeValue(TransactionDumpType.INSTALL_USER_ID, true);
        this._installtime = (Date)avm.getAttributeValue(TransactionDumpType.INSTALL_TIME, true);
        this._installagent = (ITransactionDump.InstallAgentValue)avm.getAttributeValue(TransactionDumpType.INSTALL_AGENT, true);
    }

    public TransactionDump(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("TRANDUMPCODE");
        this._trandumpcode = (String)((CICSAttribute)TransactionDumpType.TRANSACTION_DUMP_CODE).get(stringValue, normalizers);
        stringValue = record.get("CURRENT");
        this._current = (Long)((CICSAttribute)TransactionDumpType.TRANSACTION_DUMPS_SINCE_RESET).get(stringValue, normalizers);
        stringValue = record.get("MAXIMUM");
        this._maximum = (Long)((CICSAttribute)TransactionDumpType.MAXIMUM_TRANSACTION_DUMPS).get(stringValue, normalizers);
        stringValue = record.get("SHUTOPTION");
        this._shutoption = (ITransactionDump.ShutdownOptionValue)((CICSAttribute)TransactionDumpType.SHUTDOWN_OPTION).get(stringValue, normalizers);
        stringValue = record.get("SYSDUMPING");
        this._sysdumping = (ITransactionDump.SystemDumpOptionValue)((CICSAttribute)TransactionDumpType.SYSTEM_DUMP_OPTION).get(stringValue, normalizers);
        stringValue = record.get("TRANDUMPING");
        this._trandumping = (ITransactionDump.TransactionDumpOptionValue)((CICSAttribute)TransactionDumpType.TRANSACTION_DUMP_OPTION).get(stringValue, normalizers);
        stringValue = record.get("TDMPTOTL");
        this._tdmptotl = (Long)((CICSAttribute)TransactionDumpType.TRANSACTION_DUMPS_TAKEN).get(stringValue, normalizers);
        stringValue = record.get("TDMPSUPP");
        this._tdmpsupp = (Long)((CICSAttribute)TransactionDumpType.TRANSACTION_DUMPS_SUPPRESSED).get(stringValue, normalizers);
        stringValue = record.get("SDMPTOTL");
        this._sdmptotl = (Long)((CICSAttribute)TransactionDumpType.SYSTEM_DUMPS_TAKEN).get(stringValue, normalizers);
        stringValue = record.get("SDMPSUPP");
        this._sdmpsupp = (Long)((CICSAttribute)TransactionDumpType.SYSTEM_DUMPS_SUPPRESSED).get(stringValue, normalizers);
        stringValue = record.get("TDUMPSCOPE");
        this._tdumpscope = (ITransactionDump.TransactionDumpScopeValue)((CICSAttribute)TransactionDumpType.TRANSACTION_DUMP_SCOPE).get(stringValue, normalizers);
        stringValue = record.get("CHANGETIME");
        this._changetime = (Date)((CICSAttribute)TransactionDumpType.CHANGE_TIME).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGENT");
        this._changeagent = (ITransactionDump.ChangeAgentValue)((CICSAttribute)TransactionDumpType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get("CHANGEAGREL");
        this._changeagrel = (String)((CICSAttribute)TransactionDumpType.CHANGE_AGENT_RELEASE).get(stringValue, normalizers);
        stringValue = record.get("CHANGEUSRID");
        this._changeusrid = (String)((CICSAttribute)TransactionDumpType.CHANGE_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("DEFINESOURCE");
        this._definesource = (String)((CICSAttribute)TransactionDumpType.DEFINE_SOURCE).get(stringValue, normalizers);
        stringValue = record.get("DEFINETIME");
        this._definetime = (Date)((CICSAttribute)TransactionDumpType.DEFINE_TIME).get(stringValue, normalizers);
        stringValue = record.get("INSTALLUSRID");
        this._installusrid = (String)((CICSAttribute)TransactionDumpType.INSTALL_USER_ID).get(stringValue, normalizers);
        stringValue = record.get("INSTALLTIME");
        this._installtime = (Date)((CICSAttribute)TransactionDumpType.INSTALL_TIME).get(stringValue, normalizers);
        stringValue = record.get("INSTALLAGENT");
        this._installagent = (ITransactionDump.InstallAgentValue)((CICSAttribute)TransactionDumpType.INSTALL_AGENT).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return TransactionDumpType.TRANSACTION_DUMP_CODE.internalToExternal((Object)this.getTransactionDumpCode());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getTransactionDumpCode() {
        return this._trandumpcode;
    }

    public Long getTransactionDumpsSinceReset() {
        return this._current;
    }

    public Long getMaximumTransactionDumps() {
        return this._maximum;
    }

    public ITransactionDump.ShutdownOptionValue getShutdownOption() {
        return this._shutoption;
    }

    public ITransactionDump.SystemDumpOptionValue getSystemDumpOption() {
        return this._sysdumping;
    }

    public ITransactionDump.TransactionDumpOptionValue getTransactionDumpOption() {
        return this._trandumping;
    }

    public Long getTransactionDumpsTaken() {
        return this._tdmptotl;
    }

    public Long getTransactionDumpsSuppressed() {
        return this._tdmpsupp;
    }

    public Long getSystemDumpsTaken() {
        return this._sdmptotl;
    }

    public Long getSystemDumpsSuppressed() {
        return this._sdmpsupp;
    }

    public ITransactionDump.TransactionDumpScopeValue getTransactionDumpScope() {
        return this._tdumpscope;
    }

    public Date getChangeTime() {
        return this._changetime;
    }

    public ITransactionDump.ChangeAgentValue getChangeAgent() {
        return this._changeagent;
    }

    public String getChangeAgentRelease() {
        return this._changeagrel;
    }

    public String getChangeUserID() {
        return this._changeusrid;
    }

    public String getDefineSource() {
        return this._definesource;
    }

    public Date getDefineTime() {
        return this._definetime;
    }

    public String getInstallUserID() {
        return this._installusrid;
    }

    public Date getInstallTime() {
        return this._installtime;
    }

    public ITransactionDump.InstallAgentValue getInstallAgent() {
        return this._installagent;
    }

    public TransactionDumpType getObjectType() {
        return TransactionDumpType.getInstance();
    }

    @Override
    public TransactionDumpReference getCICSObjectReference() {
        return new TransactionDumpReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == TransactionDumpType.TRANSACTION_DUMP_CODE) {
            return (V)this.getTransactionDumpCode();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMPS_SINCE_RESET) {
            return (V)this.getTransactionDumpsSinceReset();
        }
        if (attribute == TransactionDumpType.MAXIMUM_TRANSACTION_DUMPS) {
            return (V)this.getMaximumTransactionDumps();
        }
        if (attribute == TransactionDumpType.SHUTDOWN_OPTION) {
            return (V)this.getShutdownOption();
        }
        if (attribute == TransactionDumpType.SYSTEM_DUMP_OPTION) {
            return (V)this.getSystemDumpOption();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMP_OPTION) {
            return (V)this.getTransactionDumpOption();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMPS_TAKEN) {
            return (V)this.getTransactionDumpsTaken();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMPS_SUPPRESSED) {
            return (V)this.getTransactionDumpsSuppressed();
        }
        if (attribute == TransactionDumpType.SYSTEM_DUMPS_TAKEN) {
            return (V)this.getSystemDumpsTaken();
        }
        if (attribute == TransactionDumpType.SYSTEM_DUMPS_SUPPRESSED) {
            return (V)this.getSystemDumpsSuppressed();
        }
        if (attribute == TransactionDumpType.TRANSACTION_DUMP_SCOPE) {
            return (V)this.getTransactionDumpScope();
        }
        if (attribute == TransactionDumpType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == TransactionDumpType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == TransactionDumpType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == TransactionDumpType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == TransactionDumpType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == TransactionDumpType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == TransactionDumpType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == TransactionDumpType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == TransactionDumpType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        return super.getAttributeValue(attribute);
    }
}

