/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.UnitOfWorkEnqueueReference;
import com.ibm.cics.core.model.UnitOfWorkEnqueueType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IUnitOfWorkEnqueue;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class UnitOfWorkEnqueue
extends CICSResource
implements IUnitOfWorkEnqueue {
    private String _uowid;
    private String _transid;
    private String _taskid;
    private IUnitOfWorkEnqueue.EnqueueTypeValue _state;
    private IUnitOfWorkEnqueue.ResourceTypeValue _type;
    private IUnitOfWorkEnqueue.RelationValue _relation;
    private Long _enqfails;
    private Long _quallen;
    private Long _reslen;
    private String _resource;
    private String _qualifier;
    private String _netuowid;
    private String _enqscope;
    private String _enqaddress;

    public UnitOfWorkEnqueue(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._uowid = (String)avm.getAttributeValue(UnitOfWorkEnqueueType.UNIT_OF_WORK_ID);
        this._transid = (String)avm.getAttributeValue(UnitOfWorkEnqueueType.TRANSACTION_ID, true);
        this._taskid = (String)avm.getAttributeValue(UnitOfWorkEnqueueType.TASK_ID, true);
        this._state = (IUnitOfWorkEnqueue.EnqueueTypeValue)avm.getAttributeValue(UnitOfWorkEnqueueType.ENQUEUE_TYPE, true);
        this._type = (IUnitOfWorkEnqueue.ResourceTypeValue)avm.getAttributeValue(UnitOfWorkEnqueueType.RESOURCE_TYPE, true);
        this._relation = (IUnitOfWorkEnqueue.RelationValue)avm.getAttributeValue(UnitOfWorkEnqueueType.RELATION, true);
        this._enqfails = (Long)avm.getAttributeValue(UnitOfWorkEnqueueType.ENQFAILS, true);
        this._quallen = (Long)avm.getAttributeValue(UnitOfWorkEnqueueType.QUALLEN, true);
        this._reslen = (Long)avm.getAttributeValue(UnitOfWorkEnqueueType.RESLEN, true);
        this._resource = (String)avm.getAttributeValue(UnitOfWorkEnqueueType.RESOURCE);
        this._qualifier = (String)avm.getAttributeValue(UnitOfWorkEnqueueType.QUALIFIER, true);
        this._netuowid = (String)avm.getAttributeValue(UnitOfWorkEnqueueType.NETUOWID, true);
        this._enqscope = (String)avm.getAttributeValue(UnitOfWorkEnqueueType.ENQSCOPE, true);
        this._enqaddress = (String)avm.getAttributeValue(UnitOfWorkEnqueueType.ENQADDRESS, true);
    }

    public UnitOfWorkEnqueue(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("UOWID");
        this._uowid = (String)((CICSAttribute)UnitOfWorkEnqueueType.UNIT_OF_WORK_ID).get(stringValue, normalizers);
        stringValue = record.get("TRANSID");
        this._transid = (String)((CICSAttribute)UnitOfWorkEnqueueType.TRANSACTION_ID).get(stringValue, normalizers);
        stringValue = record.get("TASKID");
        this._taskid = (String)((CICSAttribute)UnitOfWorkEnqueueType.TASK_ID).get(stringValue, normalizers);
        stringValue = record.get("STATE");
        this._state = (IUnitOfWorkEnqueue.EnqueueTypeValue)((CICSAttribute)UnitOfWorkEnqueueType.ENQUEUE_TYPE).get(stringValue, normalizers);
        stringValue = record.get("TYPE");
        this._type = (IUnitOfWorkEnqueue.ResourceTypeValue)((CICSAttribute)UnitOfWorkEnqueueType.RESOURCE_TYPE).get(stringValue, normalizers);
        stringValue = record.get("RELATION");
        this._relation = (IUnitOfWorkEnqueue.RelationValue)((CICSAttribute)UnitOfWorkEnqueueType.RELATION).get(stringValue, normalizers);
        stringValue = record.get("ENQFAILS");
        this._enqfails = (Long)((CICSAttribute)UnitOfWorkEnqueueType.ENQFAILS).get(stringValue, normalizers);
        stringValue = record.get("QUALLEN");
        this._quallen = (Long)((CICSAttribute)UnitOfWorkEnqueueType.QUALLEN).get(stringValue, normalizers);
        stringValue = record.get("RESLEN");
        this._reslen = (Long)((CICSAttribute)UnitOfWorkEnqueueType.RESLEN).get(stringValue, normalizers);
        stringValue = record.get("RESOURCE");
        this._resource = (String)((CICSAttribute)UnitOfWorkEnqueueType.RESOURCE).get(stringValue, normalizers);
        stringValue = record.get("QUALIFIER");
        this._qualifier = (String)((CICSAttribute)UnitOfWorkEnqueueType.QUALIFIER).get(stringValue, normalizers);
        stringValue = record.get("NETUOWID");
        this._netuowid = (String)((CICSAttribute)UnitOfWorkEnqueueType.NETUOWID).get(stringValue, normalizers);
        stringValue = record.get("ENQSCOPE");
        this._enqscope = (String)((CICSAttribute)UnitOfWorkEnqueueType.ENQSCOPE).get(stringValue, normalizers);
        stringValue = record.get("ENQADDRESS");
        this._enqaddress = (String)((CICSAttribute)UnitOfWorkEnqueueType.ENQADDRESS).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return UnitOfWorkEnqueueType.TRANSACTION_ID.internalToExternal((Object)this.getTransactionID());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getUnitOfWorkID() {
        return this._uowid;
    }

    public String getTransactionID() {
        return this._transid;
    }

    public String getTaskID() {
        return this._taskid;
    }

    public IUnitOfWorkEnqueue.EnqueueTypeValue getEnqueueType() {
        return this._state;
    }

    public IUnitOfWorkEnqueue.ResourceTypeValue getResourceType() {
        return this._type;
    }

    public IUnitOfWorkEnqueue.RelationValue getRelation() {
        return this._relation;
    }

    public Long getEnqfails() {
        return this._enqfails;
    }

    public Long getQuallen() {
        return this._quallen;
    }

    public Long getReslen() {
        return this._reslen;
    }

    public String getResource() {
        return this._resource;
    }

    public String getQualifier() {
        return this._qualifier;
    }

    public String getNetuowid() {
        return this._netuowid;
    }

    public String getEnqscope() {
        return this._enqscope;
    }

    public String getEnqaddress() {
        return this._enqaddress;
    }

    public UnitOfWorkEnqueueType getObjectType() {
        return UnitOfWorkEnqueueType.getInstance();
    }

    @Override
    public UnitOfWorkEnqueueReference getCICSObjectReference() {
        return new UnitOfWorkEnqueueReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == UnitOfWorkEnqueueType.UNIT_OF_WORK_ID) {
            return (V)this.getUnitOfWorkID();
        }
        if (attribute == UnitOfWorkEnqueueType.TRANSACTION_ID) {
            return (V)this.getTransactionID();
        }
        if (attribute == UnitOfWorkEnqueueType.TASK_ID) {
            return (V)this.getTaskID();
        }
        if (attribute == UnitOfWorkEnqueueType.ENQUEUE_TYPE) {
            return (V)this.getEnqueueType();
        }
        if (attribute == UnitOfWorkEnqueueType.RESOURCE_TYPE) {
            return (V)this.getResourceType();
        }
        if (attribute == UnitOfWorkEnqueueType.RELATION) {
            return (V)this.getRelation();
        }
        if (attribute == UnitOfWorkEnqueueType.ENQFAILS) {
            return (V)this.getEnqfails();
        }
        if (attribute == UnitOfWorkEnqueueType.QUALLEN) {
            return (V)this.getQuallen();
        }
        if (attribute == UnitOfWorkEnqueueType.RESLEN) {
            return (V)this.getReslen();
        }
        if (attribute == UnitOfWorkEnqueueType.RESOURCE) {
            return (V)this.getResource();
        }
        if (attribute == UnitOfWorkEnqueueType.QUALIFIER) {
            return (V)this.getQualifier();
        }
        if (attribute == UnitOfWorkEnqueueType.NETUOWID) {
            return (V)this.getNetuowid();
        }
        if (attribute == UnitOfWorkEnqueueType.ENQSCOPE) {
            return (V)this.getEnqscope();
        }
        if (attribute == UnitOfWorkEnqueueType.ENQADDRESS) {
            return (V)this.getEnqaddress();
        }
        return super.getAttributeValue(attribute);
    }
}

