/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.UnitOfWorkLinkReference;
import com.ibm.cics.core.model.UnitOfWorkLinkType;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IUnitOfWorkLink;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class UnitOfWorkLink
extends CICSResource
implements IUnitOfWorkLink {
    private String _link;
    private String _uowid;
    private String _linkname;
    private IUnitOfWorkLink.TypeValue _type;
    private String _sysid;
    private String _rmiqfy;
    private IUnitOfWorkLink.RoleValue _role;
    private IUnitOfWorkLink.ResynchronizationStatusValue _resyncstatus;
    private IUnitOfWorkLink.ProtocolValue _protocol;
    private String _netuowid;
    private String _rrmsurid;
    private String _host;
    private String _xid;
    private Long _port;
    private String _branchqual;

    public UnitOfWorkLink(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._link = (String)avm.getAttributeValue(UnitOfWorkLinkType.LINK_TOKEN);
        this._uowid = (String)avm.getAttributeValue(UnitOfWorkLinkType.UNIT_OF_WORK_ID, true);
        this._linkname = (String)avm.getAttributeValue(UnitOfWorkLinkType.LINK_NAME, true);
        this._type = (IUnitOfWorkLink.TypeValue)avm.getAttributeValue(UnitOfWorkLinkType.TYPE, true);
        this._sysid = (String)avm.getAttributeValue(UnitOfWorkLinkType.REMOTE_SYSTEM_NAME, true);
        this._rmiqfy = (String)avm.getAttributeValue(UnitOfWorkLinkType.TASK_RELATED_USER_EXIT_QUALIFIER, true);
        this._role = (IUnitOfWorkLink.RoleValue)avm.getAttributeValue(UnitOfWorkLinkType.ROLE, true);
        this._resyncstatus = (IUnitOfWorkLink.ResynchronizationStatusValue)avm.getAttributeValue(UnitOfWorkLinkType.RESYNCHRONIZATION_STATUS, true);
        this._protocol = (IUnitOfWorkLink.ProtocolValue)avm.getAttributeValue(UnitOfWorkLinkType.PROTOCOL, true);
        this._netuowid = (String)avm.getAttributeValue(UnitOfWorkLinkType.NETWORK_WIDE_UNIT_OF_WORK_NAME, true);
        this._rrmsurid = (String)avm.getAttributeValue(UnitOfWorkLinkType.RRMS_UNIT_OF_RECOVERABLE_WORK_ID, true);
        this._host = (String)avm.getAttributeValue(UnitOfWorkLinkType.HOST_ADDRESS, true);
        this._xid = (String)avm.getAttributeValue(UnitOfWorkLinkType.XID_GLOBAL_TRANSACTION_IDENTIFIER, true);
        this._port = (Long)avm.getAttributeValue(UnitOfWorkLinkType.PORT, true);
        this._branchqual = (String)avm.getAttributeValue(UnitOfWorkLinkType.XID_BRANCH_QUALIFIER, true);
    }

    public UnitOfWorkLink(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("LINK");
        this._link = (String)((CICSAttribute)UnitOfWorkLinkType.LINK_TOKEN).get(stringValue, normalizers);
        stringValue = record.get("UOWID");
        this._uowid = (String)((CICSAttribute)UnitOfWorkLinkType.UNIT_OF_WORK_ID).get(stringValue, normalizers);
        stringValue = record.get("LINKNAME");
        this._linkname = (String)((CICSAttribute)UnitOfWorkLinkType.LINK_NAME).get(stringValue, normalizers);
        stringValue = record.get("TYPE");
        this._type = (IUnitOfWorkLink.TypeValue)((CICSAttribute)UnitOfWorkLinkType.TYPE).get(stringValue, normalizers);
        stringValue = record.get("SYSID");
        this._sysid = (String)((CICSAttribute)UnitOfWorkLinkType.REMOTE_SYSTEM_NAME).get(stringValue, normalizers);
        stringValue = record.get("RMIQFY");
        this._rmiqfy = (String)((CICSAttribute)UnitOfWorkLinkType.TASK_RELATED_USER_EXIT_QUALIFIER).get(stringValue, normalizers);
        stringValue = record.get("ROLE");
        this._role = (IUnitOfWorkLink.RoleValue)((CICSAttribute)UnitOfWorkLinkType.ROLE).get(stringValue, normalizers);
        stringValue = record.get("RESYNCSTATUS");
        this._resyncstatus = (IUnitOfWorkLink.ResynchronizationStatusValue)((CICSAttribute)UnitOfWorkLinkType.RESYNCHRONIZATION_STATUS).get(stringValue, normalizers);
        stringValue = record.get("PROTOCOL");
        this._protocol = (IUnitOfWorkLink.ProtocolValue)((CICSAttribute)UnitOfWorkLinkType.PROTOCOL).get(stringValue, normalizers);
        stringValue = record.get("NETUOWID");
        this._netuowid = (String)((CICSAttribute)UnitOfWorkLinkType.NETWORK_WIDE_UNIT_OF_WORK_NAME).get(stringValue, normalizers);
        stringValue = record.get("RRMSURID");
        this._rrmsurid = (String)((CICSAttribute)UnitOfWorkLinkType.RRMS_UNIT_OF_RECOVERABLE_WORK_ID).get(stringValue, normalizers);
        stringValue = record.get("HOST");
        this._host = (String)((CICSAttribute)UnitOfWorkLinkType.HOST_ADDRESS).get(stringValue, normalizers);
        stringValue = record.get("XID");
        this._xid = (String)((CICSAttribute)UnitOfWorkLinkType.XID_GLOBAL_TRANSACTION_IDENTIFIER).get(stringValue, normalizers);
        stringValue = record.get("PORT");
        this._port = (Long)((CICSAttribute)UnitOfWorkLinkType.PORT).get(stringValue, normalizers);
        stringValue = record.get("BRANCHQUAL");
        this._branchqual = (String)((CICSAttribute)UnitOfWorkLinkType.XID_BRANCH_QUALIFIER).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return UnitOfWorkLinkType.LINK_TOKEN.internalToExternal((Object)this.getLinkToken());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getLinkToken() {
        return this._link;
    }

    public String getUnitOfWorkID() {
        return this._uowid;
    }

    public String getLinkName() {
        return this._linkname;
    }

    public IUnitOfWorkLink.TypeValue getType() {
        return this._type;
    }

    public String getRemoteSystemName() {
        return this._sysid;
    }

    public String getTaskRelatedUserExitQualifier() {
        return this._rmiqfy;
    }

    public IUnitOfWorkLink.RoleValue getRole() {
        return this._role;
    }

    public IUnitOfWorkLink.ResynchronizationStatusValue getResynchronizationStatus() {
        return this._resyncstatus;
    }

    public IUnitOfWorkLink.ProtocolValue getProtocol() {
        return this._protocol;
    }

    public String getNetworkWideUnitOfWorkName() {
        return this._netuowid;
    }

    public String getRrmsUnitOfRecoverableWorkID() {
        return this._rrmsurid;
    }

    public String getHostAddress() {
        return this._host;
    }

    public String getXIDGlobalTransactionIdentifier() {
        return this._xid;
    }

    public Long getPort() {
        return this._port;
    }

    public String getXIDBranchQualifier() {
        return this._branchqual;
    }

    public UnitOfWorkLinkType getObjectType() {
        return UnitOfWorkLinkType.getInstance();
    }

    @Override
    public UnitOfWorkLinkReference getCICSObjectReference() {
        return new UnitOfWorkLinkReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == UnitOfWorkLinkType.LINK_TOKEN) {
            return (V)this.getLinkToken();
        }
        if (attribute == UnitOfWorkLinkType.UNIT_OF_WORK_ID) {
            return (V)this.getUnitOfWorkID();
        }
        if (attribute == UnitOfWorkLinkType.LINK_NAME) {
            return (V)this.getLinkName();
        }
        if (attribute == UnitOfWorkLinkType.TYPE) {
            return (V)this.getType();
        }
        if (attribute == UnitOfWorkLinkType.REMOTE_SYSTEM_NAME) {
            return (V)this.getRemoteSystemName();
        }
        if (attribute == UnitOfWorkLinkType.TASK_RELATED_USER_EXIT_QUALIFIER) {
            return (V)this.getTaskRelatedUserExitQualifier();
        }
        if (attribute == UnitOfWorkLinkType.ROLE) {
            return (V)this.getRole();
        }
        if (attribute == UnitOfWorkLinkType.RESYNCHRONIZATION_STATUS) {
            return (V)this.getResynchronizationStatus();
        }
        if (attribute == UnitOfWorkLinkType.PROTOCOL) {
            return (V)this.getProtocol();
        }
        if (attribute == UnitOfWorkLinkType.NETWORK_WIDE_UNIT_OF_WORK_NAME) {
            return (V)this.getNetworkWideUnitOfWorkName();
        }
        if (attribute == UnitOfWorkLinkType.RRMS_UNIT_OF_RECOVERABLE_WORK_ID) {
            return (V)this.getRrmsUnitOfRecoverableWorkID();
        }
        if (attribute == UnitOfWorkLinkType.HOST_ADDRESS) {
            return (V)this.getHostAddress();
        }
        if (attribute == UnitOfWorkLinkType.XID_GLOBAL_TRANSACTION_IDENTIFIER) {
            return (V)this.getXIDGlobalTransactionIdentifier();
        }
        if (attribute == UnitOfWorkLinkType.PORT) {
            return (V)this.getPort();
        }
        if (attribute == UnitOfWorkLinkType.XID_BRANCH_QUALIFIER) {
            return (V)this.getXIDBranchQualifier();
        }
        return super.getAttributeValue(attribute);
    }
}

