/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadSpecificationReference;
import com.ibm.cics.core.model.WorkloadSpecificationType;
import com.ibm.cics.core.model.internal.CPSMDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSRegionDefinitionReference;
import com.ibm.cics.model.ICICSRegionGroupDefinitionReference;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IWLMSpecificationsToSystem;
import com.ibm.cics.model.IWLMSpecificationsToSystemGroup;
import com.ibm.cics.model.IWorkloadGroupInWorkloadSpecification;
import com.ibm.cics.model.IWorkloadSpecification;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class WorkloadSpecification
extends CPSMDefinition
implements IWorkloadSpecification {
    private IWorkloadSpecification.ChangeAgentValue _changeagent;
    private String _name;
    private String _aorscope;
    private IWorkloadSpecification.DefaultAffinityValue _affinity;
    private IWorkloadSpecification.AffinityLifetimeValue _afflife;
    private IWorkloadSpecification.MatchValue _match;
    private IWorkloadSpecification.AlgorithmTypeValue _algtype;
    private String _desc;
    private String _eventname;
    private Long _abendcrit;
    private Long _abendthresh;
    private IWorkloadSpecification.AutomaticAffinityCreationValue _affauto;

    public WorkloadSpecification(ICPSMDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._changeagent = (IWorkloadSpecification.ChangeAgentValue)avm.getAttributeValue(WorkloadSpecificationType.CHANGE_AGENT, true);
        this._name = (String)avm.getAttributeValue(WorkloadSpecificationType.NAME);
        this._aorscope = (String)avm.getAttributeValue(WorkloadSpecificationType.TARGET_SCOPE, true);
        this._affinity = (IWorkloadSpecification.DefaultAffinityValue)avm.getAttributeValue(WorkloadSpecificationType.DEFAULT_AFFINITY, true);
        this._afflife = (IWorkloadSpecification.AffinityLifetimeValue)avm.getAttributeValue(WorkloadSpecificationType.AFFINITY_LIFETIME, true);
        this._match = (IWorkloadSpecification.MatchValue)avm.getAttributeValue(WorkloadSpecificationType.MATCH, true);
        this._algtype = (IWorkloadSpecification.AlgorithmTypeValue)avm.getAttributeValue(WorkloadSpecificationType.ALGORITHM_TYPE, true);
        this._desc = (String)avm.getAttributeValue(WorkloadSpecificationType.DESCRIPTION, true);
        this._eventname = (String)avm.getAttributeValue(WorkloadSpecificationType.EVENT_NAME, true);
        this._abendcrit = (Long)avm.getAttributeValue(WorkloadSpecificationType.ABENDCRIT, true);
        this._abendthresh = (Long)avm.getAttributeValue(WorkloadSpecificationType.ABENDTHRESH, true);
        this._affauto = (IWorkloadSpecification.AutomaticAffinityCreationValue)avm.getAttributeValue(WorkloadSpecificationType.AUTOMATIC_AFFINITY_CREATION, true);
    }

    public WorkloadSpecification(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("CHANGEAGENT");
        this._changeagent = (IWorkloadSpecification.ChangeAgentValue)((CICSAttribute)WorkloadSpecificationType.CHANGE_AGENT).get(stringValue, normalizers);
        stringValue = record.get("NAME");
        this._name = (String)((CICSAttribute)WorkloadSpecificationType.NAME).get(stringValue, normalizers);
        stringValue = record.get("AORSCOPE");
        this._aorscope = (String)((CICSAttribute)WorkloadSpecificationType.TARGET_SCOPE).get(stringValue, normalizers);
        stringValue = record.get("AFFINITY");
        this._affinity = (IWorkloadSpecification.DefaultAffinityValue)((CICSAttribute)WorkloadSpecificationType.DEFAULT_AFFINITY).get(stringValue, normalizers);
        stringValue = record.get("AFFLIFE");
        this._afflife = (IWorkloadSpecification.AffinityLifetimeValue)((CICSAttribute)WorkloadSpecificationType.AFFINITY_LIFETIME).get(stringValue, normalizers);
        stringValue = record.get("MATCH");
        this._match = (IWorkloadSpecification.MatchValue)((CICSAttribute)WorkloadSpecificationType.MATCH).get(stringValue, normalizers);
        stringValue = record.get("ALGTYPE");
        this._algtype = (IWorkloadSpecification.AlgorithmTypeValue)((CICSAttribute)WorkloadSpecificationType.ALGORITHM_TYPE).get(stringValue, normalizers);
        stringValue = record.get("DESC");
        this._desc = (String)((CICSAttribute)WorkloadSpecificationType.DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get("EVENTNAME");
        this._eventname = (String)((CICSAttribute)WorkloadSpecificationType.EVENT_NAME).get(stringValue, normalizers);
        stringValue = record.get("ABENDCRIT");
        this._abendcrit = (Long)((CICSAttribute)WorkloadSpecificationType.ABENDCRIT).get(stringValue, normalizers);
        stringValue = record.get("ABENDTHRESH");
        this._abendthresh = (Long)((CICSAttribute)WorkloadSpecificationType.ABENDTHRESH).get(stringValue, normalizers);
        stringValue = record.get("AFFAUTO");
        this._affauto = (IWorkloadSpecification.AutomaticAffinityCreationValue)((CICSAttribute)WorkloadSpecificationType.AUTOMATIC_AFFINITY_CREATION).get(stringValue, normalizers);
    }

    public IWorkloadSpecification.ChangeAgentValue getChangeAgent() {
        return this._changeagent;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getTargetScope() {
        return this._aorscope;
    }

    public IWorkloadSpecification.DefaultAffinityValue getDefaultAffinity() {
        return this._affinity;
    }

    public IWorkloadSpecification.AffinityLifetimeValue getAffinityLifetime() {
        return this._afflife;
    }

    public IWorkloadSpecification.MatchValue getMatch() {
        return this._match;
    }

    public IWorkloadSpecification.AlgorithmTypeValue getAlgorithmType() {
        return this._algtype;
    }

    public String getDescription() {
        return this._desc;
    }

    public String getEventName() {
        return this._eventname;
    }

    public Long getAbendcrit() {
        return this._abendcrit;
    }

    public Long getAbendthresh() {
        return this._abendthresh;
    }

    public IWorkloadSpecification.AutomaticAffinityCreationValue getAutomaticAffinityCreation() {
        return this._affauto;
    }

    public WorkloadSpecificationType getObjectType() {
        return WorkloadSpecificationType.getInstance();
    }

    @Override
    public WorkloadSpecificationReference getCICSObjectReference() {
        return new WorkloadSpecificationReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadSpecificationType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == WorkloadSpecificationType.NAME) {
            return (V)this.getName();
        }
        if (attribute == WorkloadSpecificationType.TARGET_SCOPE) {
            return (V)this.getTargetScope();
        }
        if (attribute == WorkloadSpecificationType.DEFAULT_AFFINITY) {
            return (V)this.getDefaultAffinity();
        }
        if (attribute == WorkloadSpecificationType.AFFINITY_LIFETIME) {
            return (V)this.getAffinityLifetime();
        }
        if (attribute == WorkloadSpecificationType.MATCH) {
            return (V)this.getMatch();
        }
        if (attribute == WorkloadSpecificationType.ALGORITHM_TYPE) {
            return (V)this.getAlgorithmType();
        }
        if (attribute == WorkloadSpecificationType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        if (attribute == WorkloadSpecificationType.EVENT_NAME) {
            return (V)this.getEventName();
        }
        if (attribute == WorkloadSpecificationType.ABENDCRIT) {
            return (V)this.getAbendcrit();
        }
        if (attribute == WorkloadSpecificationType.ABENDTHRESH) {
            return (V)this.getAbendthresh();
        }
        if (attribute == WorkloadSpecificationType.AUTOMATIC_AFFINITY_CREATION) {
            return (V)this.getAutomaticAffinityCreation();
        }
        return super.getAttributeValue(attribute);
    }

    public ICICSRegionGroupDefinitionReference getRegionGroupDefinitionReference() {
        return (ICICSRegionGroupDefinitionReference)WorkloadSpecificationType.REGION_GROUP_DEFINITION_REFERENCE.getTo((ICICSObject)this);
    }

    public ICICSRegionDefinitionReference getRegionDefinitionReference() {
        return (ICICSRegionDefinitionReference)WorkloadSpecificationType.REGION_DEFINITION_REFERENCE.getTo((ICICSObject)this);
    }

    public ICICSObjectSet<IWLMSpecificationsToSystemGroup> getFromWLMSpecificationsToSystemGroups() {
        return WorkloadSpecificationType.FROM_WLM_SPECIFICATIONS_TO_SYSTEM_GROUPS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IWLMSpecificationsToSystem> getFromWLMSpecificationsToSystems() {
        return WorkloadSpecificationType.FROM_WLM_SPECIFICATIONS_TO_SYSTEMS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }

    public ICICSObjectSet<IWorkloadGroupInWorkloadSpecification> getGroupsMembers() {
        return WorkloadSpecificationType.GROUPS_MEMBERS.getFrom((ICICSObjectReference)this.getCICSObjectReference());
    }
}

