/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.core.model.ICICSplexRepository;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.mutable.IMutableCoreObject;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.properties.CICSObjectPropertySource;
import com.ibm.cics.core.ui.properties.MutableCICSObjectPropertySource;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSplex;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class PropertySourceAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PropertySourceAdapterFactory.class.getPackage().getName());
    private IPropertySourceProvider cicsObjectAdapter = new IPropertySourceProvider(){

        public String toString() {
            return "IPropertySourceProvider[cicsObjectAdapter]";
        }

        public IPropertySource getPropertySource(Object object) {
            ICICSObject adapter;
            if (object instanceof ICICSObject) {
                return new CICSObjectPropertySource((ICICSObject)object);
            }
            if (object instanceof IAdaptable && (adapter = (ICICSObject)((IAdaptable)object).getAdapter(ICICSObject.class)) != null) {
                return new CICSObjectPropertySource(adapter);
            }
            return new CICSObjectPropertySource((ICICSObject)Platform.getAdapterManager().getAdapter(object, ICICSObject.class));
        }
    };
    private IPropertySourceProvider mutableCICSObjectAdapter = new IPropertySourceProvider(){

        public String toString() {
            return "IPropertySourceProvider[mutableCICSObjectAdapter]";
        }

        public IPropertySource getPropertySource(Object object) {
            return new MutableCICSObjectPropertySource((ICICSObject)object);
        }
    };
    private IPropertySourceProvider cicsPlexRepositoryAdapter = new IPropertySourceProvider(){

        public String toString() {
            return "IPropertySourceProvider[cicsPlexRepositoryAdapter]";
        }

        public IPropertySource getPropertySource(Object object) {
            ICICSplexRepository repository = (ICICSplexRepository)object;
            ICICSplex cicsPlex = repository.getCICSplex();
            return new CICSObjectPropertySource((ICICSObject)cicsPlex);
        }
    };

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (Debug.DEBUG_ADAPTERS) {
            Debug.enter((Logger)logger, (String)PropertySourceAdapterFactory.class.getName(), (String)"getAdapter", (Object)("object=" + adaptableObject + ", type=" + adapterType));
        }
        IPropertySourceProvider adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            if (adaptableObject instanceof ICICSplexRepository) {
                adapter = this.cicsPlexRepositoryAdapter;
            } else if (adaptableObject instanceof IMutableCoreObject) {
                adapter = this.mutableCICSObjectAdapter;
            } else if (adaptableObject instanceof ICoreObject) {
                adapter = this.cicsObjectAdapter;
            }
        }
        if (Debug.DEBUG_ADAPTERS) {
            Debug.exit((Logger)logger, (String)PropertySourceAdapterFactory.class.getName(), (String)"getAdapter", (Object)("adapter=" + adapter));
        }
        return adapter;
    }

    public Class[] getAdapterList() {
        return new Class[]{IPropertySourceProvider.class};
    }
}

