/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IDescribable;
import com.ibm.cics.core.model.extra.IWLMActiveRuleEditorSource;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.actions.OpenRelevantActiveRuleEditorAction;
import com.ibm.cics.core.ui.viewers.ExplorerTreeContentProvider;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import com.ibm.cics.explorer.tables.ui.CommonMessages;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.IWorkload;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public abstract class AbstractResourcesTreeView
extends ViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String PENDING = Messages.getString("pending", new Object[0]);
    private static final Debug debug = new Debug(AbstractResourcesTreeView.class);
    protected TreeViewer viewer;
    private IPartListener2 partListener;
    private ISelectionListener selectionListener;
    private IAction refreshAction;
    private IHandler commandHandler;
    private IPartListener connectionPartListener;
    private ConnectionServiceListener connectionServiceListener;
    private ICPSM cpsm;
    private ExplorerLabelProvider labelProvider;
    protected InternalExplorerTreeContentProvider contentProvider;

    public void createPartControl(Composite parent) {
        debug.enter("createPartControl", (Object)parent);
        this.setContentDescription(CommonMessages.ResourcesView_statusDisconnected);
        Composite gridComposite = new Composite(parent, 0);
        gridComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        gridComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        this.createCompositeBar(gridComposite);
        this.viewer = this.createTreeViewer(gridComposite);
        this.viewer.setUseHashlookup(true);
        this.contentProvider = this.createContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ExplorerLabelProvider();
        this.viewer.setLabelProvider(this.getLabelProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    Object object;
                    Object firstElement = selection.getFirstElement();
                    if (firstElement instanceof IWorkbenchAdapter || firstElement instanceof IWorkload) {
                        if (firstElement instanceof IWLMActiveRuleEditorSource || firstElement instanceof IWorkload) {
                            OpenRelevantActiveRuleEditorAction action = new OpenRelevantActiveRuleEditorAction();
                            action.runTriggeredByDoubleClick(event);
                        }
                    } else if (firstElement instanceof ICICSObject) {
                        this.performDefaultViewAction(event, (ICICSObject)firstElement);
                    } else if (Platform.getAdapterManager().hasAdapter(firstElement, ICICSObject.class.getName()) && (object = Platform.getAdapterManager().getAdapter(firstElement, ICICSObject.class)) instanceof ICICSObject) {
                        this.performDefaultViewAction(event, (ICICSObject)object);
                    }
                }
            }

            private void performDefaultViewAction(DoubleClickEvent event, final ICICSObject aCICSObject) {
                BusyIndicator.showWhile((Display)event.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UIPlugin.performDefaultViewAction(aCICSObject);
                    }
                });
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.makeActions(this.getViewSite().getWorkbenchWindow());
        this.fillActionBar(this.getViewSite().getActionBars());
        this.addListeners();
        this.createPopupMenu();
        this.getViewSite().setSelectionProvider(this.getSelectionProvider());
        this.viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractResourcesTreeView.this.viewer.getTree().getAccessible().setFocus(-1);
                AbstractResourcesTreeView.this.viewer.getTree().getAccessible().selectionChanged();
            }
        });
        this.viewer.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Object selected = ((StructuredSelection)AbstractResourcesTreeView.this.viewer.getSelection()).getFirstElement();
                AbstractResourcesTreeView.this.accessibilitySelectionHandling(e, selected);
            }
        });
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.file.refresh", this.commandHandler);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), this.getHelpContextID());
        this.partControlsCreated();
        debug.exit("createPartControl");
    }

    protected ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    protected InternalExplorerTreeContentProvider createContentProvider() {
        return new InternalExplorerTreeContentProvider(this.viewer, this.getSite());
    }

    protected void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractResourcesTreeView.this.fillContextMenu(manager);
            }
        });
        Menu popupMenu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected abstract void fillContextMenu(IMenuManager var1);

    protected IBaseLabelProvider getLabelProvider() {
        return new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)this.labelProvider), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null){

            public void update(ViewerCell cell) {
                if (" ".equals(cell.getText()) || PENDING.equals(cell.getText())) {
                    cell.setText("");
                }
                super.update(cell);
            }
        };
    }

    public TreeViewer createTreeViewer(Composite parent) {
        TreeViewer tv = new TreeViewer(parent, 0x10000300);
        tv.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        return tv;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        debug.enter("dispose");
        this.removeListeners();
        super.dispose();
        debug.exit("dispose");
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.refreshAction = new Action(Messages.getString("ResourcesTreeView.refreshAction.name", new Object[0])){

            public void run() {
                AbstractResourcesTreeView.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.getString("ResourcesTreeView.refreshAction.tooltip", new Object[0]));
        this.refreshAction.setImageDescriptor(UIPlugin.IMGD_REFRESH);
        this.commandHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                AbstractResourcesTreeView.this.refresh();
                return null;
            }
        };
    }

    protected void fillActionBar(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IContributionItem)new Separator("refresh"));
        toolBar.appendToGroup("refresh", this.refreshAction);
        toolBar.add((IContributionItem)new Separator("additions"));
    }

    private void addListeners() {
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractResourcesTreeView.this) {
                    debug.event("partDeactivated", (Object)this, (Object)partRef.getPartName());
                    AbstractResourcesTreeView.this.clearStatusMessage();
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        debug.event("addListeners", (Object)this.partListener);
        this.getSite().getPage().addPartListener(this.partListener);
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part.equals((Object)AbstractResourcesTreeView.this) && selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object firstElement = structuredSelection.getFirstElement();
                    debug.event("selectionChanged", (Object)selection);
                    if (firstElement instanceof IDescribable) {
                        AbstractResourcesTreeView.this.showStatusMessage(((IDescribable)firstElement).getDescription());
                    } else {
                        AbstractResourcesTreeView.this.showStatusMessage("");
                    }
                }
            }
        };
        debug.event("addListeners", (Object)this.selectionListener);
        this.getSite().getPage().addSelectionListener(this.selectionListener);
        this.addConnectionListener();
    }

    private void addConnectionListener() {
        this.connectionPartListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part == AbstractResourcesTreeView.this) {
                    AbstractResourcesTreeView.this.connectionServiceListener = new ConnectionServiceListener(){

                        public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
                            if ("com.ibm.cics.sm.connection".equals(event.getConnectionCategoryId())) {
                                (this).AbstractResourcesTreeView.this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                                            AbstractResourcesTreeView.this.connected(event.getConnectable());
                                        } else if (event instanceof ConnectionServiceListener.ConnectingEvent) {
                                            AbstractResourcesTreeView.this.setContentDescription(CommonMessages.ResourcesView_statusConnecting);
                                        } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                                            AbstractResourcesTreeView.this.disconnected(event.getConnectable());
                                        } else if (event instanceof ConnectionServiceListener.ExceptionEvent && ((ConnectionServiceListener.ExceptionEvent)event).getException() != null) {
                                            AbstractResourcesTreeView.this.exception(event.getConnectable(), ((ConnectionServiceListener.ExceptionEvent)event).getException());
                                        }
                                    }
                                });
                            }
                        }
                    };
                    IConnectable connectable = ConnectionsPlugin.getDefault().getConnectionService().getConnectable("com.ibm.cics.sm.connection");
                    if (connectable != null && connectable.isConnected()) {
                        AbstractResourcesTreeView.this.connected(connectable);
                    }
                    ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener(AbstractResourcesTreeView.this.connectionServiceListener);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == AbstractResourcesTreeView.this) {
                    AbstractResourcesTreeView.this.connectionServiceListener.makeStale();
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        };
        this.getSite().getPage().addPartListener(this.connectionPartListener);
    }

    protected void connected(IConnectable cpsm) {
        this.cpsm = (ICPSM)cpsm;
        this.viewer.setInput((Object)cpsm);
        String description = Messages.getString("ResourcesView.status.connected", this.cpsm.getName());
        this.setContentDescription(description);
    }

    protected void exception(IConnectable cpsm, Exception ex) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractResourcesTreeView.this.setContentDescription(CommonMessages.ResourcesView_statusDisconnected);
            }
        });
    }

    protected void disconnected(IConnectable cpms) {
        this.viewer.setInput(null);
        this.cpsm = null;
        this.setContentDescription(CommonMessages.ResourcesView_statusDisconnected);
    }

    private void removeListeners() {
        debug.enter("removeListeners");
        this.getSite().getPage().removePartListener(this.partListener);
        this.getSite().getPage().removeSelectionListener(this.selectionListener);
        this.getSite().getPage().removePartListener(this.connectionPartListener);
    }

    protected void clearStatusMessage() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getStatusLineManager().setMessage(null);
        actionBars.getStatusLineManager().setErrorMessage(null);
        actionBars.updateActionBars();
    }

    protected void showStatusMessage(String message) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getStatusLineManager().setMessage(message);
        actionBars.updateActionBars();
    }

    protected void refresh() {
        debug.enter("refresh");
        this.viewer.setInput((Object)this.cpsm);
        if (this.cpsm != null) {
            this.setContentDescription(Messages.getString("ResourcesView.status.connected", this.cpsm.getName()));
        }
        debug.exit("refresh");
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        return this.contentProvider.superAdapter(element);
    }

    protected void accessibilitySelectionHandling(AccessibleEvent e, Object selected) {
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.sm.connection";
        }
        return super.getPartProperty(key);
    }

    protected abstract String getHelpContextID();

    protected void createCompositeBar(Composite parent) {
    }

    protected void partControlsCreated() {
    }

    protected class ExplorerLabelProvider
    extends CellLabelProvider
    implements ILabelProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        protected ExplorerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return PENDING;
            }
            IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter != null) {
                return adapter.getLabel(element);
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return UIPlugin.getImage(UIPlugin.IMGD_WAITING);
            }
            Image image = null;
            IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter != null) {
                image = UIPlugin.getImage(adapter.getImageDescriptor(element));
            }
            return image;
        }

        private IDeferredWorkbenchAdapter getAdapter(Object adaptable) {
            String adapterTypeName = IDeferredWorkbenchAdapter.class.getName();
            IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)Platform.getAdapterManager().loadAdapter(adaptable, adapterTypeName);
            return adapter;
        }

        public String getToolTipText(Object element) {
            if (element instanceof IDescribable) {
                return ((IDescribable)element).getDescription();
            }
            return super.getToolTipText(element);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 10);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }

        public StyledString getStyledText(Object element) {
            StyledString result = new StyledString(this.getText(element));
            return result;
        }
    }

    protected class InternalExplorerTreeContentProvider
    extends ExplorerTreeContentProvider {
        private InternalExplorerTreeContentProvider(TreeViewer viewer, IWorkbenchPartSite site) {
            super(viewer, site);
        }

        protected IDeferredWorkbenchAdapter getAdapter(Object element) {
            return AbstractResourcesTreeView.this.getAdapter(element);
        }

        private final IDeferredWorkbenchAdapter superAdapter(Object element) {
            return super.getAdapter(element);
        }
    }
}

