/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.ibm.cics.sm.comm.sm.internal.graphql.AbstractValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseException;

public class DoubleValueParser
extends AbstractValueParser<Double> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    protected Double parseValue(JsonElement je) throws NodeParseException {
        JsonPrimitive propP;
        if (je.isJsonPrimitive() && (propP = je.getAsJsonPrimitive()).isNumber()) {
            try {
                return propP.getAsDouble();
            }
            catch (NumberFormatException nfe) {
                throw new NodeParseException("property was not a valid double", nfe);
            }
        }
        throw new NodeParseException("property was not a double");
    }
}

