/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSLongAttributeHint;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttributeValueMap
implements Iterable<AttributeValue<?>> {
    private Map<ICICSAttribute<?>, Object> map = new LinkedHashMap();

    public <T> void addAttributeValue(ICICSAttribute<T> attribute, T value) {
        if (this.map.containsKey(attribute)) {
            throw new IllegalArgumentException("Map already has value " + this.map.get(attribute) + " for attribute " + attribute);
        }
        this.map.put(attribute, value);
    }

    public Set<ICICSAttribute<?>> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public <T> T getAttributeValue(ICICSAttribute<T> attribute) {
        return this.getAttributeValue(attribute, false);
    }

    public <T> T getAttributeValue(ICICSAttribute<T> attribute, boolean allowNull) {
        Object value = this.map.get(attribute);
        if (value == null && !allowNull) {
            throw new IllegalStateException("Attribute " + attribute + " has no value specified");
        }
        return (T)value;
    }

    public static AttributeValueMap fromVarargs(AttributeValue<?> ... attributeValues) {
        return AttributeValueMap.fromList(Arrays.asList(attributeValues));
    }

    public static AttributeValueMap fromList(List<AttributeValue<?>> attributeValues) {
        AttributeValueMap attributeValueMap = new AttributeValueMap();
        for (AttributeValue<?> attributeValue : attributeValues) {
            attributeValueMap.addAttributeValue(attributeValue);
        }
        return attributeValueMap;
    }

    public <T> void addAttributeValue(AttributeValue<T> attributeValue) {
        this.addAttributeValue(attributeValue.getAttribute(), attributeValue.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeValueMap other = (AttributeValueMap)obj;
        return !(this.map == null ? other.map != null : !this.attributeValuesEqual(other));
    }

    private boolean attributeValuesEqual(AttributeValueMap other) {
        if (this.map.size() != other.keySet().size()) {
            return false;
        }
        for (ICICSAttribute<?> attribute : this.map.keySet()) {
            if (this.attributeValuesEqual(attribute, other)) continue;
            return false;
        }
        return true;
    }

    private <T> boolean attributeValuesEqual(ICICSAttribute<T> attribute, AttributeValueMap other) {
        ICICSLongAttributeHint hint;
        T value1 = this.getAttributeValue(attribute, true);
        T value2 = other.getAttributeValue(attribute, true);
        if (value1 == null) {
            return value2 == null;
        }
        if (attribute.getType() == Long.class && (hint = attribute.getHint(ICICSLongAttributeHint.class)).hasSpecialValues() && hint.getSpecialValues().values().contains(value1)) {
            return value2 == value1;
        }
        return value1.equals(value2);
    }

    @Override
    public Iterator<AttributeValue<?>> iterator() {
        final Iterator<ICICSAttribute<?>> delegate = this.map.keySet().iterator();
        return new Iterator<AttributeValue<?>>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public AttributeValue<?> next() {
                return this.av((ICICSAttribute)delegate.next());
            }

            private <T> AttributeValue<T> av(ICICSAttribute<T> attribute) {
                return AttributeValue.av(attribute, AttributeValueMap.this.getAttributeValue(attribute));
            }
        };
    }

    public String toString() {
        return this.map.entrySet().stream().map(entry -> String.valueOf(((ICICSAttribute)entry.getKey()).getCicsName()) + '=' + String.valueOf(entry.getValue()) + '\n').reduce("", String::concat);
    }

    public int size() {
        return this.map.size();
    }
}

