/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.common.util.SimpleValidationHelper;
import com.ibm.cics.core.ui.properties.CICSTypePropertySource;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.explorer.tables.ui.DecoratorHelper;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class UIHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2016 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String EMPTY_STRING = "".intern();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String ERROR_DECORATION = "ERROR_DECORATION";
    public static final String WARNING_DECORATION = "WARNING_DECORATION";
    private static final String IS_DIRTY = "IS_DIRTY";
    private static final String HAS_CONTENT_ASSIST = "HAS_CONTENT_ASSIST";
    private static final int operation_max_length = 64;
    public static final String HELP_ID_PREFIX = "com.ibm.cics.core.ui.view";

    public static void addRequiredControlDecoration(Control control) {
        DecoratorHelper.addRequiredControlDecoration((Control)control);
    }

    public static void addRequiredControlDecorationToLeft(Control control) {
        DecoratorHelper.addRequiredControlDecorationToLeft((Control)control);
    }

    public static void hideRequiredControlDecoration(Control control) {
        DecoratorHelper.hideRequiredControlDecoration((Control)control);
    }

    public static void showRequiredControlDecoration(Control control) {
        DecoratorHelper.showRequiredControlDecoration((Control)control);
    }

    public static void showRequiredControlDecoration(Control control, boolean show) {
        DecoratorHelper.showRequiredControlDecoration((Control)control, (boolean)show);
    }

    public static boolean hasContent(Text aText) {
        return aText.getText() != null && !aText.getText().trim().equals("");
    }

    public static boolean hasContent(String aString) {
        return aString != null && aString.trim().length() > 0;
    }

    @Deprecated
    public static void setButtonDimensionHint(Button button) {
        Utilities.setButtonDimensionHint((Button)button);
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        Utilities.PixelConverter converter = new Utilities.PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void recursiveSetEnabled(Composite aComposite, boolean enabled) {
        aComposite.setEnabled(enabled);
        Control[] controlArray = aComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control aControl = controlArray[n2];
            if (aControl instanceof Composite) {
                UIHelper.recursiveSetEnabled((Composite)aControl, enabled);
            } else if (!(aControl instanceof Label)) {
                aControl.setEnabled(enabled);
            }
            ++n2;
        }
    }

    public static void errorControl(Control aControl, String anErrorMessage) {
        DecoratorHelper.errorControl((Control)aControl, (String)anErrorMessage);
    }

    public static void warningControl(Control aControl, String warningMessage) {
        DecoratorHelper.warningControl((Control)aControl, (String)warningMessage);
    }

    public static void clearWarning(Control aControl) {
        DecoratorHelper.clearWarning((Control)aControl);
    }

    public static void clearError(Control aControl) {
        DecoratorHelper.clearError((Control)aControl);
    }

    public static boolean hasError(Control control) {
        return DecoratorHelper.hasError((Control)control);
    }

    public static void clearDirty(Control aControl) {
        aControl.setData(IS_DIRTY, null);
    }

    public static boolean isContentAssistAvailable(Control aControl) {
        return aControl.getData(HAS_CONTENT_ASSIST) == Boolean.TRUE;
    }

    public static void setContentAssistAvailable(Control aControl) {
        aControl.setData(HAS_CONTENT_ASSIST, (Object)Boolean.TRUE);
    }

    public static boolean isDirty(Control aControl) {
        return aControl.getData(IS_DIRTY) == Boolean.TRUE;
    }

    public static void setDirty(Control aControl) {
        aControl.setData(IS_DIRTY, (Object)true);
    }

    public static boolean isEmpty(Text aTextField) {
        return aTextField.getText() == null || aTextField.getText().trim().length() == 0;
    }

    public static String getDisplayName(CICSTypePropertySource propertySource, ICICSAttribute<?> attribute) {
        return propertySource.getPropertyDescriptor((Object)attribute.getPropertyId()).getDisplayName();
    }

    public static String getDisplayName(ICICSType<?> aCICSType, ICICSAttribute<?> attribute) {
        return new CICSTypePropertySource(aCICSType).getPropertyDescriptor((Object)attribute.getPropertyId()).getDisplayName();
    }

    public static void bindFieldLevelHelp(Control aControl, String fqContextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(aControl, fqContextId);
    }

    public static void bindFieldLevelHelp(Control aControl, ICICSAttribute<?> aCICSAttribute, ICICSType<?> cicsType) {
        String fieldLevelHelpContextId = UIHelper.getFieldLevelHelpContextId(aCICSAttribute, cicsType);
        UIHelper.bindFieldLevelHelp(aControl, fieldLevelHelpContextId);
    }

    public static String getFieldLevelHelpContextId(ICICSAttribute<?> aCICSAttribute, ICICSType<?> cicsType) {
        CICSTypePropertySource typePropertySource = new CICSTypePropertySource(cicsType);
        String helpContextId = typePropertySource.getTypeHelpContextId();
        if (aCICSAttribute != null) {
            helpContextId = (String)typePropertySource.getPropertyDescriptor((Object)aCICSAttribute.getPropertyId()).getHelpContextIds();
        }
        return helpContextId;
    }

    public static void setLabelVerticalTop(Label aLabel) {
        GridData data = new GridData();
        data.verticalAlignment = 128;
        aLabel.setLayoutData((Object)data);
    }

    public static void validateOperationText(Text operationText, String label) throws IllegalArgumentException {
        String regularExpression = "[a-zA-Z0-9._#@-]+";
        SimpleValidationHelper.validateMaxLength((String)operationText.getText(), (int)64, (String)label);
        SimpleValidationHelper.validateWhiteSpace((String)operationText.getText(), (String)"a-z, A-Z, 0-9, ._#@-", (String)label);
        SimpleValidationHelper.validateCharacters((String)operationText.getText(), (String)regularExpression, (String)"a-z, A-Z, 0-9, ._#@-", (String)label);
    }

    static String getHelpContextId(String viewId) {
        String[] results = viewId.split("\\.");
        return "com.ibm.cics.core.ui.view_" + results[results.length - 1];
    }
}

