/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ManagementPartType;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.sm.comm.IContext;
import java.util.List;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

abstract class AbstractManagementPartNodeDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(AbstractManagementPartNodeDeferredWorkbenchAdapter.class);

    public AbstractManagementPartNodeDeferredWorkbenchAdapter(CloudInput anInput) {
        super(anInput);
    }

    @Override
    public Object[] getDataChildren(Object inputElement) {
        DEBUG.enter("getDataChildren", (Object)this, inputElement);
        FilteredContext filteredContext = this.getFilteredContext();
        Object[] result = new Object[]{};
        try {
            List cicsObjects = this.getCICSObjects(ManagementPartType.getInstance(), (IContext)filteredContext);
            DEBUG.event("getDataChildren", String.valueOf(cicsObjects.size()) + " management parts");
            result = cicsObjects.toArray();
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() != null) {
                DEBUG.event("getDataChildren", (Object)e);
                result = new Object[]{new ErrorWrapper(e.getCause())};
            }
            DEBUG.error("getDataChildren", (Throwable)e);
        }
        DEBUG.exit("getDataChildren", (Object)result);
        return result;
    }

    protected abstract FilteredContext getFilteredContext();

    @Override
    public String getDecorateText(IDecorationContext context) {
        return "";
    }

    public boolean isContainer() {
        DEBUG.enter("isContainer", (Object)this);
        boolean result = true;
        DEBUG.exit("isContainer", (Object)result);
        return result;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        DEBUG.enter("getImageDescriptor", (Object)this, object);
        ImageDescriptor result = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        DEBUG.exit("getImageDescriptor", (Object)result);
        return result;
    }

    public String getLabel(Object o) {
        DEBUG.enter("getLabel", (Object)this, o);
        String result = CloudMessages.BundlesNodeName;
        DEBUG.exit("getLabel", (Object)result);
        return result;
    }

    @Override
    protected String getFetchingName() {
        return NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_management_parts, null);
    }

    public String toString() {
        return CloudMessages.BundlesNodeName;
    }
}

