/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.viewers;

import com.ibm.cics.core.model.IDescribable;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.viewers.ExplorerTreeContentProvider;
import com.ibm.cics.core.ui.views.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class CICSObjectTreeViewer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final CICSObjectTreeViewerContentProvider contentProvider;

    public CICSObjectTreeViewer(final TreeViewer viewer) {
        this.contentProvider = new CICSObjectTreeViewerContentProvider(viewer);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        ILabelDecorator labelDecorator = decoratorManager.getLabelDecorator();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new ExplorerLabelProvider(), labelDecorator);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.contentProvider.addUpdateCompleteListener(new ExplorerTreeContentProvider.Listener(){

            @Override
            public void updateComplete(ExplorerTreeContentProvider.ExplorerPendingUpdateAdapter adapter) {
                Tree tree = viewer.getTree();
                if (tree.getSelection().length == 0 && tree.getItemCount() == 1) {
                    tree.setSelection(tree.getItem(0));
                    tree.notifyListeners(13, new Event());
                }
            }
        });
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        return this.contentProvider.superAdapt(element);
    }

    private class CICSObjectTreeViewerContentProvider
    extends ExplorerTreeContentProvider {
        public CICSObjectTreeViewerContentProvider(TreeViewer viewer) {
            super(viewer);
        }

        protected IDeferredWorkbenchAdapter getAdapter(Object element) {
            return CICSObjectTreeViewer.this.getAdapter(element);
        }

        private final IDeferredWorkbenchAdapter superAdapt(Object element) {
            return super.getAdapter(element);
        }
    }

    private class ExplorerLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        private ExplorerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return Messages.getString("pending", new Object[0]);
            }
            IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter != null) {
                return adapter.getLabel(element);
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return UIPlugin.getImage(UIPlugin.IMGD_WAITING);
            }
            Image image = null;
            IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter != null) {
                image = UIPlugin.getImage(adapter.getImageDescriptor(element));
            }
            return image;
        }

        private IDeferredWorkbenchAdapter getAdapter(Object adaptable) {
            String adapterTypeName = IDeferredWorkbenchAdapter.class.getName();
            IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)Platform.getAdapterManager().loadAdapter(adaptable, adapterTypeName);
            return adapter;
        }

        public String getToolTipText(Object element) {
            if (element instanceof IDescribable) {
                return ((IDescribable)element).getDescription();
            }
            return super.getToolTipText(element);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 10);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }
    }
}

