/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.sm.comm.sm.internal.GraphQLArgument;
import com.ibm.cics.sm.comm.sm.internal.GraphQLQueryElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class GraphQLQueryNode
implements GraphQLQueryElement {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String name;
    private final List<GraphQLArgument> arguments;
    private final List<GraphQLQueryNode> fields;

    public GraphQLQueryNode(String name, List<GraphQLArgument> arguments, List<GraphQLQueryNode> fields) {
        if (name == null) {
            throw new IllegalStateException("Node name must not be null");
        }
        this.name = name;
        this.arguments = arguments != null ? arguments : Collections.emptyList();
        this.fields = fields != null ? fields : Collections.emptyList();
    }

    public static Builder newNode() {
        return new Builder();
    }

    public static Builder newNode(String name) {
        return new Builder().name(name);
    }

    public static Builder newQuery() {
        return new Builder().name("");
    }

    public String renderArguments() {
        return this.renderArguments(new StringBuilder()).toString();
    }

    private StringBuilder renderArguments(StringBuilder sb) {
        if (this.arguments.isEmpty()) {
            return sb;
        }
        sb.append("(");
        for (GraphQLArgument argument : this.arguments) {
            argument.render(sb);
            sb.append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(")");
        return sb;
    }

    public String renderFields() {
        StringBuilder sb = new StringBuilder();
        this.renderFields(sb);
        return sb.toString();
    }

    private void renderFields(StringBuilder sb) {
        if (this.fields.isEmpty()) {
            return;
        }
        boolean endingSpace = false;
        for (GraphQLQueryNode field : this.fields) {
            endingSpace = field.getFields().isEmpty();
            field.render(sb);
            if (!endingSpace) continue;
            sb.append(" ");
        }
        if (endingSpace) {
            sb.delete(sb.length() - 1, sb.length());
        }
    }

    @Override
    public void render(StringBuilder sb) {
        sb.append(this.name);
        this.renderArguments(sb);
        if (!this.fields.isEmpty()) {
            sb.append("{");
            this.renderFields(sb);
            sb.append("}");
        }
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        this.render(sb);
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public List<GraphQLArgument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public List<GraphQLQueryNode> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphQLQueryNode other = (GraphQLQueryNode)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "GraphQLQueryNode[" + this.name + "]";
    }

    public static class Builder {
        private String name;
        private List<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
        private List<GraphQLQueryNode> fields = new ArrayList<GraphQLQueryNode>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder arguments(List<GraphQLArgument> arguments) {
            this.arguments.addAll(arguments);
            return this;
        }

        public Builder argument(GraphQLArgument.Builder argument) {
            return this.argument(argument.build());
        }

        public Builder argument(GraphQLArgument argument) {
            this.arguments.add(argument);
            return this;
        }

        public Builder fields(List<GraphQLQueryNode> fields) {
            this.fields.addAll(fields);
            return this;
        }

        public Builder field(Builder builder) {
            return this.field(builder.build());
        }

        public Builder field(GraphQLQueryNode field) {
            this.fields.add(field);
            return this;
        }

        public GraphQLQueryNode build() {
            return new GraphQLQueryNode(this.name, this.arguments, this.fields);
        }
    }
}

