/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.IGenResourceTables;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface IResourceTables
extends IGenResourceTables {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    @Deprecated
    public static final String CPSM_DEFINITION_CPLEXDEF = "CPLEXDEF";
    @Deprecated
    public static final String DEFINITION_CICSPLEX = "CPLEXDEF";
    @Deprecated
    public static final String RESOURCE_MANAGED_REGION = "MAS";
    public static final String TOPOLOGY_PROGRAM = "CRESPRGM";
    public static final String TOPOLOGY_TERMNL = "CRESTERM";
    public static final String LIST_GROUP_ENTRY = "RESINDSC";

    public static class Helper
    extends IGenResourceTables.Helper {
        private static final Logger logger = Logger.getLogger(IResourceTables.class.getPackage().getName());
        private static String CICS_DEFINITION_PREFIX = "DEFINITION_";
        private static String CSD_DEFINITION_PREFIX = "CSD_DEFINITION_";
        private static String CPSM_DEFINITION_PREFIX = "CPSM_DEFINITION_";
        private static String CPSM_MANAGER_PREFIX = "MANAGER_";
        private static String CICS_RESOURCE_PREFIX = "RESOURCE_";
        private static String CPSM_CONFIG_DEFINITION_PREFIX = "CPSM_CONFIG_DEFINITION_";

        public static String[] values() {
            Field[] fields = IResourceTables.class.getFields();
            LinkedList<Object> staticFields = new LinkedList<Object>();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                String fieldName = field.getName();
                if (Modifier.isStatic(modifiers) && field.getType() == String.class && !Helper.isDeprecated(field) && (fieldName.startsWith(CICS_RESOURCE_PREFIX) || fieldName.startsWith(CICS_DEFINITION_PREFIX) || fieldName.startsWith(CPSM_DEFINITION_PREFIX) || fieldName.startsWith(CSD_DEFINITION_PREFIX) || fieldName.startsWith("GROUP_") || fieldName.startsWith(CPSM_MANAGER_PREFIX) || fieldName.startsWith(CPSM_CONFIG_DEFINITION_PREFIX))) {
                    try {
                        staticFields.add(field.get(null));
                    }
                    catch (Exception ex) {
                        logger.logp(Level.SEVERE, Helper.class.getName(), "values", ex.getLocalizedMessage(), ex);
                    }
                }
                ++i;
            }
            String[] values = new String[staticFields.size()];
            staticFields.toArray(values);
            return values;
        }

        public static boolean isCICSDefinition(String resourceType) {
            return Helper.fieldExistsWithPrefix(CICS_DEFINITION_PREFIX, resourceType);
        }

        public static boolean isCSDDefinition(String resourceType) {
            return Helper.fieldExistsWithPrefix(CSD_DEFINITION_PREFIX, resourceType);
        }

        public static boolean isCPSMDefinition(String resourceType) {
            return Helper.fieldExistsWithPrefix(CPSM_DEFINITION_PREFIX, resourceType);
        }

        public static boolean isCPSMManager(String resourceType) {
            return Helper.fieldExistsWithPrefix(CPSM_MANAGER_PREFIX, resourceType);
        }

        public static boolean isCICSResource(String resourceType) {
            return Helper.fieldExistsWithPrefix(CICS_RESOURCE_PREFIX, resourceType);
        }

        public static boolean isCPSMConfigurationDefinition(String resourceType) {
            return Helper.fieldExistsWithPrefix(CPSM_CONFIG_DEFINITION_PREFIX, resourceType);
        }

        private static boolean fieldExistsWithPrefix(String prefix, String name) {
            boolean result = false;
            String fieldName = String.valueOf(prefix) + name;
            try {
                Field field = IResourceTables.class.getField(fieldName);
                if (!Helper.isDeprecated(field)) {
                    result = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        private static boolean isDeprecated(Field field) {
            return field.isAnnotationPresent(Deprecated.class);
        }
    }
}

