/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.explorer.tables.ui.MessageHelper;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.ISMUpdateException;
import com.ibm.cics.sm.comm.SMUpdateConflictException;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.context.IGroupContext;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ExceptionMessageHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ExceptionMessageHelper.class.getPackage().getName());

    public static IStatus getStatus(CICSActionException ex, ICICSType<?> cicsType, int severity) {
        IStatus result = null;
        if (ex.getCause() instanceof SystemManagerConnectionException) {
            SystemManagerConnectionException connectionException = (SystemManagerConnectionException)ex.getCause();
            result = ExceptionMessageHelper.getStatus(connectionException, cicsType, severity);
        } else if (ex.getCause() instanceof ISMUpdateException) {
            ISMUpdateException updateException = (ISMUpdateException)ex.getCause();
            result = ExceptionMessageHelper.getStatus(updateException, cicsType, severity);
        }
        if (result == null) {
            logger.logp(Level.WARNING, ExceptionMessageHelper.class.getName(), "getStatus()", "Could not diagnose the supplied exception", ex);
            result = ExceptionMessageHelper.getUnknownStatus((Object)ex, severity);
        }
        return result;
    }

    @Deprecated
    public static IStatus getStatus(CICSSystemManagerException ex, ICICSType<?> cicsType) {
        return ExceptionMessageHelper.getStatus((CICSActionException)((Object)ex), cicsType, 2);
    }

    public static IStatus getStatus(SystemManagerConnectionException ex, ICICSType<?> cicsType, int severity) {
        return MessageHelper.getStatus((SystemManagerConnectionException)ex, cicsType, (int)severity);
    }

    @Deprecated
    public static IStatus getStatus(SystemManagerConnectionException ex, ICICSType<?> cicsType) {
        return ExceptionMessageHelper.getStatus(ex, cicsType, 2);
    }

    public static String getAttributeWithReasonErrorMessage(ICICSType<?> cicsType, ICICSAttribute<?> attribute, String errorLabel, String resp, int resp2, String function) {
        return MessageHelper.getAttributeWithReasonErrorMessage(cicsType, attribute, (String)errorLabel, (String)resp, (int)resp2, (String)function);
    }

    public static String getAttributeWithReasonErrorMessage(ICICSType<?> cicsType, ICICSAttribute<?> attribute, String errorLabel, String resp, int resp2) {
        return MessageHelper.getAttributeWithReasonErrorMessage(cicsType, attribute, (String)errorLabel, (String)resp, (int)resp2);
    }

    public static String getAttributeErrorMessage(ICICSType<?> cicsType, ICICSAttribute<?> attribute, String errorLabel) {
        return MessageHelper.getAttributeErrorMessage(cicsType, attribute, (String)errorLabel);
    }

    public static String getCPSMErrorMessage(String response, String reason) {
        Object[] inserts = new Object[]{response, reason};
        return Messages.getString("error.cpsm", inserts);
    }

    public static String getCPSMErrorMessage(SystemManagerConnectionException ex) {
        return MessageHelper.getCPSMErrorMessage((SystemManagerConnectionException)ex);
    }

    public static String getHTTPErrorMessage(String httpError, int httpErrorCode, URL url) {
        return MessageHelper.getHTTPErrorMessage((String)httpError, (int)httpErrorCode, (URL)url);
    }

    public static String getPerformErrorMessage(String eibfn, String resp, int resp2) {
        return MessageHelper.getPerformErrorMessage((String)eibfn, (String)resp, (int)resp2);
    }

    public static IStatus getUnknownStatus(Object o, int severity) {
        return new Status(severity, "com.ibm.cics.core.ui", 0, MessageHelper.getUnknownErrorString((Object)o), null);
    }

    @Deprecated
    public static IStatus getStatus(ISMUpdateException updateException, ICICSType<?> cicsType) {
        return ExceptionMessageHelper.getStatus(updateException, cicsType, 2);
    }

    public static IStatus getStatus(ISMUpdateException updateException, ICICSType<?> cicsType, int severity) {
        if (updateException.hasErrors()) {
            ISMUpdateException.IError error = (ISMUpdateException.IError)updateException.getErrors().get(0);
            String attributeName = (String)error.getAttributeNames().get(0);
            ICICSAttribute attribute = cicsType.findAttributeByCicsName(attributeName);
            String message = ExceptionMessageHelper.getAttributeWithReasonErrorMessage(cicsType, attribute, attributeName, updateException.getRESP(), updateException.getRESP2(), updateException.getEibFunctionName());
            return new Status(severity, "com.ibm.cics.core.ui", message);
        }
        if (updateException instanceof SMUpdateConflictException) {
            return new Status(severity, "com.ibm.cics.core.ui", Messages.getString("ExceptionMessageHelper.updateConflict"));
        }
        return ExceptionMessageHelper.getUnknownStatus(updateException, severity);
    }

    public static String getContextOrScopeNameFor(ICoreObject coreObject) {
        IPrimaryKey primaryKey = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
        IContext parentContext = primaryKey.getParentContext();
        if (parentContext instanceof IGroupContext) {
            parentContext = ((IGroupContext)parentContext).getParentContext();
        }
        return ExceptionMessageHelper.getContextOrScopeNameFor(parentContext);
    }

    public static String getContextOrScopeNameFor(IContext context) {
        return ContextHelper.getContextOrScopeNameFor((IContext)context);
    }

    public static String getObjectTypeDescription(ICICSObject cicsObject) {
        return ExceptionMessageHelper.getTypeDescription(cicsObject.getCICSType());
    }

    public static String getTypeDescription(ICICSType<?> cicsType) {
        return Messages.getTableDescription(cicsType.getResourceTableName());
    }
}

