/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.table;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.views.ColumnDialog;
import com.ibm.cics.core.ui.views.ResourcesViewColumnDialog;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ColumnSelectionDialog
extends ColumnDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String viewTitle;
    private final ILabelProvider labelProvider;
    private final PropertyManager<?> propertyManager;

    public static <T> ColumnSelectionDialog create(Shell parent, String viewTitle, Set<T> available, List<T> displayed, List<T> defaults, ILabelProvider labelProvider) {
        return new ColumnSelectionDialog(parent, viewTitle, new PropertyManager<T>(available, displayed, defaults), labelProvider);
    }

    private ColumnSelectionDialog(Shell parentShell, String viewTitle, PropertyManager<?> propertyManager, ILabelProvider labelProvider) {
        super(parentShell);
        this.propertyManager = propertyManager;
        this.labelProvider = labelProvider;
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"<init>", (Object)parentShell);
        this.viewTitle = viewTitle;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        Debug.exit((Logger)logger, (String)ResourcesViewColumnDialog.class.getName(), (String)"<init>", (Object)((Object)this));
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.availableColumnsTreeViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        this.availableColumnsTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !((PropertyManager)ColumnSelectionDialog.this.propertyManager).displayed.contains(element);
            }
        });
        return c;
    }

    void add(IStructuredSelection selection) {
        List<Object> elements = Arrays.asList(selection.toArray());
        this.propertyManager.add(elements);
        this.availableColumnsTreeViewer.refresh();
        this.currentlyUsedColumnsTreeViewer.refresh();
    }

    void remove(IStructuredSelection selection) {
        List<Object> elements = Arrays.asList(selection.toArray());
        this.propertyManager.remove(elements);
        this.availableColumnsTreeViewer.refresh();
        this.currentlyUsedColumnsTreeViewer.refresh();
    }

    @Override
    public void reset() {
        this.propertyManager.reset();
        this.availableColumnsTreeViewer.refresh();
        this.currentlyUsedColumnsTreeViewer.refresh();
    }

    @Override
    public String getViewTitle() {
        return this.viewTitle;
    }

    @Override
    public String getAvailableAttributesString() {
        return Messages.getString("ColumnSelectionDialog_AvailableProperties");
    }

    @Override
    public String getCurrentlyUsedAttributesString() {
        return Messages.getString("ColumnSelectionDialog_DisplayedProperties");
    }

    @Override
    public ITreeContentProvider getAvailableTreeContentProvider() {
        return new ColumnDialog.FlatTreeContentProvider(this){

            public Object[] getElements(Object inputElement) {
                return ((PropertyManager)ColumnSelectionDialog.this.propertyManager).available.toArray();
            }
        };
    }

    @Override
    public ITreeContentProvider getCurrentlyUsedTreeContentProvider() {
        return new ColumnDialog.FlatTreeContentProvider(this){

            public Object[] getElements(Object inputElement) {
                return ((PropertyManager)ColumnSelectionDialog.this.propertyManager).displayed.toArray();
            }
        };
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public Object getAvailableTreeInput() {
        return new Object();
    }

    @Override
    public Object getCurrentlyUsedTreeInput() {
        return new Object();
    }

    @Override
    public String getAddButtonText() {
        return Messages.getString("ColumnSelectionDialog_Add");
    }

    @Override
    public String getRemoveButtonText() {
        return Messages.getString("ColumnSelectionDialog_Remove");
    }

    @Override
    public SelectionAdapter getAvailableSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnSelectionDialog.this.addButton.setEnabled(!ColumnSelectionDialog.this.availableColumnsTreeViewer.getSelection().isEmpty());
            }
        };
    }

    @Override
    public SelectionAdapter getCurrentlyUsedSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnSelectionDialog.this.removeButton.setEnabled(ColumnSelectionDialog.this.hasColumnsToRemove());
            }
        };
    }

    @Override
    public SelectionAdapter getAddButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ColumnSelectionDialog.this.availableColumnsTreeViewer.getSelection();
                ColumnSelectionDialog.this.add(selection);
            }
        };
    }

    @Override
    public SelectionAdapter getRemoveButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ColumnSelectionDialog.this.currentlyUsedColumnsTreeViewer.getSelection();
                ColumnSelectionDialog.this.remove(selection);
            }
        };
    }

    private boolean hasColumnsToRemove() {
        return this.currentlyUsedColumnsTreeViewer.getTree().getSelectionCount() >= 1;
    }

    Tree getAvailableColumnsTree() {
        return this.availableColumnsTreeViewer.getTree();
    }

    Tree getCurrentlyUsedColumnsTree() {
        return this.currentlyUsedColumnsTreeViewer.getTree();
    }

    public static abstract class ColumnSelectionDialogList<E>
    implements List<E> {
        @Override
        public void add(int location, E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int location, Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E get(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOf(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int location, E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<E> subList(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            throw new UnsupportedOperationException();
        }
    }

    private static class PropertyManager<E> {
        private final Set<E> available;
        private final List<E> displayed;
        private final List<E> defaults;

        public PropertyManager(Set<E> available, List<E> displayed, List<E> defaults) {
            this.available = Collections.unmodifiableSet(available);
            this.displayed = displayed;
            this.defaults = defaults;
        }

        public void reset() {
            this.displayed.clear();
            this.displayed.addAll(this.defaults);
        }

        public void add(Collection<? extends E> elements) {
            this.displayed.addAll(elements);
        }

        public void remove(Collection<? extends E> elements) {
            this.displayed.removeAll(elements);
        }
    }
}

