/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.eclipse.common.historical.IHistoricalTransaction;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ILocalTransaction;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.model.ITask;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.IScopedContext;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdapterFactory;

public class HistoricalTransactionFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(HistoricalTransactionFactory.class.getPackage().getName());
    private static final Class[] ADAPTER_TYPES = new Class[]{IHistoricalTransaction.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof ILocalTransaction && adapterType.equals(IHistoricalTransaction.class)) {
            final ICoreObject coreObject = (ICoreObject)adaptableObject;
            final String name = ((ILocalTransaction)coreObject).getName();
            final String region = ((ILocalTransaction)coreObject).getRegionName();
            return new IHistoricalTransaction(){

                public String getTransactionName() {
                    return name;
                }

                public String getApplid() {
                    Debug.enter((Logger)logger, (String)HistoricalTransactionFactory.class.getName(), (String)"getAdapter.getApplid");
                    ICPSM cpsm = coreObject.getCPSM();
                    IScopedContext scopedContext = (IScopedContext)((IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class)).getParentContext();
                    RegionType.getInstance();
                    IPrimaryKey primaryKey = RegionType.getPrimaryKey((IContext)scopedContext);
                    IRegion relatedRegion = null;
                    try {
                        relatedRegion = (IRegion)cpsm.get((ICICSType)RegionType.getInstance(), primaryKey);
                    }
                    catch (CICSSystemManagerException ex) {
                        logger.logp(Level.WARNING, HistoricalTransactionFactory.class.getName(), "getAdapter.getApplid", "CICSSystemManagerException for " + region, ex);
                        return null;
                    }
                    Debug.exit((Logger)logger, (String)HistoricalTransactionFactory.class.getName(), (String)"getAdapter.getApplid", (Object)relatedRegion.getApplID());
                    return relatedRegion.getApplID();
                }

                public boolean isTransactionInstance() {
                    return region != null;
                }
            };
        }
        if (adaptableObject instanceof ITask && adapterType.equals(IHistoricalTransaction.class)) {
            final ICoreObject coreObject = (ICoreObject)adaptableObject;
            final String name = ((ITask)coreObject).getTransactionID();
            final String region = ((ITask)coreObject).getRegionName();
            return new IHistoricalTransaction(){

                public String getTransactionName() {
                    return name;
                }

                public String getApplid() {
                    Debug.enter((Logger)logger, (String)HistoricalTransactionFactory.class.getName(), (String)"getAdapter.getApplid");
                    ICPSM cpsm = coreObject.getCPSM();
                    IScopedContext scopedContext = (IScopedContext)((IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class)).getParentContext();
                    RegionType.getInstance();
                    IPrimaryKey primaryKey = RegionType.getPrimaryKey((IContext)scopedContext);
                    IRegion relatedRegion = null;
                    try {
                        relatedRegion = (IRegion)cpsm.get((ICICSType)RegionType.getInstance(), primaryKey);
                    }
                    catch (CICSSystemManagerException ex) {
                        logger.logp(Level.WARNING, HistoricalTransactionFactory.class.getName(), "getAdapter.getApplid", "CICSSystemManagerException for " + region, ex);
                        return null;
                    }
                    Debug.exit((Logger)logger, (String)HistoricalTransactionFactory.class.getName(), (String)"getAdapter.getApplid", (Object)relatedRegion.getApplID());
                    return relatedRegion.getApplID();
                }

                public boolean isTransactionInstance() {
                    return region != null;
                }
            };
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_TYPES;
    }
}

