/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.internal.ConnectionsXMLSerializer;
import com.ibm.cics.core.connections.internal.IConnectionSerializer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class FileConnectionXMLSerializer
implements IConnectionSerializer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IPath location;

    public FileConnectionXMLSerializer(IPath location) {
        this.location = location;
    }

    @Override
    public void save(List<ConnectionParameters> connections) throws IOException {
        if (this.location.toFile().exists() && !this.location.toFile().delete()) {
            throw new IOException("couldn't delete existing file: " + this.location);
        }
        File parentFile = this.location.toFile().getParentFile();
        if (parentFile == null) {
            throw new IOException("Couldn't determine parent for location: " + this.location);
        }
        parentFile.mkdirs();
        try (OutputStream os = null;){
            os = new FileOutputStream(new File(this.location.toOSString()));
            os = new BufferedOutputStream(os);
            ConnectionsXMLSerializer.write(connections, os);
        }
    }

    public String toString() {
        return "FileConnectionXMLSerializer [location=" + this.location + "]";
    }
}

