/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class SSLProtocolEnablerDecorator
extends SSLSocketFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final SSLSocketFactory sslSocketFactory;
    private boolean enableProtocols;
    private static final List<String> PROPOSED_SECURE_PROTOCOLS = Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2");
    private static final List<String> FORBIDDEN_PROTOCOLS = Arrays.asList("SSLv3");
    private static final Debug debug = new Debug(SSLProtocolEnablerDecorator.class);

    SSLProtocolEnablerDecorator(SSLSocketFactory sslSocketFactory, boolean enableProtocols) {
        this.sslSocketFactory = sslSocketFactory;
        this.enableProtocols = enableProtocols;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, host, port, autoClose);
        List<String> toEnableProtocols = this.getEnabledProtocols(sslSocket);
        sslSocket.setEnabledProtocols(toEnableProtocols.toArray(new String[toEnableProtocols.size()]));
        debug.event("setUpSSlContextAndInitialiseHostnameVerifier.SSLSocketFactory.createSocket", SSLProtocolEnablerDecorator.getPrintableEnabledProtocols(sslSocket));
        return sslSocket;
    }

    private List<String> getEnabledProtocols(SSLSocket socket) {
        ArrayList<String> toBeEnabledProtocols = new ArrayList<String>(Arrays.asList(socket.getEnabledProtocols()));
        if (this.enableProtocols) {
            for (String toEnable : this.getAvailableSecureProtocols(socket)) {
                if (toBeEnabledProtocols.contains(toEnable)) continue;
                toBeEnabledProtocols.add(toEnable);
                debug.info("getEnabledProtocols", (Object)("Enabled protocol: " + toEnable));
            }
        }
        for (String forbiddenProtocol : FORBIDDEN_PROTOCOLS) {
            if (!toBeEnabledProtocols.remove(forbiddenProtocol)) continue;
            debug.info("getEnabledProtocols", (Object)("Disabled protocol: " + forbiddenProtocol));
        }
        return toBeEnabledProtocols;
    }

    private List<String> getAvailableSecureProtocols(SSLSocket socket) {
        List<String> supportedProtocols = Arrays.asList(socket.getSupportedProtocols());
        ArrayList<String> unsupported = new ArrayList<String>(PROPOSED_SECURE_PROTOCOLS);
        ArrayList<String> secureProtocols = new ArrayList<String>(PROPOSED_SECURE_PROTOCOLS);
        unsupported.removeAll(supportedProtocols);
        if (unsupported.size() > 0) {
            String message = "Your Java Runtime Environment does not support the secure protocols " + SSLProtocolEnablerDecorator.getPrintableProtocols(unsupported);
            debug.error("createSocket", message);
            secureProtocols.removeAll(unsupported);
        }
        return secureProtocols;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
        return this.sslSocketFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return this.sslSocketFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
        return this.sslSocketFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return this.sslSocketFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    private static String getPrintableEnabledProtocols(SSLSocket socket) {
        StringBuffer sb = new StringBuffer();
        sb.append("Enabled protocols for this socket: [");
        sb.append(SSLProtocolEnablerDecorator.getPrintableProtocols(Arrays.asList(socket.getEnabledProtocols())));
        sb.append("]");
        return sb.toString();
    }

    private static String getPrintableProtocols(List<String> protocols) {
        StringBuffer sb = new StringBuffer();
        for (String pro : protocols) {
            sb.append(pro);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }
}

