/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.sm.comm.IApplicationContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.ParameterisedContext;

public class ApplicationContext
extends ParameterisedContext
implements IApplicationContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public ApplicationContext(IContext parentContext, String platformName, String applicationName, long applicationMajorVersion, long applicationMinorVersion, long applicationMicroVersion) {
        super(parentContext);
        this.setParameterValue("PLATFORM", platformName);
        this.setParameterValue("APPLICATION", applicationName);
        this.setParameterValue("APPLMAJORVER", Long.toString(applicationMajorVersion));
        this.setParameterValue("APPLMINORVER", Long.toString(applicationMinorVersion));
        this.setParameterValue("APPLMICROVER", Long.toString(applicationMicroVersion));
    }

    public ApplicationContext(IContext parentContext, IPlatform platform, IApplication application) {
        this(parentContext, platform.getName(), application.getName(), application.getMajorVersion(), application.getMinorVersion(), application.getMicroVersion());
    }

    @Override
    public String getPlatformName() {
        return this.getParameterValue("PLATFORM");
    }

    @Override
    public String getApplicationName() {
        return this.getParameterValue("APPLICATION");
    }

    @Override
    public Long getApplicationMajorVersion() {
        return Long.parseLong(this.getParameterValue("APPLMAJORVER"));
    }

    @Override
    public Long getApplicationMinorVersion() {
        return Long.parseLong(this.getParameterValue("APPLMINORVER"));
    }

    @Override
    public Long getApplicationMicroVersion() {
        return Long.parseLong(this.getParameterValue("APPLMICROVER"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ApplicationContext) {
            ApplicationContext objAC = (ApplicationContext)obj;
            if (ApplicationContext.isApplicationContextTheSame(objAC, this)) {
                IContext objParent = objAC.getParentContext();
                IContext thisParent = this.getParentContext();
                if (thisParent != null && objParent != null) {
                    return thisParent.equals(objParent);
                }
                if (thisParent != null || objParent != null) {
                    return false;
                }
                return super.equals(obj);
            }
            return false;
        }
        return false;
    }

    public static boolean isApplicationContextTheSame(IApplicationContext ac1, IApplicationContext ac2) {
        if (ac1 == null && ac2 == null) {
            return true;
        }
        if (ac1 == null || ac2 == null) {
            return false;
        }
        return ac1.getPlatformName().equals(ac2.getPlatformName()) && ac1.getApplicationName().equals(ac2.getApplicationName()) && ac1.getApplicationMajorVersion() == ac2.getApplicationMajorVersion() && ac1.getApplicationMinorVersion() == ac2.getApplicationMinorVersion() && ac1.getApplicationMicroVersion() == ac2.getApplicationMicroVersion();
    }
}

