/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConfigurationUtils;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.internal.IConnectionParameters;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConnectionProfile
implements IConnectionParameters {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013, 2021 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ConnectionParameters connectionParameters;
    private final CredentialsConfiguration credentials;
    private final IConnectionDescriptor descriptor;
    private final IConnectionProvider provider;
    private static final Set<String> nonExtendedAttributes = new HashSet<String>();

    static {
        nonExtendedAttributes.add("host");
        nonExtendedAttributes.add("port");
        nonExtendedAttributes.add("ssl_confirmed");
        nonExtendedAttributes.add("ATTEMPT_SECURE");
    }

    public ConnectionProfile(ConnectionParameters connectionParameters, IConnectionDescriptor descriptor, CredentialsConfiguration credentials, IConnectionProvider provider) {
        this.connectionParameters = connectionParameters;
        this.descriptor = descriptor;
        this.credentials = credentials;
        this.provider = provider;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        ConnectionConfiguration config = new ConnectionConfiguration(this.getId(), this.getName(), ConfigurationUtils.getHost(this), ConfigurationUtils.getPort(this), this.credentials != null ? this.credentials.getID() : "");
        if (this.credentials != null) {
            config.setUserID(this.credentials.getUserID());
            config.setPassword(this.credentials.getPassword());
            config.setCertificateDetails(this.credentials.getCertificate());
            config.setIsOneTimePassword(this.credentials.isOneTimePassword());
        }
        config.setSecureHint(ConfigurationUtils.isSecureHint(this));
        config.setSslConfirmation(ConfigurationUtils.isSecureConfirmed(this));
        for (Map.Entry<String, String> attribute : this.getAttributes().entrySet()) {
            if (!this.isExtendedAttribute(attribute.getKey())) continue;
            config.setExtendedAttribute(attribute.getKey(), attribute.getValue());
        }
        return config;
    }

    private boolean isExtendedAttribute(String key) {
        return !nonExtendedAttributes.contains(key);
    }

    public IConnectionDescriptor getConnectionDescriptor() {
        return this.descriptor;
    }

    public String getId() {
        return this.connectionParameters.getId();
    }

    @Override
    public String getName() {
        return this.connectionParameters.getName();
    }

    @Override
    public String getAttribute(String attributeName) {
        return this.connectionParameters.getAttribute(attributeName);
    }

    public CredentialsConfiguration getCredentials() {
        return this.credentials;
    }

    public IConnectionProvider getConnectionProvider() {
        return this.provider;
    }

    public ConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getAttribute("host"));
        buffer.append(":");
        buffer.append(this.getAttribute("port"));
        buffer.append(" - ");
        if (this.credentials != null) {
            buffer.append(this.credentials.getUserID());
        }
        return buffer.toString();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.connectionParameters.getAttributes();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.credentials == null ? 0 : this.credentials.hashCode());
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.connectionParameters == null ? 0 : this.connectionParameters.hashCode());
        result = 31 * result + (this.provider == null ? 0 : this.provider.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionProfile other = (ConnectionProfile)obj;
        if (this.credentials == null ? other.credentials != null : !this.credentials.equals((Object)other.credentials)) {
            return false;
        }
        if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
            return false;
        }
        if (this.connectionParameters == null ? other.connectionParameters != null : !this.connectionParameters.equals(other.connectionParameters)) {
            return false;
        }
        return !(this.provider == null ? other.provider != null : !this.provider.equals(other.provider));
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.connectionParameters.getName() + " (" + this.getAttribute("host") + ":" + this.getAttribute("port") + ")" + " ]";
    }
}

