/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.common.util.StaleableEventListener;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionProfile;

public abstract class ConnectionServiceListener
extends StaleableEventListener<ConnectionServiceEvent> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static class ConnectedEvent
    extends ConnectionServiceEvent {
        public ConnectedEvent(IConnectionCategory category, IConnectable connectable, ConnectionProfile connectionProfile) {
            super(category, connectable, connectionProfile);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class ConnectingEvent
    extends ConnectionServiceEvent {
        public ConnectingEvent(IConnectionCategory category, IConnectable connectable, ConnectionProfile connectionProfile) {
            super(category, connectable, connectionProfile);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static abstract class ConnectionServiceEvent {
        private final String connectionCategoryId;
        private final IConnectable connectable;
        private final ConnectionProfile connectionProfile;

        protected ConnectionServiceEvent(IConnectionCategory category, IConnectable connectable, ConnectionProfile connectionProfile) {
            this.connectionCategoryId = category.getId();
            this.connectable = connectable;
            this.connectionProfile = connectionProfile;
        }

        public IConnectable getConnectable() {
            return this.connectable;
        }

        public String getConnectionCategoryId() {
            return this.connectionCategoryId;
        }

        public ConnectionProfile getConnectionProfile() {
            return this.connectionProfile;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.connectable == null ? 0 : this.connectable.hashCode());
            result = 31 * result + (this.connectionCategoryId == null ? 0 : this.connectionCategoryId.hashCode());
            result = 31 * result + (this.connectionProfile == null ? 0 : this.connectionProfile.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ConnectionServiceEvent)) {
                return false;
            }
            ConnectionServiceEvent other = (ConnectionServiceEvent)obj;
            if (this.connectable == null ? other.connectable != null : !this.connectable.equals(other.connectable)) {
                return false;
            }
            if (this.connectionCategoryId == null ? other.connectionCategoryId != null : !this.connectionCategoryId.equals(other.connectionCategoryId)) {
                return false;
            }
            return !(this.connectionProfile == null ? other.connectionProfile != null : !this.connectionProfile.equals(other.connectionProfile));
        }
    }

    public static class DisconnectedEvent
    extends ConnectionServiceEvent {
        public DisconnectedEvent(IConnectionCategory category, IConnectable connectable, ConnectionProfile connectionProfile) {
            super(category, connectable, connectionProfile);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class DisconnectingEvent
    extends ConnectionServiceEvent {
        private boolean vetoed = false;

        public DisconnectingEvent(IConnectionCategory category, IConnectable connectable, ConnectionProfile connectionProfile) {
            super(category, connectable, connectionProfile);
        }

        public void veto() {
            this.vetoed = true;
        }

        public boolean isVetoed() {
            return this.vetoed;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class ExceptionEvent
    extends ConnectionServiceEvent {
        private final Exception exception;

        public ExceptionEvent(IConnectionCategory category, IConnectable connectable, ConnectionProfile connectionProfile, Exception exception) {
            super(category, connectable, connectionProfile);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

