/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.CertificateComposite;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.PasswordComposite;
import com.ibm.cics.core.connections.internal.PasswordDialog;
import com.ibm.cics.core.connections.internal.UsernameAndPasswordComposite;
import com.ibm.cics.eclipse.common.editor.TitleAreaDialogErrorStateManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractCredentialDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    ICredentialsManager credentialsManager;
    CredentialsConfiguration credentialsConfiguration;
    TitleAreaDialogErrorStateManager errorStateManager = new TitleAreaDialogErrorStateManager((TitleAreaDialog)this);
    PasswordComposite passwordComposite;
    UsernameAndPasswordComposite usernameAndPasswordComposite;
    UsernameAndPasswordComposite oneTimePasswordComposite;
    CertificateComposite keystoreComposite;
    CertificateComposite smartcardComposite;
    CredentialsMode credentialsMode;

    public AbstractCredentialDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        this.getShell().setText(this.getShellText());
        this.setTitleImage(ConnectionsImages.getImage("PASSWORD_WIZ_BAN"));
        this.setTitle(this.getTitle());
        this.setMessage(this.getTitleMessage());
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.validate(null);
        return c;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void validate(Widget widgetEventOriginatedFrom) {
        this.errorStateManager.clearErrors();
        this.getButton(0).setEnabled(true);
        this.setMessage(this.getTitleMessage());
        if (this.shouldValidate()) {
            boolean error = false;
            switch (this.passwordComposite.getCredentialType()) {
                case ONETIMEPASSWORD: {
                    break;
                }
                case PASSWORD: {
                    this.validatePassword();
                    break;
                }
                case KEYSTORE: {
                    error = this.keystoreComposite.validateCertificate(this.errorStateManager, widgetEventOriginatedFrom);
                    break;
                }
                case SMARTCARD: {
                    error = this.smartcardComposite.validateCertificate(this.errorStateManager, widgetEventOriginatedFrom);
                    break;
                }
            }
            this.passwordComposite.getCredentialType();
            error = error || this.validateUserId() || this.validateCredentialsName();
            this.getButton(0).setEnabled(!error);
        }
    }

    private boolean shouldValidate() {
        if (this instanceof PasswordDialog) {
            return this.credentialsMode == CredentialsMode.AUTHENTICATE_CREDENTIAL || this.credentialsMode == CredentialsMode.CREATE_FIRST_CREDENTIAL || this.passwordComposite.shouldCreateNewCredentials();
        }
        return true;
    }

    private boolean validateCredentialsName() {
        boolean error = false;
        if (this.passwordComposite.getCurrentCredentialsComposite().getCredentialsText() != null) {
            if (StringUtil.isEmpty((String)this.passwordComposite.getCurrentCredentialsComposite().getCredentialsName())) {
                this.errorStateManager.recordSevereError(Messages.CredentialsPreferencePage_invalidName, (Control)this.passwordComposite.getCurrentCredentialsComposite().getCredentialsText());
                error = true;
            } else if (this.isDuplicateInList(this.passwordComposite.getCurrentCredentialsComposite().getCredentialsName())) {
                this.errorStateManager.recordSevereError(Messages.CredentialsPreferencePage_duplicateName, (Control)this.passwordComposite.getCurrentCredentialsComposite().getCredentialsText());
                error = true;
            }
        }
        return error;
    }

    private boolean validateUserId() {
        boolean error = false;
        if (StringUtil.isEmpty((String)this.passwordComposite.getCurrentCredentialsComposite().getUserID())) {
            this.errorStateManager.recordSevereError(Messages.CredentialsDialog_mandatoryUserID, (Control)this.passwordComposite.getCurrentCredentialsComposite().getUserIdText());
            error = true;
        }
        return error;
    }

    private void validatePassword() {
        if (this.usernameAndPasswordComposite.getSavePasswordButton().getSelection()) {
            this.setMessage(Messages.PasswordComposite_savePasswordDescription, 2);
        } else {
            this.setMessage(this.getTitleMessage());
        }
    }

    boolean isDuplicateInList(String newName) {
        for (CredentialsConfiguration credential : this.credentialsManager.getAllCredentials()) {
            if (!newName.equals(credential.getName())) continue;
            if (this.credentialsConfiguration != null) {
                if (this.credentialsConfiguration.getID().equals(credential.getID())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    protected void addSelectionListener() {
        this.usernameAndPasswordComposite.getSavePasswordButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCredentialDialog.this.validatePassword();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    abstract String getHelpContextId();

    abstract String getShellText();

    abstract String getTitle();

    abstract String getTitleMessage();
}

